/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bpm.log.Log;
import oracle.bpm.log.LogComponent;
import org.jetbrains.annotations.NotNull;

public final class Trace {
    @NotNull
    private final String id;
    @NotNull
    private final Logger logger;
    private static final Map<String, Trace> traces = new HashMap<String, Trace>();

    private Trace(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/log/Trace.<init> must not be null");
        }
        this.id = id;
        this.logger = LogComponent.findLogComponent(id).logger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Trace getInstance(@NotNull String id) {
        Trace trace;
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/log/Trace.getInstance must not be null");
        }
        Map<String, Trace> map = traces;
        synchronized (map) {
            trace = traces.get(id);
            if (trace == null) {
                trace = new Trace(id);
                traces.put(id, trace);
            }
        }
        Trace trace2 = trace;
        if (trace2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/log/Trace.getInstance must not return null");
        }
        return trace2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Trace getInstance(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/log/Trace.getInstance must not be null");
        }
        Trace trace = Trace.getInstance(clazz.getName());
        if (trace == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/log/Trace.getInstance must not return null");
        }
        return trace;
    }

    public boolean isEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public void log(String message) {
        Log.logTrace(message);
    }

    public void log(@NotNull String message, @NotNull Throwable e) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/log/Trace.log must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/log/Trace.log must not be null");
        }
        ByteArrayOutputStream is = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(is));
        this.log(message + "\nException:\n" + new String(is.toByteArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/log/Trace.getId must not return null");
        }
        return string;
    }
}

