/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.LocaleSupportMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.locale.LocaleService;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.locale.LocaleSupportImpl;
import oracle.bpm.util.Locales;

public class DefaultLocaleService
implements LocaleService {
    private LocaleSupport defaultLocale;
    private LocaleSupport projectDefaultLocale;
    private Map<Locale, LocaleSupport> supportByLocale = Collections.synchronizedMap(new HashMap());
    private List<LocaleSupport> supportedIdeLocales = new ArrayList<LocaleSupport>();
    private List<LocaleSupport> supportedLocales = new ArrayList<LocaleSupport>();

    public DefaultLocaleService() {
        this.loadLocales();
        this.selectActiveLocale();
    }

    @Override
    public LocaleSupport getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public LocaleSupport getProjectDefaultLocale() {
        return this.projectDefaultLocale;
    }

    @Override
    public List<LocaleSupport> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public List<LocaleSupport> getSupportedIdeLocales() {
        return this.supportedIdeLocales;
    }

    @Override
    public LocaleSupport getSupportForLocale(Locale locale) {
        LocaleSupport result = this.supportByLocale.get(locale);
        if (result == null) {
            LocaleSupport bestMatch = this.findBestMatchFor(locale);
            if (bestMatch == null) {
                // empty if block
            }
            result = bestMatch != null && bestMatch.asJavaLocale().equals(locale) ? bestMatch : new LocaleSupportImpl(locale, bestMatch);
            this.supportByLocale.put(locale, result);
        }
        return result;
    }

    @Override
    public void changeDefaultLocale(Locale locale) {
        Locale.setDefault(locale);
        this.defaultLocale = this.getSupportForLocale(locale);
    }

    protected void loadLocales() {
        ExtensionService service = Platform.getExtensionService();
        List<Extension<LocaleSupportMetadata>> extensions = service.getExtensionsByPoint(LocaleSupportMetadata.class);
        for (Extension<LocaleSupportMetadata> extension : extensions) {
            try {
                LocaleSupport support = extension.instantiateAs(LocaleSupport.class);
                if (support instanceof LocaleSupportImpl) {
                    LocaleSupportImpl impl = (LocaleSupportImpl)support;
                    LocaleSupportMetadata metadata = extension.getMetadata();
                    impl.setLanguage(metadata.language());
                    impl.setCountry(metadata.country());
                    impl.setVariant(metadata.variant());
                    impl.setAvailableOnIDE(metadata.availableOnIDE());
                }
                if (support.getLanguage().length() > 0 && !this.supportedLocales.contains(support)) {
                    this.supportedLocales.add(support);
                }
                if (!support.isAvailableOnIDE() || support.getLanguage().length() <= 0 || this.supportedIdeLocales.contains(support)) continue;
                this.supportedIdeLocales.add(support);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void selectActiveLocale() {
        this.projectDefaultLocale = this.findBestMatchFor(Locales.getSystemDefault());
        if (this.projectDefaultLocale != null) {
            if (this.projectDefaultLocale.isAvailableOnIDE()) {
                this.defaultLocale = this.projectDefaultLocale;
            } else {
                this.defaultLocaleToEnglish();
            }
        } else {
            this.defaultLocaleToEnglish();
            this.projectDefaultLocale = this.defaultLocale;
        }
        assert (this.defaultLocale != null);
        assert (this.projectDefaultLocale != null);
    }

    private void defaultLocaleToEnglish() {
        Locale baseLocale = Locales.BASE_LOCALE;
        this.defaultLocale = this.findBestMatchFor(baseLocale);
        if (this.defaultLocale == null) {
            LocaleSupportImpl localeSupport = new LocaleSupportImpl(baseLocale, null);
            localeSupport.setAvailableOnIDE(true);
            this.defaultLocale = localeSupport;
            this.supportByLocale.put(baseLocale, this.defaultLocale);
        }
    }

    private LocaleSupport findBestMatchFor(Locale locale) {
        LocaleSupport bestMatch = null;
        for (LocaleSupport support : this.supportedLocales) {
            if (!support.getLanguage().equals(locale.getLanguage())) continue;
            if (bestMatch == null) {
                bestMatch = support;
                continue;
            }
            if (!support.getCountry().equals(locale.getCountry())) continue;
            bestMatch = support;
        }
        return bestMatch;
    }
}

