/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;

public class RuntimeExceptionShell
extends RuntimeException {
    private final String m;
    private final String originalMessage;
    private String originalStackTrace;
    private final String originalString;
    static final long serialVersionUID = -4016654497619083368L;
    static final long serialCheck = 97248482570521180L;

    public RuntimeExceptionShell(Throwable t) {
        this(t, null);
    }

    public RuntimeExceptionShell(Throwable t, String msg) {
        this.initCause(t);
        this.m = msg;
        this.originalMessage = null;
        this.originalString = null;
    }

    public RuntimeExceptionShell(String msg, Throwable t) {
        this.originalMessage = t.getMessage();
        this.m = msg;
        this.originalString = t.toString();
        this.originalStackTrace = t.toString();
    }

    private RuntimeExceptionShell() {
        this.m = null;
        this.originalMessage = null;
        this.originalString = null;
    }

    @Override
    public final String getMessage() {
        return this.getCause() != null ? this.getCause().getMessage() : this.originalMessage;
    }

    public final String getOwnMessage() {
        return this.m;
    }

    public final Throwable getThrowable() {
        return this.getCause();
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public final void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    @Override
    public final void printStackTrace(PrintWriter s) {
        s.println("\nRuntime exception Shell.");
        if (this.m != null && !this.m.isEmpty()) {
            s.println("Context details   :\n\t" + this.m + '\n');
        }
        if (this.originalMessage != null && !this.originalMessage.isEmpty()) {
            s.println("Apparent cause    :\n\t" + this.originalMessage + '\n');
        } else if (this.getCause() != null && this.getCause().getMessage() != null && !this.getCause().getMessage().isEmpty()) {
            s.println("Apparent cause    :\n\t" + this.getCause().getMessage() + '\n');
        }
        s.println();
        s.println("Original stack trace follows ...");
        s.println();
        if (this.originalStackTrace != null) {
            s.println(this.originalStackTrace);
        } else if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        }
        s.println();
        s.flush();
    }

    @Override
    public final String toString() {
        return this.getClass() + " ->> " + (this.getCause() != null ? this.getCause().toString() : this.originalString);
    }

    private static String getStackTrace(Throwable exc) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter auxPrintWriter = new PrintWriter((Writer)stringWriter, true);
        auxPrintWriter.print("Trace:");
        exc.printStackTrace(auxPrintWriter);
        return stringWriter.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.originalStackTrace == null) {
            String hostName = "";
            try {
                hostName = hostName + '\"' + InetAddress.getLocalHost().getHostName() + '\"';
            }
            catch (Exception e) {
                hostName = hostName + "\"<unavailable>\"";
            }
            try {
                hostName = hostName + '(' + InetAddress.getLocalHost().getHostAddress() + ')';
            }
            catch (Exception e) {
                hostName = hostName + "(<unavailable>)";
            }
            this.originalStackTrace = "Exception serialized from host " + hostName + '\n';
            this.originalStackTrace = this.originalStackTrace + RuntimeExceptionShell.getStackTrace(this.getCause());
        }
        out.defaultWriteObject();
    }
}

