/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.bpm.collections.iterator.AbstractIterator;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.msg.CoreMsg;

@Component(module="Fuego.Internal")
public final class RegExp {
    private boolean global = false;
    private String pattern;
    private Pattern regexp;

    public RegExp(String pattern) {
        if (pattern.charAt(0) != '/') {
            throw new FormatException(pattern, 0);
        }
        int lastSlash = pattern.lastIndexOf(47);
        if (lastSlash < 1) {
            throw new FormatException(pattern, pattern.length() - 1);
        }
        String options = pattern.substring(lastSlash + 1);
        int flags = 0;
        block8: for (int i = 0; i < options.length(); ++i) {
            switch (options.charAt(i)) {
                case 'g': {
                    this.global = true;
                    continue block8;
                }
                case 'i': {
                    flags += 2;
                    continue block8;
                }
                case 'm': {
                    flags += 8;
                    continue block8;
                }
                case 's': {
                    flags += 32;
                    continue block8;
                }
                default: {
                    throw new FormatException(pattern, lastSlash + i + 1);
                }
            }
        }
        this.pattern = pattern;
        try {
            this.regexp = Pattern.compile(pattern.substring(1, lastSlash), flags);
        }
        catch (PatternSyntaxException e) {
            throw new FormatException(this.pattern, e.getIndex());
        }
    }

    public static RegExp valueOf(String pattern) {
        if (pattern == null) {
            return null;
        }
        return new RegExp(pattern);
    }

    public boolean isMatch(String string) {
        return this.regexp.matcher(string).matches();
    }

    public int count(String string) {
        Matcher matcher = this.regexp.matcher(string);
        int result = 0;
        while (matcher.find()) {
            ++result;
        }
        return result;
    }

    public int indexOf(String string) {
        Matcher matcher = this.regexp.matcher(string);
        return matcher.find() ? matcher.start() : -1;
    }

    public int lastIndexOf(String string) {
        Matcher matcher = this.regexp.matcher(string);
        int result = -1;
        while (matcher.find()) {
            result = matcher.start();
        }
        return result;
    }

    public String[] match(String string) {
        String[] result = null;
        Matcher matcher = this.regexp.matcher(string);
        if (matcher.find()) {
            if (this.global) {
                StringList matches = StringList.create();
                do {
                    matches.add(matcher.group());
                } while (matcher.find());
                result = matches.toArray();
            } else {
                result = new String[matcher.groupCount() + 1];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = matcher.group(i);
                }
            }
        }
        return result;
    }

    public Iterable<String> matches(final String string) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new MatcherIterator(RegExp.this.regexp, string);
            }
        };
    }

    public String replace(String string, String replacement) {
        Matcher matcher = this.regexp.matcher(string);
        return this.global ? matcher.replaceAll(replacement) : matcher.replaceFirst(replacement);
    }

    public String[] split(String string) {
        Matcher matcher = this.regexp.matcher(string);
        StringList result = StringList.create();
        int pos = 0;
        while (matcher.find()) {
            result.add(string.substring(pos, matcher.start()));
            pos = matcher.end();
        }
        result.add(string.substring(pos));
        return result.toArray();
    }

    public Iterable<String> tokenize(final String string) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TokenizeIterator(RegExp.this.regexp, string);
            }
        };
    }

    public String toString() {
        return this.pattern;
    }

    private static class TokenizeIterator
    extends AbstractIterator<String> {
        private final Matcher matcher;
        private int pos;
        private final String string;

        public TokenizeIterator(Pattern regexp, String string) {
            this.string = string;
            this.matcher = regexp.matcher(string);
            this.pos = 0;
        }

        @Override
        protected boolean advance() {
            boolean more;
            boolean bl = more = this.pos != -1;
            if (more) {
                if (this.matcher.find()) {
                    this.next = this.string.substring(this.pos, this.matcher.start());
                    this.pos = this.matcher.end();
                } else {
                    this.next = this.string.substring(this.pos);
                    this.pos = -1;
                }
            }
            return more;
        }
    }

    private static class MatcherIterator
    extends AbstractIterator<String> {
        private final Matcher matcher;

        public MatcherIterator(Pattern regexp, String string) {
            this.matcher = regexp.matcher(string);
        }

        @Override
        protected boolean advance() {
            boolean result = this.matcher.find();
            this.next = this.matcher.group();
            return result;
        }
    }

    public static final class FormatException
    extends oracle.bpm.lang.FormatException {
        private final int pos;
        static final long serialCheck = -5422305235492003702L;
        static final long serialVersionUID = -4539560954721839690L;

        FormatException(String pattern, int pos) {
            super(CoreMsg.INVREGEXP(pattern));
            this.pos = pos;
        }

        public int getPosition() {
            return this.pos;
        }
    }
}

