/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public class Kind {
    public static final int NONE = -1;
    public static final int VOID = 0;
    public static final int FIRST_PREDEFINED = 0;
    public static final int BOOL = 1;
    public static final int INT = 2;
    public static final int DECIMAL = 3;
    public static final int REAL = 4;
    public static final int STRING = 5;
    public static final int TIME = 6;
    public static final int INTERVAL = 7;
    public static final int BINARY = 8;
    public static final int NULL = 9;
    public static final int ANY = 10;
    public static final int LAST_PREDEFINED = 10;
    public static final int OBJECT = 11;
    public static final int ARRAY = 12;
    public static final int MAP = 13;
    public static final int METHOD = 14;
    public static final int DYNAMIC = 15;
    public static final int ITERATOR = 16;
    public static final int ENUM = 17;
    public static final int ATTRIBUTE = 18;
    public static final int SET = 19;
    public static final int TRANSFORM = 20;
    @NonNls
    private static final String[] names = new String[]{"None", "Void", "Bool", "Int", "Decimal", "Real", "String", "Time", "Interval", "Binary", "null", "Any", "Object", "Array", "Map", "Method", "Dynamic", "Iterator", "Enum", "Attribute", "Set", "Transform"};
    private static final Map<String, Integer> kindsByName = new HashMap<String, Integer>(names.length);

    private Kind() {
    }

    public static boolean isAtomic(int kind) {
        return kind == 1 || kind == 2 || kind == 4 || kind == 6 || kind == 7 || kind == 3 || kind == 5 || kind == 8;
    }

    public static int getKind(String kindName) {
        Integer ret = kindsByName.get(kindName.trim());
        return ret == null ? -1 : ret;
    }

    public static String getName(int kind) {
        return names[kind + 1];
    }

    public static boolean isNumber(int kind) {
        return kind == 2 || kind == 4 || kind == 3;
    }

    public static boolean isPredefined(int kind) {
        return kind > -1 && kind <= 10;
    }

    public static boolean hasFixedSize(int kind) {
        return kind == 1 || kind == 2 || kind == 4 || kind == 6;
    }

    public static String getInitialValue(int kind) {
        switch (kind) {
            case 5: {
                return "";
            }
            case 6: {
                return Time.now().toString();
            }
            case 1: {
                return Boolean.TRUE.toString();
            }
        }
        return "0";
    }

    static {
        for (int i = 0; i < names.length; ++i) {
            kindsByName.put(names[i], i - 1);
        }
    }
}

