/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;

public final class JavaObject<T>
extends Invokeable {
    JavaClass<T> javaClass;
    T target;
    private transient ClassNotFoundHandler handler;
    private String javaClassName;
    private boolean mustInstantiate;
    static final long serialVersionUID = 5055299558177128556L;
    static final long serialCheck = -469810460965064070L;

    public JavaObject(T target) {
        Class targetClass = (Class)Cast.force(target.getClass());
        this.javaClass = JavaClass.fromClass(targetClass);
        this.target = target;
    }

    public JavaObject(JavaClass<T> javaClass) throws InstantiationException, IllegalAccessException {
        this(javaClass, javaClass.instantiate());
    }

    public JavaObject(JavaClass<T> javaClass, T target) {
        this.javaClass = javaClass;
        this.target = target;
    }

    public JavaObject(String javaClassName, boolean lazy) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (lazy) {
            this.mustInstantiate = true;
            this.javaClassName = javaClassName;
        } else {
            this.javaClass = (JavaClass)Cast.force(JavaClass.forName(javaClassName));
            this.target = this.javaClass.instantiate();
        }
    }

    public JavaObject(String javaClassName, boolean lazy, ClassNotFoundHandler handler) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this(javaClassName, lazy);
        this.handler = handler;
    }

    private JavaObject(JavaClass<T> javaClass, boolean lazy) throws InstantiationException, IllegalAccessException {
        this.javaClass = javaClass;
        if (lazy) {
            this.mustInstantiate = true;
        } else {
            this.target = javaClass.instantiate();
        }
    }

    public static <T> JavaObject<T> createJavaObject(JavaClass<T> javaClass, boolean lazy) throws InstantiationException, IllegalAccessException {
        return new JavaObject<T>(javaClass, lazy);
    }

    @Override
    public Object setAttributeValue(String signature, Object value) {
        this.getJavaClass().setAttributeValue(signature, value, this.getTarget());
        return value;
    }

    public int setAttributeValue(String signature, int value) {
        this.getJavaClass().setAttributeValue(signature, value, this.getTarget());
        return value;
    }

    public long setAttributeValue(String signature, long value) {
        this.getJavaClass().setAttributeValue(signature, value, this.getTarget());
        return value;
    }

    public float setAttributeValue(String signature, float value) {
        this.getJavaClass().setAttributeValue(signature, Float.valueOf(value), this.getTarget());
        return value;
    }

    public double setAttributeValue(String signature, double value) {
        this.getJavaClass().setAttributeValue(signature, value, this.getTarget());
        return value;
    }

    public boolean setAttributeValue(String signature, boolean value) {
        this.getJavaClass().setAttributeValue(signature, value, this.getTarget());
        return value;
    }

    @Override
    public void setAttributeValue(String signature, int index, Object value) {
        if (index == -1) {
            this.setAttributeValue(signature, value);
        } else {
            Object o = this.getAttributeValue(signature);
            if (o != null) {
                if (o instanceof List) {
                    List list = (List)Cast.force(o);
                    if (index == list.size()) {
                        list.add(value);
                    } else {
                        list.set(index, value);
                    }
                } else if (o.getClass().isArray()) {
                    Array.set(o, index, value);
                }
            }
        }
    }

    @Override
    public Object getAttributeValue(String signature) {
        return this.getJavaClass().getAttributeValue(signature, this.getTarget());
    }

    @Override
    public Object getAttributeValue(String signature, String setter) {
        return this.getJavaClass().getAttributeValue(signature, setter, this.getTarget());
    }

    @Override
    public Object getAttributeValue(String signature, String setter, int index) {
        return this.getJavaClass().getAttributeValue(signature, setter, index, this.getTarget());
    }

    public JavaClass<T> getJavaClass() {
        if (this.javaClass == null) {
            try {
                this.javaClass = (JavaClass)Cast.force(JavaClass.forName(this.javaClassName));
            }
            catch (ClassNotFoundException e) {
                if (this.handler != null) {
                    this.handler.handle(e);
                }
                throw new RuntimeExceptionShell(e);
            }
        }
        return this.javaClass;
    }

    @Override
    public String getName() {
        return this.getJavaClass().getName();
    }

    public T getTarget() {
        if (this.target == null && this.mustInstantiate) {
            try {
                this.target = this.getJavaClass().instantiate();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.target;
    }

    @Override
    public boolean isInstanceOf(String componentType, String signature) {
        return "java".equals(componentType) && this.getJavaClass().getName().equals(signature);
    }

    @Override
    public Object invoke(String signature, Object ... args) throws ComponentExecutionException, InvocationTargetException {
        try {
            return this.getJavaClass().invokeMethod(this.getTarget(), signature, args);
        }
        catch (IllegalAccessException exc) {
            throw new ComponentExecutionException(exc, this.getJavaClass().getName(), signature);
        }
    }

    public String toString() {
        return "JavaObject(" + this.getTarget() + ')';
    }

    @Override
    protected void processInputHolders(String methodSignature, Object[] methodArgs) throws Exception {
        this.getJavaClass().wrapInputArgs(methodSignature, methodArgs);
    }

    @Override
    protected void processOutputHolders(String methodSignature, Object[] methodArgs) throws Exception {
        this.getJavaClass().unwrapOutputArgs(methodSignature, methodArgs);
    }

    public static interface ClassNotFoundHandler {
        public void handle(ClassNotFoundException var1);
    }
}

