/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

@Component(module="Fuego.Internal")
public enum IntervalUnit implements I18nProvider
{
    YEARS(CoreMsg.YEARS),
    MONTHS(CoreMsg.MONTHS),
    DAYS(CoreMsg.DAYS),
    HOURS(CoreMsg.HOURS),
    MINUTES(CoreMsg.MINUTES),
    SECONDS(CoreMsg.SECONDS),
    MILLISECONDS(CoreMsg.MILLISECONDS),
    MICROSECONDS(CoreMsg.MICROSECONDS);

    private transient Msg msg;
    @NonNls
    private static final String CHAR_ID = "YMdhmsSx";
    @NonNls
    private static final String PATTERN_CHARS = "YyMDdHhmsSx";
    private static final IntervalUnit[] PATTERN_INDEX_TO_INTERVAL_UNIT;
    @NonNls
    private static final String INTERVAL_UNIT_TO_PATTERN_CHAR = "YMDHmsSx";

    private IntervalUnit(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    @Exclude
    public Msg getMsg() {
        return this.msg;
    }

    public IntervalUnit next() {
        IntervalUnit[] v;
        int next = this.ordinal() + 1;
        return next < (v = IntervalUnit.values()).length ? v[next] : null;
    }

    public IntervalUnit prev() {
        int prev = this.ordinal() - 1;
        return prev >= 0 ? IntervalUnit.values()[prev] : null;
    }

    public char charId() {
        return CHAR_ID.charAt(this.ordinal());
    }

    public static IntervalUnit valueOf(char ch) {
        int index = PATTERN_CHARS.indexOf(ch);
        return index == -1 ? null : PATTERN_INDEX_TO_INTERVAL_UNIT[index];
    }

    public char patternChar() {
        return INTERVAL_UNIT_TO_PATTERN_CHAR.charAt(this.ordinal());
    }

    static {
        PATTERN_INDEX_TO_INTERVAL_UNIT = new IntervalUnit[]{YEARS, YEARS, MONTHS, DAYS, DAYS, HOURS, HOURS, MINUTES, SECONDS, MILLISECONDS, MICROSECONDS};
    }
}

