/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.util.Calendar;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public final class Holiday
implements Serializable {
    static final long serialVersionUID = -5960006683494052863L;
    static final long serialCheck = 8011717275777220310L;

    public static final class ItemCommon
    extends Item {
        static final long serialCheck = 5258020112611708393L;
        static final long serialVersionUID = 6414241240644634549L;

        public ItemCommon() {
        }

        public ItemCommon(String description, int day, int month) {
            super(description, Time.valueOf("1970/" + month + "/" + day), 1970);
        }

        @Override
        public String getType() {
            return "COMMON";
        }

        @Override
        public String toString() {
            return "FIXED:" + this.date.getDay() + " " + Month.valueOf(this.date.getMonth()) + ":" + this.description;
        }

        @Override
        boolean match(Time d) {
            return this.date.getDayOfMonth() == d.getDayOfMonth() && this.date.getMonth() == d.getMonth();
        }
    }

    public static class Item
    implements Serializable {
        public int currYear;
        public Time date;
        public String description;
        static final long serialCheck = 209890156609910372L;
        static final long serialVersionUID = -539651224899022263L;

        public Item() {
        }

        public Item(String description, Time date, int currYear) {
            this.description = description;
            this.date = date;
            this.currYear = currYear;
        }

        public final Time getDate() {
            return this.date;
        }

        public final String getDescription() {
            return this.description;
        }

        @NonNls
        public String getType() {
            return "FIXED";
        }

        public final boolean equals(Item it) {
            return it.description.equals(this.description) || it.date.equals(this.date) && it.getType().equals(this.getType());
        }

        public String toString() {
            return "YEAR_APPLICABLE:" + this.date.toDateString() + ":" + this.description;
        }

        boolean match(Time d) {
            return this.date.getDays() == d.getDays();
        }

        final boolean match(Calendar cal) {
            return this.date.getMonth() == cal.get(2) + 1 && this.date.getDay() == cal.get(5);
        }
    }
}

