/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Locale;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

public abstract class DefaultRuntimeException
extends RuntimeException {
    private DefaultException exceptionImpl = null;
    static final long serialVersionUID = 1003902060616250001L;
    static final long serialCheck = 8798629199496915800L;

    protected DefaultRuntimeException() {
        this(CoreMsg.NO_MESSAGE_CODE);
    }

    protected DefaultRuntimeException(Msg msgKey) {
        this.exceptionImpl = new MyDefaultException(msgKey);
    }

    protected DefaultRuntimeException(Msg msgKey, Throwable cause) {
        this.exceptionImpl = new MyDefaultException(msgKey, cause);
    }

    @Override
    public final Throwable getCause() {
        return this.exceptionImpl.getCause();
    }

    public final String getCode() {
        return this.exceptionImpl.getCode();
    }

    public String getDetail(Locale locale) {
        return this.exceptionImpl.getDetail(locale);
    }

    @Exclude
    public Msg getKey() {
        return this.exceptionImpl.getKey();
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.exceptionImpl.getMessage(locale);
    }

    public final String getStackTraceString() {
        return this.exceptionImpl.getStackTraceString();
    }

    public String getTechnicalDetail(Locale locale) {
        return this.exceptionImpl.getTechnicalDetail(locale);
    }

    public String getUserMessage(Locale locale) {
        return this.exceptionImpl.getUserMessage(locale);
    }

    public final boolean hasDetail() {
        return this.exceptionImpl.hasDetail();
    }

    @Override
    public final Throwable initCause(Throwable cause) {
        this.exceptionImpl.initCause(cause);
        return this;
    }

    @Exclude
    protected final void setKey(Msg key) {
        this.exceptionImpl.setKey(key);
    }

    private static class MyDefaultException
    extends DefaultException {
        static final long serialCheck = 522491806796689395L;
        static final long serialVersionUID = 1003902060616250001L;

        public MyDefaultException(Msg msgKey) {
            super(msgKey);
        }

        protected MyDefaultException(Msg msgKey, Throwable cause) {
            super(msgKey, cause);
        }
    }
}

