/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.StackTrace;

public abstract class DefaultException
extends Exception {
    protected boolean hasDetail = false;
    private transient String detailMessage = null;
    private transient Locale locale = null;
    private Msg msg = null;
    private transient String technicalDetailMessage = null;
    private transient String userMessage = null;
    static final long serialVersionUID = 1005302060616250001L;
    static final long serialCheck = 4163161439745178240L;

    protected DefaultException() {
        this(CoreMsg.NO_MESSAGE_CODE);
    }

    protected DefaultException(Msg msgKey) {
        this.setKey(msgKey);
    }

    protected DefaultException(Msg msgKey, Throwable cause) {
        super(cause);
        this.setKey(msgKey);
    }

    public static String getStackTrace(Throwable exc) {
        StringWriter stringWriter = new StringWriter();
        exc.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }

    public final String getCode() {
        return this.msg != null ? this.msg.getCode() : null;
    }

    public String getDetail(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.userMessage = null;
            this.detailMessage = null;
            this.technicalDetailMessage = null;
        }
        if (this.detailMessage == null) {
            if (this.msg != null) {
                this.detailMessage = this.msg.getDetail(locale);
            }
            if (this.detailMessage == null || this.detailMessage.length() == 0) {
                this.detailMessage = CoreMsg.DEFAULT_EXCEPTION_DETAIL.getString(locale);
            }
            this.locale = locale;
        }
        assert (this.detailMessage != null) : "Detail message for [" + this + "] is null";
        return this.detailMessage;
    }

    @Exclude
    public Msg getKey() {
        return this.msg;
    }

    @Override
    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        return this.getUserMessage(locale) + (this.hasDetail() ? "\n" + CoreMsg.DETAIL.getString(locale) + ":" + this.getDetail(locale) + "\n" : "");
    }

    public String getStackTraceString() {
        return DefaultException.getStackTrace(this);
    }

    public String getTechnicalDetail(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.userMessage = null;
            this.detailMessage = null;
            this.technicalDetailMessage = null;
        }
        if (this.technicalDetailMessage == null) {
            this.technicalDetailMessage = CoreMsg.DEFAULT_EXCEPTION_TECHDETAIL.getString(locale);
            this.locale = locale;
        }
        return this.technicalDetailMessage;
    }

    public String getUserMessage(Locale locale) {
        if (!locale.equals(this.locale)) {
            this.userMessage = null;
            this.detailMessage = null;
            this.technicalDetailMessage = null;
        }
        if (this.userMessage == null) {
            if (this.msg != null) {
                this.userMessage = this.msg.getString(locale);
                if (this.userMessage == null) {
                    this.userMessage = CoreMsg.EXCEPTION_CODENOTFOUND(this.msg.getCode(), null).getString(locale);
                }
            }
            this.locale = locale;
        }
        return this.userMessage;
    }

    public final boolean hasDetail() {
        return this.hasDetail;
    }

    protected String getCauseDetail(Locale locale) {
        String causeDetail;
        Throwable t = this.getCause();
        if (t == null) {
            causeDetail = "";
        } else if (t instanceof DefaultException) {
            DefaultException d = (DefaultException)t;
            causeDetail = d.getDetail(locale);
        } else if (t instanceof DefaultRuntimeException) {
            DefaultRuntimeException d = (DefaultRuntimeException)t;
            causeDetail = d.getDetail(locale);
        } else {
            causeDetail = t.toString();
        }
        assert (causeDetail != null) : "Cause Detail message for [" + this + "] is null";
        return causeDetail;
    }

    protected String getCauseTechnicalDetail(Locale locale) {
        Throwable t = this.getCause();
        String causeTechnicalDetail = "";
        if (t == null) {
            causeTechnicalDetail = StackTrace.getStackTrace();
        } else if (t instanceof DefaultException) {
            DefaultException d = (DefaultException)t;
            if (d.hasDetail()) {
                causeTechnicalDetail = d.getDetail(locale) + "\n";
            }
        } else if (t instanceof DefaultRuntimeException) {
            DefaultRuntimeException d = (DefaultRuntimeException)t;
            if (d.hasDetail()) {
                causeTechnicalDetail = d.getDetail(locale) + "\n";
            }
        } else {
            causeTechnicalDetail = ExceptionFormatter.fullTechLevel(t);
        }
        return causeTechnicalDetail;
    }

    protected final void setKey(Msg key) {
        this.msg = key;
        this.hasDetail = this.msg != null && this.msg.hasDetail();
    }
}

