/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.NumberFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component(module="Fuego.Internal", hideInheritance=true)
public final class Decimal {
    @Nullable
    private final BigDecimal value;
    public static final BigDecimal ZERO = BigDecimal.ZERO;

    public Decimal(@Nullable BigDecimal value) {
        this.value = value;
    }

    @NotNull
    public static BigDecimal add(@Nullable BigDecimal op1, @Nullable BigDecimal op2) {
        BigDecimal bigDecimal;
        if (!(op1 == null ? (bigDecimal = Decimal.nonNull(op2)) != null : (op2 == null ? (bigDecimal = op1) != null : (bigDecimal = op1.add(op2)) != null))) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.add must not return null");
        }
        return bigDecimal;
    }

    @Method(name="checkLength")
    public static BigDecimal checkLength61(@Nullable BigDecimal value, int length) throws IllegalConversionException {
        if (value != null && length >= 0 && value.precision() > length) {
            throw IllegalConversionException.createLengthExceededException(value, length);
        }
        return value;
    }

    @Deprecated
    @Exclude
    public static BigDecimal checkLength(@Nullable BigDecimal value, int length) {
        return Decimal.checkLength61(value, value == null ? length : length - value.scale());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal dec(@Nullable BigDecimal op) {
        BigDecimal bigDecimal = Decimal.sub(op, BigDecimal.ONE);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.dec must not return null");
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static BigDecimal div(@Nullable BigDecimal op1, @Nullable BigDecimal op2) throws ArithmeticException {
        BigDecimal bigDecimal;
        op1 = Decimal.nonNull(op1);
        op2 = Decimal.nonNull(op2);
        try {
            bigDecimal = op1.divide(op2, 4);
        }
        catch (ArithmeticException e) {
            throw Decimal.checkDivideException(e, op2);
        }
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.div must not return null");
        }
        return bigDecimal;
    }

    public static String format(BigDecimal number) {
        return NumberFormatter.format(number);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal inc(BigDecimal op) {
        BigDecimal bigDecimal = Decimal.add(op, BigDecimal.ONE);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.inc must not return null");
        }
        return bigDecimal;
    }

    @NotNull
    public static BigDecimal mul(@Nullable BigDecimal op1, @Nullable BigDecimal op2) {
        BigDecimal bigDecimal;
        if (!(op1 == null || op2 == null ? (bigDecimal = ZERO) != null : (bigDecimal = op1.multiply(op2)) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.mul must not return null");
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static BigDecimal rem(@Nullable BigDecimal op1, @Nullable BigDecimal op2) throws ArithmeticException {
        BigDecimal bigDecimal;
        op1 = Decimal.nonNull(op1);
        op2 = Decimal.nonNull(op2);
        try {
            bigDecimal = op1.remainder(op2);
        }
        catch (ArithmeticException e) {
            throw Decimal.checkDivideException(e, op2);
        }
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.rem must not return null");
        }
        return bigDecimal;
    }

    @NotNull
    public static BigDecimal sub(@Nullable BigDecimal op1, @Nullable BigDecimal op2) {
        BigDecimal bigDecimal;
        if (!(op1 == null ? (bigDecimal = Decimal.negate(op2)) != null : (op2 == null ? (bigDecimal = op1) != null : (bigDecimal = op1.subtract(op2)) != null))) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.sub must not return null");
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal negate(@Nullable BigDecimal op) {
        BigDecimal bigDecimal = op == null ? ZERO : op.negate();
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.negate must not return null");
        }
        return bigDecimal;
    }

    public static BigDecimal scale(@Nullable BigDecimal value, int scale) {
        return value == null || scale < 0 ? value : value.setScale(scale, 4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal valueOf(long value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.valueOf must not return null");
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal valueOf(int value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.valueOf must not return null");
        }
        return bigDecimal;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal valueOf(double value) {
        BigDecimal bigDecimal;
        if (value == 0.0) {
            bigDecimal = ZERO;
            if (bigDecimal == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.valueOf must not return null");
            return bigDecimal;
        }
        String svalue = Double.toString(value);
        if (svalue.endsWith(".0")) {
            svalue = svalue.substring(0, svalue.length() - 2);
        }
        if ((bigDecimal = Decimal.valueOf(svalue)) != null) return bigDecimal;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.valueOf must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static BigDecimal valueOf(float value) {
        BigDecimal bigDecimal = Decimal.valueOf((double)value);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.valueOf must not return null");
        }
        return bigDecimal;
    }

    public static BigDecimal valueOf(Number value) {
        return value == null || value instanceof BigDecimal ? (BigDecimal)value : Decimal.valueOf(value.doubleValue());
    }

    public static BigDecimal valueOf(String value) {
        return value == null ? null : new BigDecimal(value);
    }

    public static BigDecimal valueOf(Time value) {
        return value == null ? null : BigDecimal.valueOf(value.getMicroSeconds());
    }

    public static BigDecimal valueOf(Interval value) {
        return value == null ? null : BigDecimal.valueOf(value.getTotalMicroseconds());
    }

    public static BigDecimal valueOf(Object value) {
        if (value == null || value instanceof Number) {
            return Decimal.valueOf((Number)value);
        }
        if (value instanceof String) {
            return Decimal.valueOf((String)value);
        }
        if (value instanceof Time) {
            return Decimal.valueOf((Time)value);
        }
        if (value instanceof Interval) {
            return Decimal.valueOf((Interval)value);
        }
        if (value instanceof byte[]) {
            return Decimal.valueOf(Binary.deserialize((byte[])value));
        }
        throw new IllegalConversionException(value, "Decimal");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public BigDecimal abs() {
        BigDecimal thisValue = this.value;
        BigDecimal bigDecimal = thisValue == null ? ZERO : thisValue.abs();
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.abs must not return null");
        }
        return bigDecimal;
    }

    public double acos() {
        return Math.acos(this.doubleValue());
    }

    public double asin() {
        return Math.asin(this.doubleValue());
    }

    public double atan() {
        return Math.atan(this.doubleValue());
    }

    @NotNull
    public BigDecimal ceil() {
        BigDecimal decimal;
        BigDecimal bigDecimal;
        BigDecimal thisValue = this.value;
        if (!(thisValue == null ? (bigDecimal = ZERO) != null : (bigDecimal = (decimal = thisValue.setScale(0, 2)).setScale(thisValue.scale())) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.ceil must not return null");
        }
        return bigDecimal;
    }

    public double cos() {
        return Math.cos(this.doubleValue());
    }

    public double exp() {
        return Math.exp(this.doubleValue());
    }

    @NotNull
    public BigDecimal floor() {
        BigDecimal decimal;
        BigDecimal bigDecimal;
        BigDecimal thisValue = this.value;
        if (!(thisValue == null ? (bigDecimal = ZERO) != null : (bigDecimal = (decimal = thisValue.setScale(0, 3)).setScale(thisValue.scale())) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.floor must not return null");
        }
        return bigDecimal;
    }

    public String format() {
        return NumberFormatter.format(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Decimal)) {
            return false;
        }
        BigDecimal thisValue = this.value;
        BigDecimal otherValue = ((Decimal)obj).value;
        return thisValue == null ? otherValue == null : thisValue.compareTo(otherValue) == 0;
    }

    public String format(String mask) {
        return new DecimalFormat(mask).format(this.value);
    }

    public String formatMoney() {
        return NumberFormatter.formatMoney(this.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public double log() {
        return Math.log(this.doubleValue());
    }

    public double max(double i) {
        BigDecimal thisValue = this.value;
        if (thisValue == null) {
            return i;
        }
        return Math.max(thisValue.doubleValue(), i);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public BigDecimal max(long i) {
        BigDecimal bigDecimal = this.max(BigDecimal.valueOf(i));
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.max must not return null");
        }
        return bigDecimal;
    }

    public BigDecimal max(@Nullable BigDecimal i) {
        BigDecimal thisValue = this.value;
        return i == null ? thisValue : (thisValue == null ? i : i.max(thisValue));
    }

    public double min(double i) {
        BigDecimal thisValue = this.value;
        if (thisValue == null) {
            return i;
        }
        return Math.min(thisValue.doubleValue(), i);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public BigDecimal min(long i) {
        BigDecimal bigDecimal = this.min(BigDecimal.valueOf(i));
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.min must not return null");
        }
        return bigDecimal;
    }

    public BigDecimal min(@Nullable BigDecimal i) {
        BigDecimal thisValue = this.value;
        return i == null ? thisValue : (thisValue == null ? i : i.min(thisValue));
    }

    public double pow(double b) {
        return Math.pow(this.doubleValue(), b);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public BigDecimal round() {
        BigDecimal bigDecimal = this.round(0);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.round must not return null");
        }
        return bigDecimal;
    }

    @NotNull
    public BigDecimal round(int scale) {
        BigDecimal decimal;
        BigDecimal bigDecimal;
        BigDecimal thisValue = this.value;
        if (!(thisValue == null ? (bigDecimal = ZERO) != null : (bigDecimal = (decimal = thisValue.setScale(scale, 6)).setScale(thisValue.scale())) != null)) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.round must not return null");
        }
        return bigDecimal;
    }

    public double sin() {
        return Math.sin(this.doubleValue());
    }

    public double sqrt() {
        return Math.sqrt(this.doubleValue());
    }

    public double tan() {
        return Math.tan(this.doubleValue());
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static BigDecimal nonNull(@Nullable BigDecimal value) {
        BigDecimal bigDecimal = value == null ? ZERO : value;
        if (bigDecimal == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/lang/Decimal.nonNull must not return null");
        }
        return bigDecimal;
    }

    private static ArithmeticException checkDivideException(ArithmeticException e, @NotNull BigDecimal divisor) {
        if (divisor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/lang/Decimal.checkDivideException must not be null");
        }
        return ZERO.compareTo(divisor) != 0 ? e : new ArithmeticException(CoreMsg.DECIMAL_ZERO_DIVIDE.getString());
    }

    private double doubleValue() {
        BigDecimal thisValue = this.value;
        return thisValue == null ? 0.0 : thisValue.doubleValue();
    }

    public static class Holder {
        public BigDecimal value;

        public Holder() {
        }

        public Holder(BigDecimal init) {
            this.value = init;
        }
    }
}

