/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.InvocationTargetException;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;

@Component(module="Fuego.Internal", hideInheritance=true)
public class ComponentExecutionException
extends DefaultException {
    static final long serialVersionUID = 1002502030418080001L;
    static final long serialCheck = 5971305295975947777L;

    public ComponentExecutionException(String customMsg) {
        this.setKey(CoreMsg.CEX_FAILED(customMsg));
    }

    @Exclude
    public ComponentExecutionException(Msg msg) {
        this.setKey(msg);
    }

    public ComponentExecutionException(Throwable t) {
        this.unwrapInner(t);
        this.setKey(CoreMsg.CEX_FAILED(this.getCause().toString()));
    }

    public ComponentExecutionException(InvocationTargetException e, Class cl, String meth) {
        this(e, cl.getName(), meth);
    }

    public ComponentExecutionException(InvocationTargetException e, String className, String meth) {
        this.setKey(CoreMsg.CEX_METHODFAILED(className, meth));
        this.unwrapInner(e.getTargetException());
    }

    public ComponentExecutionException(Throwable t, String process, String task) {
        this.setKey(CoreMsg.CEX_TASKFAILED(process, task));
        this.unwrapInner(t);
    }

    public ComponentExecutionException(Throwable t, String process, String activity, String task) {
        this.setKey(CoreMsg.CEX_ACTIVITYTASKFAILED(process, activity, task));
        this.unwrapInner(t);
    }

    protected ComponentExecutionException() {
    }

    private void unwrapInner(Throwable cause) {
        Throwable inner = null;
        Throwable next = cause;
        if (cause == null) {
            return;
        }
        while (next != null) {
            inner = next;
            if (next instanceof ComponentExecutionException) {
                next = ((ComponentExecutionException)next).getCause();
                continue;
            }
            if (next instanceof RuntimeExceptionShell) {
                next = ((RuntimeExceptionShell)next).getThrowable();
                continue;
            }
            if (!(next instanceof InvocationTargetException)) break;
            next = ((InvocationTargetException)next).getTargetException();
        }
        this.initCause(inner);
    }
}

