/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import org.jetbrains.annotations.Nullable;

@Component(module="Fuego.Internal", hideInheritance=true)
public class Bool {
    private final boolean value;

    public Bool(boolean value) {
        this.value = value;
    }

    public Bool(@Nullable Boolean value) {
        this.value = value != null && value != false;
    }

    public static boolean booleanValue(@Nullable Object value) {
        return value != null && Bool.valueOf(value) != false;
    }

    public static int compare(@Nullable Boolean obj1, @Nullable Boolean obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        return obj1.compareTo(obj2);
    }

    public static boolean booleanValue(@Nullable Boolean value) {
        return value != null && value != false;
    }

    public static boolean parseBoolean(@Nullable String name) {
        return Boolean.parseBoolean(name);
    }

    public static Boolean valueOf(@Nullable Object value) {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof byte[]) {
            return Bool.valueOf(Binary.deserialize((byte[])value));
        }
        throw new IllegalConversionException(value, "Bool");
    }

    @Hidden
    public boolean booleanValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof Bool && ((Bool)obj).value == this.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static class ObjHolder {
        public Boolean value;

        public ObjHolder() {
        }

        public ObjHolder(Boolean init) {
            this.value = init;
        }
    }

    public static class Holder
    implements Proxy {
        public boolean value;

        public Holder() {
        }

        public Holder(boolean init) {
            this.value = init;
        }

        @Override
        public boolean get() {
            return this.value;
        }

        @Override
        public void set(boolean value) {
            this.value = value;
        }
    }

    public static interface Proxy {
        public boolean get();

        public void set(boolean var1);
    }
}

