/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Serializer;
import oracle.bpm.util.DefaultValue;

final class AssociativeArray
extends DynamicObject {
    private final RefMap map;
    static final long serialCheck = -258868536305253934L;
    static final long serialVersionUID = 6833035594645291007L;

    AssociativeArray(boolean quote) {
        this.map = new RefMap(quote);
    }

    AssociativeArray(Map<?, ?> map, boolean quote, Map<Object, Object> references) {
        this(quote);
        Object obj = references.get(map);
        if (obj == null) {
            references.put(map, this);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue(), references);
        }
    }

    @Override
    public Map<DynamicObject, DynamicObject> asAssociativeArray() throws UnsupportedOperationException {
        return this.map;
    }

    @Override
    public <T> T convertTo(Class<T> cl, Map<Object, Object> references) {
        return this.convertTo(cl, Object.class, Object.class, references);
    }

    @Override
    public Object convertTo(Field field, Map<Object, Object> references) {
        return this.convertTo(field.getType(), DynamicObject.elementType(field), DynamicObject.indexType(field), references);
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = obj instanceof DynamicObject;
        if (result) {
            DynamicObject dynamic = (DynamicObject)obj;
            result = dynamic.isAssociativeArray() && ((Object)this.asAssociativeArray()).equals(dynamic.asAssociativeArray());
        }
        return result;
    }

    @Override
    public DynamicObject getElement(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isAssociativeArray() {
        return true;
    }

    @Override
    public LinkedHashMap objectValue() {
        return this.convertTo(LinkedHashMap.class);
    }

    @Override
    public void setElement(Object key, Object value) {
        this.map.put(DynamicObject.valueOf(key), DynamicObject.valueOf(value));
    }

    @Override
    public <T> T convertTo(Class<T> target) {
        return super.convertTo(target);
    }

    @Override
    public void serialize(Serializer serializer) {
        serializer.serializeMap(this);
    }

    public String toString() {
        return this.map.toString();
    }

    private Set<Map.Entry<DynamicObject, DynamicObject>> entries() {
        return this.map.entrySet();
    }

    private <T> T convertTo(Class<T> cl, Class<?> elemType, Class<?> idxType, Map<Object, Object> references) {
        try {
            Object result;
            Object object = result = DynamicObject.class.isAssignableFrom(cl) ? this : references.get(this);
            if (result == null) {
                result = this.toMap(cl, idxType, elemType, references);
            }
            if (result == null && !cl.isInterface()) {
                result = this.toComposite(cl, references);
            }
            return cl.cast(result);
        }
        catch (IllegalAccessException e) {
            throw new IllegalConversionException(this.getClass().getName(), cl.getName(), e.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalConversionException(this.getClass().getName(), cl.getName(), e.toString());
        }
        catch (InvocationTargetException e) {
            throw new IllegalConversionException(this.getClass().getName(), cl.getName(), e.toString());
        }
    }

    private <T> T toComposite(Class<T> cl, Map<Object, Object> references) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Field[] targetFields;
        T result = AssociativeArray.instantiate(cl);
        for (Field field : targetFields = cl.getFields()) {
            DynamicObject elementValue;
            if (!DynamicObject.mustSerialize(field) || (elementValue = this.getElement(field.getName())) == NULL && !this.map.containsKey(elementValue)) continue;
            Object val = elementValue.convertTo(field, references);
            if (val == null && field.getType().isPrimitive()) {
                val = DefaultValue.forClass(field.getType());
            }
            JavaClass.setFieldValue(field, result, val);
        }
        return result;
    }

    private Map toMap(Class<?> cl, Class<?> idxType, Class<?> elemType, Map<Object, Object> references) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<Map> mapClass;
        AbstractMap result = null;
        Class<Map> clazz = mapClass = cl.equals(Object.class) ? Map.class : Cast.toClass(Map.class, cl);
        if (mapClass != null) {
            result = !mapClass.isInterface() ? (TreeMap)Cast.force(AssociativeArray.instantiate(mapClass)) : (SortedMap.class.isAssignableFrom(mapClass) ? new TreeMap() : new HashMap());
            references.put(this, result);
            for (Map.Entry<DynamicObject, DynamicObject> entry : this.entries()) {
                Object key = entry.getKey().convertTo(idxType, references);
                Object value = entry.getValue().convertTo(elemType, references);
                result.put(key, value);
            }
        }
        return result;
    }

    private static final class RefMap
    extends LinkedHashMap<DynamicObject, DynamicObject> {
        private final boolean quote;
        static final long serialCheck = 339951030786681142L;
        static final long serialVersionUID = 6347368736278298981L;

        RefMap(boolean quote) {
            this.quote = quote;
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(DynamicObject.valueOf(key, this.quote));
        }

        @Override
        public boolean containsValue(Object value) {
            return super.containsValue(DynamicObject.valueOf(value, this.quote));
        }

        @Override
        public DynamicObject get(Object key) {
            DynamicObject value = (DynamicObject)super.get(DynamicObject.valueOf(key, this.quote));
            return value == null ? DynamicObject.NULL : value;
        }

        @Override
        public DynamicObject put(DynamicObject key, DynamicObject value) {
            DynamicObject old = super.put(key, value);
            return old != null ? old : DynamicObject.NULL;
        }

        public DynamicObject put(Object key, Object value, Map<Object, Object> references) {
            DynamicObject old = super.put(DynamicObject.valueOf(key, this.quote, references), DynamicObject.valueOf(value, this.quote, references));
            return old != null ? old : DynamicObject.NULL;
        }

        @Override
        public DynamicObject remove(Object key) {
            DynamicObject value = (DynamicObject)super.remove(DynamicObject.valueOf(key, this.quote));
            return value != null ? value : DynamicObject.NULL;
        }
    }
}

