/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.ArgumentMap;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.util.Conversion;

public final class ArgMap
implements ArgumentMap {
    private Map<String, Object> data;
    static final long serialVersionUID = -8758889049564174612L;
    static final long serialCheck = -2074341404100850867L;

    private ArgMap() {
        this.data = new HashMap<String, Object>();
    }

    private ArgMap(ArgMap other) {
        this.data = new HashMap<String, Object>(other.data);
    }

    public static ArgMap create() {
        return new ArgMap();
    }

    public static ArgumentMap resolve(ArgumentMap arg) {
        ArgumentMap argMap;
        if (arg == null) {
            argMap = ArgMap.create();
        } else if (arg instanceof ArgMap) {
            argMap = arg;
        } else {
            Map<String, Object> map = arg.asMap();
            argMap = ArgMap.create();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String name = entry.getKey();
                argMap.setArgument(name, arg.getArgument(name, Object.class));
            }
        }
        return argMap;
    }

    @Override
    public void setArgument(String argumentName, boolean value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, byte value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, char value) {
        this.data.put(argumentName, Character.valueOf(value));
    }

    @Override
    public void setArgument(String argumentName, short value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, int value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, long value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, float value) {
        this.data.put(argumentName, Float.valueOf(value));
    }

    @Override
    public void setArgument(String argumentName, double value) {
        this.data.put(argumentName, value);
    }

    @Override
    public void setArgument(String argumentName, Object value) {
        this.data.put(argumentName, value);
    }

    @Override
    public <T> T getArgument(String argumentName, Class<T> argumentClass) {
        Object value = this.data.get(argumentName);
        if (value != null) {
            Method conversor = Conversion.getMethod(value.getClass(), argumentClass);
            if (conversor != null) {
                value = Conversion.convertTo(value, argumentClass, conversor);
            } else if (value instanceof Number && Enum.class.isAssignableFrom(argumentClass)) {
                value = argumentClass.getEnumConstants()[((Number)value).intValue()];
            }
        }
        return argumentClass.isPrimitive() ? Cast.force(value) : argumentClass.cast(value);
    }

    @Override
    public DynamicObject asDynamicObject() {
        DynamicObject value = DynamicObject.create();
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            value.setField(entry.getKey(), entry.getValue());
        }
        return value;
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public Object clone() {
        return new ArgMap(this);
    }

    @Override
    public boolean contains(String argumentName) {
        return this.data.containsKey(argumentName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.data.size() * 40);
        buffer.append("ArgMap[");
        Set<Map.Entry<String, Object>> entries = this.data.entrySet();
        Iterator<Map.Entry<String, Object>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            buffer.append((Object)entry.getKey());
            buffer.append(" : ");
            buffer.append(entry.getValue());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }
}

