/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Cast;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyOnWriteFS
extends VFileSystem
implements VFileEventListener {
    private int cowId;
    private final String dataFileName;
    private Set<VFile> deletedFiles;
    @NotNull
    private final VFileSystem readFs;
    @NotNull
    private final VFileSystem writeFs;
    private static final String DELETED_FILES = "deletedFiles";

    public CopyOnWriteFS(@NotNull VFileSystem readFs, @NotNull VFileSystem writeFs) throws IOException {
        if (readFs == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.<init> must not be null");
        }
        if (writeFs == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.<init> must not be null");
        }
        this.readFs = readFs;
        this.writeFs = writeFs;
        this.readFs.addListener(this);
        this.writeFs.addListener(this);
        if (this.writeFs instanceof CopyOnWriteFS) {
            CopyOnWriteFS copyOnWriteFS = (CopyOnWriteFS)this.writeFs;
            this.cowId = copyOnWriteFS.cowId + 1;
        } else {
            this.cowId = 0;
        }
        this.dataFileName = "/deletedFiles" + this.cowId;
        this.readDeletedFileData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Set<VFile> readSerializedObject(@NotNull InputStream is, final @Nullable ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Set result;
        if (is == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.readSerializedObject must not be null");
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ObjectInputStream ois = new ObjectInputStream(bis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    return Class.forName(desc.getName(), true, classLoader);
                }
            };
            result = (Set)Cast.force(ois.readObject());
            ois.close();
        }
        catch (Throwable throwable) {
            CopyOnWriteFS.close(is);
            throw throwable;
        }
        CopyOnWriteFS.close(is);
        Set set = result;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/CopyOnWriteFS.readSerializedObject must not return null");
        }
        return set;
    }

    public Collection<VFile> getDeletedFiles() {
        return Collections.unmodifiableSet(this.deletedFiles);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFileSystem getReadFileSystem() {
        VFileSystem vFileSystem = this.readFs;
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/CopyOnWriteFS.getReadFileSystem must not return null");
        }
        return vFileSystem;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFileSystem getWriteFileSystem() {
        VFileSystem vFileSystem = this.writeFs;
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/CopyOnWriteFS.getWriteFileSystem must not return null");
        }
        return vFileSystem;
    }

    @Override
    public VFile createFile(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.createFile must not be null");
        }
        return this.checkValidFileName(super.createFile(location));
    }

    @Override
    public void flush() throws IOException {
        this.writeDeletedFileData();
        this.readFs.flush();
        this.writeFs.flush();
    }

    @Override
    public void onFileEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.onFileEvent must not be null");
        }
        if (!this.dataFileName.equals(event.getSource().getCanonicalPath())) {
            this.fireEvent(new VFileEvent(event.getType(), this.toCowFs(event.getSource())));
        }
    }

    @Override
    public long lastModified(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.lastModified must not be null");
        }
        return !this.deletedFiles.contains(vFile) ? this.toReadFs(vFile).lastModified() : this.toWriteFs(vFile).lastModified();
    }

    @Override
    public boolean isZeroLength(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.isZeroLength must not be null");
        }
        return !this.exists(vFile) || (this.toWriteFs(vFile).exists() ? this.toWriteFs(vFile).isZeroLength() : this.deletedFiles.contains(vFile) || this.toReadFs(vFile).isZeroLength());
    }

    @Override
    public VFile[] list(@NotNull VFile vFile, @Nullable VFileFilter filter) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.list must not be null");
        }
        if (!this.isDirectory(vFile)) {
            return new VFile[0];
        }
        HashSet<VFile> result = new HashSet<VFile>();
        if (this.exists(vFile)) {
            VFile[] list;
            for (VFile readFile : this.readFs.list(this.toReadFs(vFile), null)) {
                result.add(this.toCowFs(readFile));
            }
            result.removeAll(this.deletedFiles);
            for (VFile readFile : list = this.writeFs.list(this.toWriteFs(vFile), null)) {
                result.add(this.toCowFs(readFile));
            }
            result.remove(super.createFile(this.dataFileName));
            if (filter != null) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    VFile file = (VFile)it.next();
                    if (filter.accept(file)) continue;
                    it.remove();
                }
            }
        }
        return result.toArray(new VFile[result.size()]);
    }

    @Override
    public void closeOutputStream(@NotNull VFile event, @NotNull OutputStream out) throws IOException {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.closeOutputStream must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.closeOutputStream must not be null");
        }
        this.writeFs.closeOutputStream(event, out);
    }

    public String getDeletedFileName() {
        return this.dataFileName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String getUniqueID() {
        String string = this.readFs.getUniqueID() + ';' + this.writeFs.getUniqueID();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/CopyOnWriteFS.getUniqueID must not return null");
        }
        return string;
    }

    @Override
    protected boolean delete(@NotNull VFile vFile) {
        boolean deleted;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.delete must not be null");
        }
        if (this.isRoot(vFile)) {
            return false;
        }
        if (this.exists(vFile)) {
            VFile wFile = this.toWriteFs(vFile);
            wFile.delete();
            VFile rFile = this.toReadFs(vFile);
            if (rFile.exists()) {
                this.deletedFiles.add(vFile);
                this.fireEvent(new VFileEvent(VEventType.REMOVE, vFile));
            }
            deleted = true;
        } else {
            deleted = false;
        }
        return deleted;
    }

    @Override
    protected boolean mkdirs(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.mkdirs must not be null");
        }
        for (VFile p = vFile; p != null; p = p.getParentFile()) {
            this.deletedFiles.remove(p);
        }
        return this.toWriteFs(vFile).mkdirs();
    }

    @Override
    protected boolean exists(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.exists must not be null");
        }
        return this.toReadFs(vFile).exists() && !this.deletedFiles.contains(vFile) || this.toWriteFs(vFile).exists();
    }

    @Override
    protected boolean isDirectory(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.isDirectory must not be null");
        }
        return this.exists(vFile) && (this.toReadFs(vFile).isDirectory() || this.toWriteFs(vFile).isDirectory());
    }

    @Override
    protected boolean isFile(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.isFile must not be null");
        }
        return this.exists(vFile) && (this.toReadFs(vFile).isFile() || this.toWriteFs(vFile).isFile());
    }

    @Override
    protected boolean canWrite(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.canWrite must not be null");
        }
        return this.toReadFs(vFile).canWrite() && !this.deletedFiles.contains(vFile) || this.toWriteFs(vFile).canWrite();
    }

    @Override
    protected InputStream openInputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.openInputStream must not be null");
        }
        if (!this.exists(vFile)) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        VFile wFile = this.toWriteFs(vFile);
        if (wFile.exists()) {
            return wFile.openInputStream();
        }
        return this.toReadFs(vFile).openInputStream();
    }

    @Override
    protected boolean isHidden(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.isHidden must not be null");
        }
        return this.exists(vFile) && (this.toReadFs(vFile).isHidden() || this.toWriteFs(vFile).isHidden());
    }

    @Override
    protected OutputStream openOutputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.openOutputStream must not be null");
        }
        VFile parent = vFile.getParentFile();
        if (!this.exists(parent)) {
            throw new FileNotFoundException(parent.toString());
        }
        boolean existedBefore = this.exists(vFile);
        parent.mkdirs();
        this.deletedFiles.remove(vFile);
        VFile writeVFile = this.toWriteFs(vFile);
        OutputStream outputStream = writeVFile.openOuputStream();
        vFile.setCreated(!existedBefore);
        writeVFile.setCreated(!existedBefore);
        return outputStream;
    }

    private static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable closeableObject : closeable) {
                if (closeableObject == null) continue;
                try {
                    closeableObject.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private void readDeletedFileData() throws IOException {
        VFile files = this.writeFs.createFile(this.dataFileName);
        if (files.exists()) {
            try {
                this.deletedFiles = CopyOnWriteFS.readSerializedObject(new VFileInputStream(files), this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw (IOException)new IOException("Unable to read deleted file data. Class not found: " + e.getMessage()).initCause(e);
            }
        } else {
            this.deletedFiles = new HashSet<VFile>();
        }
    }

    private VFile checkValidFileName(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.checkValidFileName must not be null");
        }
        if (vFile.getCanonicalPath().equals(this.dataFileName)) {
            throw new UnsupportedOperationException("Illegal file name: " + vFile);
        }
        return vFile;
    }

    private void writeDeletedFileData() throws IOException {
        VFile file = this.writeFs.createFile(this.dataFileName);
        if (!this.deletedFiles.isEmpty()) {
            StreamUtils.writeSerializedObject(new VFileOutputStream(file), this.deletedFiles);
        } else if (file.exists()) {
            file.delete();
        }
    }

    private VFile toReadFs(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.toReadFs must not be null");
        }
        assert (file.getFileSystem() == this);
        return this.readFs.createFile(file.getCanonicalPath());
    }

    private VFile toWriteFs(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.toWriteFs must not be null");
        }
        assert (file.getFileSystem() == this);
        return this.writeFs.createFile(file.getCanonicalPath());
    }

    private VFile toCowFs(@NotNull VFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/CopyOnWriteFS.toCowFs must not be null");
        }
        VFile ret = file;
        if (file.getFileSystem() != this) {
            ret = super.createFile(file.getCanonicalPath());
        }
        return ret;
    }

    private boolean isRoot(VFile vFile) {
        return this.getRoot().equals(vFile);
    }
}

