/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.Point2D;
import java.io.Serializable;
import oracle.bpm.collections.lists.IntList;
import oracle.bpm.geom.Dimension;
import org.jetbrains.annotations.NotNull;

public class Point
implements Serializable {
    private final int x;
    private final int y;
    private static final long serialVersionUID = -5276940640259749850L;
    static final long serialCheck = -1226120066195745788L;
    public static final Point ORIGIN = new Point(0, 0){
        private static final long serialVersionUID = 0L;

        @Override
        @NotNull
        public Point transposed() {
            return this;
        }

        @Override
        @NotNull
        public Point flip() {
            return this;
        }

        @Override
        @NotNull
        public Point scaled(float scale) {
            return this;
        }

        @Override
        @NotNull
        public Point unscaled(float scale) {
            return this;
        }

        @Override
        public Point normalize(int unit) {
            return this;
        }
    };

    public Point() {
        this(0, 0);
    }

    public Point(Point point) {
        this(point.getX(), point.getY());
    }

    public Point(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.<init> must not be null");
        }
        IntList coords = IntList.createFromString(str);
        this.x = (Integer)coords.get(0);
        this.y = (Integer)coords.get(1);
    }

    public Point(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y) {
        this((int)Math.round(x), (int)Math.round(y));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public static double angle(double x0, double y0, double x1, double y1) {
        double deltaY = y1 - y0;
        double deltaX = x1 - x0;
        return deltaX == 0.0 ? (deltaY >= 0.0 ? 1.5707963267948966 : 4.71238898038469) : (deltaX < 0.0 ? Math.PI + Math.atan(deltaY / deltaX) : Math.atan(deltaY / deltaX));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Point avg(Point ... points) {
        Point point;
        if (points == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.avg must not be null");
        }
        int avgX = 0;
        int avgY = 0;
        Point[] arr$ = points;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; avgX += point.x, avgY += point.y, ++i$) {
            point = arr$[i$];
        }
        Point point2 = new Point(avgX / points.length, avgY / points.length);
        if (point2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.avg must not return null");
        }
        return point2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point add(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.add must not be null");
        }
        Point point2 = this.add(point.x, point.y);
        if (point2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.add must not return null");
        }
        return point2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point add(int addX, int addY) {
        Point point = new Point(this.x + addX, this.y + addY);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.add must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point sub(int subX, int subY) {
        Point point = new Point(this.x - subX, this.y - subY);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.sub must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point sub(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.sub must not be null");
        }
        Point point2 = this.sub(point.x, point.y);
        if (point2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.sub must not return null");
        }
        return point2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point div(int divisor) {
        Point point = new Point(this.x / divisor, this.y / divisor);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.div must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point mul(int times) {
        Point point = new Point(this.x * times, this.y * times);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.mul must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Dimension delta(@NotNull Point origin) {
        if (origin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.delta must not be null");
        }
        Dimension dimension = Dimension.valueOf(this.deltaX(origin), this.deltaY(origin));
        if (dimension == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.delta must not return null");
        }
        return dimension;
    }

    public int deltaX(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.deltaX must not be null");
        }
        return this.getX() - that.getX();
    }

    public int deltaY(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.deltaY must not be null");
        }
        return this.getY() - that.getY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Dimension dimension(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.dimension must not be null");
        }
        Dimension dimension = Dimension.valueOf(this.getX() - that.getX(), this.getY() - that.getY());
        if (dimension == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.dimension must not return null");
        }
        return dimension;
    }

    public Point normalize(int unit) {
        return new Point(this.getX() != 0 ? this.getX() * unit / Math.abs(this.getX()) : 0, this.getY() != 0 ? this.getY() * unit / Math.abs(this.getY()) : 0);
    }

    public double distance(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.distance must not be null");
        }
        double deltaX = point.getX() - this.getX();
        double deltaY = point.getY() - this.getY();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public double distanceSq(double px, double py) {
        return (px -= (double)this.getX()) * px + (py -= (double)this.getY()) * py;
    }

    public double distanceSq(Point point) {
        return this.distanceSq(point.getX(), point.getY());
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && (result = obj instanceof Point)) {
            Point pt = (Point)obj;
            result = this.getX() == pt.getX() && this.getY() == pt.getY();
        }
        return result;
    }

    public int hashCode() {
        return 29 * this.getX() + this.getY();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point max(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.max must not be null");
        }
        Point point = new Point(Math.max(this.getX(), that.getX()), Math.max(this.getY(), that.getY()));
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.max must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point min(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.min must not be null");
        }
        Point point = new Point(Math.min(this.getX(), that.getX()), Math.min(this.getY(), that.getY()));
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.min must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point scaled(float scale) {
        Point point = new Point(Math.round((float)this.x * scale), Math.round((float)this.y * scale));
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.scaled must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point unscaled(float scale) {
        Point point = new Point(Math.round((float)this.x / scale), Math.round((float)this.y / scale));
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.unscaled must not return null");
        }
        return point;
    }

    public String toString() {
        return "[" + this.getX() + ", " + this.getY() + "]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point translate(int dx, int dy) {
        Point point = new Point(this.getX() + dx, this.getY() + dy);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.translate must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point translate(Dimension dimension) {
        Point point = this.translate(dimension.getWidth(), dimension.getHeight());
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.translate must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point translate(Point point) {
        Point point2 = this.translate(point.getX(), point.getY());
        if (point2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.translate must not return null");
        }
        return point2;
    }

    public double angle(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.angle must not be null");
        }
        return Point.angle(this.x, this.y, that.x, that.y);
    }

    public double slope(@NotNull Point that) {
        if (that == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Point.slope must not be null");
        }
        double deltaX = this.x - that.x;
        double deltaY = this.y - that.y;
        return deltaX != 0.0 ? Math.atan(deltaY / deltaX) : 1.5707963267948966;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point transposed() {
        Point point = new Point(this.y, this.x);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.transposed must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point flip() {
        Point point = this.mul(-1);
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Point.flip must not return null");
        }
        return point;
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

