/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.Ellipse2D;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.geom.RectangularShape;

public class Ellipse
extends RectangularShape {
    public Ellipse() {
        this(Point.ORIGIN, Dimension.ZERO);
    }

    public Ellipse(Rectangle r) {
        this(r.getOrigin(), r.getSize());
    }

    public Ellipse(Point origin) {
        this(origin, Dimension.ZERO);
    }

    public Ellipse(Dimension dimension) {
        this(Point.ORIGIN, dimension);
    }

    public Ellipse(Ellipse2D ellipse2D) {
        this(new Rectangle(ellipse2D.getBounds()));
    }

    public Ellipse(int width, int height) {
        this(Point.ORIGIN, Dimension.valueOf(width, height));
    }

    public Ellipse(Point origin, Point top) {
        this(origin, top.delta(origin));
    }

    public Ellipse(Point origin, Dimension dimension) {
        super(origin, dimension);
    }

    public Ellipse(int x, int y, int width, int height) {
        this(new Point(x, y), Dimension.valueOf(width, height));
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        double neary;
        if (w <= 0 || h <= 0) {
            return false;
        }
        int ellw = this.getWidth();
        if (ellw <= 0) {
            return false;
        }
        double normx0 = (double)((x - this.getX()) / ellw) - 0.5;
        double normx1 = normx0 + (double)(w / ellw);
        int ellh = this.getHeight();
        if (ellh <= 0) {
            return false;
        }
        double normy0 = (double)((y - this.getY()) / ellh) - 0.5;
        double normy1 = normy0 + (double)(h / ellh);
        double nearx = this.near(normx0, normx1);
        return nearx * nearx + (neary = this.near(normy0, normy1)) * neary < 0.25;
    }

    @Override
    public boolean isEmpty() {
        return this.getWidth() <= 0 || this.getHeight() <= 0;
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(int x, int y) {
        int ellw = this.getWidth();
        if (ellw <= 0) {
            return false;
        }
        double normx = (double)((x - this.getX()) / ellw) - 0.5;
        int ellh = this.getHeight();
        if (ellh <= 0) {
            return false;
        }
        double normy = (double)((y - this.getY()) / ellh) - 0.5;
        return normx * normx + normy * normy < 0.25;
    }

    private double near(double normx0, double normx1) {
        double nearx = normx0 > 0.0 ? normx0 : (normx1 < 0.0 ? normx1 : 0.0);
        return nearx;
    }
}

