/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import oracle.bpm.collections.Predicate;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Elbow
implements Path {
    public double ctrlx;
    public double ctrly;
    public double x1;
    public double x2;
    public double xa;
    public double xb;
    public double y1;
    public double y2;
    public double ya;
    public double yb;
    private GeneralPath path;
    private double tac;
    private double tbt;
    private double tcb;
    private double tsa;
    private static final Predicate<Integer> ODD_ROTATION = new Predicate<Integer>(){

        @Override
        public boolean check(@Nullable Integer value) {
            return value != null && value % 2 == 0;
        }
    };
    private static final Predicate<Integer> EVEN_ROTATION = new Predicate<Integer>(){

        @Override
        public boolean check(@Nullable Integer value) {
            return value != null && value % 2 != 0;
        }
    };
    private static final Predicate<Integer> LESS_TWO = new Predicate<Integer>(){

        @Override
        public boolean check(@Nullable Integer value) {
            return value != null && value < 2;
        }
    };
    private static final Predicate<Integer> MORE_TWO = new Predicate<Integer>(){

        @Override
        public boolean check(@Nullable Integer value) {
            return value != null && value >= 2;
        }
    };
    private static final int ARC_SIZE = 5;

    public Elbow(@NotNull Point p1, @NotNull Point ctrl, @NotNull Point p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Elbow.<init> must not be null");
        }
        if (ctrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/Elbow.<init> must not be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/geom/Elbow.<init> must not be null");
        }
        this(p1.getX(), p1.getY(), ctrl.getX(), ctrl.getY(), p2.getX(), p2.getY());
    }

    public Elbow(double x1, double y1, double ctrlX, double ctrlY, double x2, double y2) {
        this.setElbow(x1, y1, ctrlX, ctrlY, x2, y2);
    }

    private Elbow(double x1, double y1, double xa, double ya, double ctrlX, double ctrlY, double xb, double yb, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.xa = xa;
        this.ya = ya;
        this.ctrlx = ctrlX;
        this.ctrly = ctrlY;
        this.xb = xb;
        this.yb = yb;
        this.x2 = x2;
        this.y2 = y2;
        this.calculateTimeChunks();
        this.calculateGeneralPath();
    }

    @Override
    public Point2D eval(double t) {
        Point2D.Double result;
        if (t <= this.tsa) {
            double u = 1.0 - (t /= this.tsa);
            result = new Point2D.Double(this.x1 * u + this.xa * t, this.y1 * u + this.ya * t);
        } else if (t <= this.tac) {
            t = (t - this.tsa) / (this.tac - this.tsa);
            double u = 1.0 - t;
            result = new Point2D.Double(this.xa * u + this.ctrlx * t, this.ya * u + this.ctrly * t);
        } else if (t <= this.tcb) {
            t = (t - this.tac) / (this.tcb - this.tac);
            double u = 1.0 - t;
            result = new Point2D.Double(this.ctrlx * u + this.xb * t, this.ctrly * u + this.yb * t);
        } else if (t <= this.tbt) {
            t = (t - this.tcb) / (this.tbt - this.tcb);
            double u = 1.0 - t;
            result = new Point2D.Double(this.xb * u + this.x2 * t, this.yb * u + this.y2 * t);
        } else {
            throw new IllegalStateException("Oooooooops! t value : " + t);
        }
        return result;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        boolean result = rectangle.intersectsLine((int)this.x1, (int)this.y1, (int)this.xa, (int)this.ya);
        result |= rectangle.intersectsLine((int)this.xa, (int)this.ya, (int)this.ctrlx, (int)this.ctrly);
        result |= rectangle.intersectsLine((int)this.ctrlx, (int)this.ctrly, (int)this.xb, (int)this.yb);
        return result |= rectangle.intersectsLine((int)this.xb, (int)this.yb, (int)this.x2, (int)this.y2);
    }

    @Override
    public java.awt.Rectangle getBounds() {
        Rectangle result = this.getRectangleBounds();
        return new java.awt.Rectangle(result.getX(), result.getY(), result.getWidth(), result.getHeight());
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle result = this.getRectangleBounds();
        return new Rectangle2D.Double(result.getX(), result.getY(), result.getWidth(), result.getHeight());
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        boolean result = r.intersectsLine((int)this.x1, (int)this.y1, (int)this.xa, (int)this.ya);
        result |= r.intersectsLine((int)this.xa, (int)this.ya, (int)this.ctrlx, (int)this.ctrly);
        result |= r.intersectsLine((int)this.ctrlx, (int)this.ctrly, (int)this.xb, (int)this.yb);
        return result |= r.intersectsLine((int)this.xb, (int)this.yb, (int)this.x2, (int)this.y2);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public Path scaled(float scale) {
        return scale == 1.0f ? this : new Elbow(this.x1 * (double)scale, this.y1 * (double)scale, this.xa * (double)scale, this.ya * (double)scale, this.ctrlx * (double)scale, this.ctrly * (double)scale, this.xb * (double)scale, this.yb * (double)scale, this.x2 * (double)scale, this.y2 * (double)scale);
    }

    @Override
    public Point2D findPoint(Point2D point, double distance, double base) {
        return this.findPoint(point, distance, base, 1.0, true);
    }

    @Override
    public Point2D findPointBackwards(Point2D point, double distance, double base) {
        return this.findPoint(point, distance, 0.0, base, false);
    }

    public Point2D findPoint(Point2D point, double distance, double low, double high, boolean fwd) {
        double distanceSq = distance * distance;
        double tolerance = distanceSq / 10000.0;
        Point2D p2 = point;
        while (low < high) {
            double mid = (low + high) / 2.0;
            Point2D p = this.eval(mid);
            if (Math.floor(p.getX()) == Math.floor(p2.getX()) && Math.floor(p.getY()) == Math.floor(p2.getY())) {
                return p;
            }
            double diff = distanceSq - point.distanceSq(p);
            if (diff > tolerance) {
                if (fwd) {
                    low = mid;
                } else {
                    high = mid;
                }
            } else if (diff < -tolerance) {
                if (fwd) {
                    high = mid;
                } else {
                    low = mid;
                }
            } else {
                return p;
            }
            p2 = p;
        }
        return p2;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform transform) {
        return this.path.getPathIterator(transform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform transform, double flatness) {
        return this.getPathIterator(transform);
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public Point getControlPoint() {
        return new Point(this.ctrlx, this.ctrly);
    }

    @Override
    public Elbow cropped(double t0, double t1) {
        double xa = this.xa;
        double ya = this.ya;
        double ctrlx = this.ctrlx;
        double ctrly = this.ctrly;
        double xb = this.xb;
        double yb = this.yb;
        Point2D begin = this.eval(t0);
        double x1 = begin.getX();
        double y1 = begin.getY();
        if (t0 > this.tsa) {
            xa = x1;
            ya = y1;
        }
        if (t0 > this.tac) {
            ctrlx = x1;
            ctrly = y1;
        }
        if (t0 > this.tcb) {
            xb = x1;
            yb = y1;
        }
        Point2D end = this.eval(t1);
        double x2 = end.getX();
        double y2 = end.getY();
        if (t1 < this.tcb) {
            xb = x2;
            yb = y2;
        }
        if (t1 < this.tac) {
            ctrlx = x2;
            ctrly = y2;
        }
        if (t1 < this.tsa) {
            xa = x2;
            ya = y2;
        }
        return new Elbow(x1, y1, xa, ya, ctrlx, ctrly, xb, yb, x2, y2);
    }

    public String toString() {
        return "Elbow [ from " + new Point(this.x1, this.y1) + ", ctrl " + new Point(this.ctrlx, this.ctrly) + ", to " + new Point(this.x2, this.y2) + " ]";
    }

    private void setElbow(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx = ctrlx;
        this.ctrly = ctrly;
        this.x2 = x2;
        this.y2 = y2;
        int rot = this.rotation();
        Quadrant quad = this.quadrant();
        Point a = this.midpoint(x1, y1, ctrlx, ctrly, quad.flipA(rot));
        this.xa = a.getX();
        this.ya = a.getY();
        Point b = this.midpoint(ctrlx, ctrly, x2, y2, quad.flipB(rot));
        this.xb = b.getX();
        this.yb = b.getY();
        this.calculateTimeChunks();
        this.calculateGeneralPath();
    }

    private int rotation() {
        return this.x2 - this.x1 >= 0.0 ? (this.y2 - this.y1 >= 0.0 ? 0 : 2) : (this.y2 - this.y1 >= 0.0 ? 1 : 3);
    }

    private Quadrant quadrant() {
        Quadrant result = Quadrant.FIVE;
        double minX = Math.min(this.x1, this.x2);
        double maxX = Math.max(this.x1, this.x2);
        double minY = Math.min(this.y1, this.y2);
        double maxY = Math.max(this.y1, this.y2);
        for (Quadrant quadrant : Quadrant.values()) {
            if (!quadrant.accepts(minX, minY, this.ctrlx, this.ctrly, maxX, maxY)) continue;
            result = quadrant;
            break;
        }
        return result;
    }

    private Point midpoint(double sourceX, double sourceY, double targetX, double targetY, boolean flip) {
        double y;
        double angle = Point.angle(sourceX, sourceY, targetX, targetY);
        double x = flip ? Math.max(sourceX, targetX) : Math.min(sourceX, targetX);
        double d = y = flip ? Math.max(sourceY, targetY) : Math.min(sourceY, targetY);
        if (angle > 0.0 && angle < 1.5707963267948966) {
            x = flip ? Math.min(sourceX, targetX) : Math.max(sourceX, targetX);
        } else if (angle >= 1.5707963267948966 && angle <= Math.PI) {
            x = flip ? Math.min(sourceX, targetX) : Math.max(sourceX, targetX);
            y = flip ? Math.min(sourceY, targetY) : Math.max(sourceY, targetY);
        } else if (angle > Math.PI && angle < 4.71238898038469) {
            y = flip ? Math.min(sourceY, targetY) : Math.max(sourceY, targetY);
        }
        return new Point(x, y);
    }

    private void calculateTimeChunks() {
        double bt;
        double cb;
        double ac;
        double sa = Math.abs(this.x1 - this.xa) + Math.abs(this.y1 - this.ya);
        double length = sa + (ac = Math.abs(this.xa - this.ctrlx) + Math.abs(this.ya - this.ctrly)) + (cb = Math.abs(this.ctrlx - this.xb) + Math.abs(this.ctrly - this.yb)) + (bt = Math.abs(this.xb - this.x2) + Math.abs(this.yb - this.y2));
        if (length != 0.0) {
            this.tsa = sa / length;
            this.tac = this.tsa + ac / length;
            this.tcb = this.tac + cb / length;
            this.tbt = 1.0;
        }
    }

    private void calculateGeneralPath() {
        this.path = new GeneralPath();
        Point begin = new Point(this.x1, this.y1);
        this.path.moveTo(begin.getX(), begin.getY());
        begin = this.appendArc(this.path, begin, new Point(this.xa, this.ya), new Point(this.ctrlx, this.ctrly));
        begin = this.appendArc(this.path, begin, new Point(this.ctrlx, this.ctrly), new Point(this.xb, this.yb));
        this.appendArc(this.path, begin, new Point(this.xb, this.yb), new Point(this.x2, this.y2));
        this.path.lineTo(this.x2, this.y2);
    }

    private Point appendArc(@NotNull GeneralPath path, Point a, Point b, Point c) {
        Point result;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Elbow.appendArc must not be null");
        }
        if (!this.perpendicular(a, b, c)) {
            path.lineTo(b.getX(), b.getY());
            result = b;
        } else {
            Point ab = b.add(a.sub(b).normalize(5));
            Point cb = b.add(c.sub(b).normalize(5));
            path.lineTo(ab.getX(), ab.getY());
            path.curveTo(ab.getX(), ab.getY(), b.getX(), b.getY(), cb.getX(), cb.getY());
            result = cb;
        }
        return result;
    }

    private boolean perpendicular(@NotNull Point a, @NotNull Point b, @NotNull Point c) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Elbow.perpendicular must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/Elbow.perpendicular must not be null");
        }
        if (c == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/geom/Elbow.perpendicular must not be null");
        }
        return Math.abs(a.deltaX(b)) < 5 ? Math.abs(b.deltaX(c)) >= 5 : Math.abs(a.deltaY(b)) < 5 && Math.abs(b.deltaY(c)) >= 5;
    }

    private Rectangle getRectangleBounds() {
        return new Rectangle(new Point(Math.min(Math.min(this.x1, this.x2), this.ctrlx), Math.min(Math.min(this.y1, this.y2), this.ctrly)), new Point(Math.max(Math.max(this.x1, this.x2), this.ctrlx), Math.max(Math.max(this.y1, this.y2), this.ctrly)));
    }

    static /* synthetic */ Predicate access$200() {
        return EVEN_ROTATION;
    }

    static /* synthetic */ Predicate access$400() {
        return LESS_TWO;
    }

    static /* synthetic */ Predicate access$500() {
        return ODD_ROTATION;
    }

    static /* synthetic */ Predicate access$600() {
        return MORE_TWO;
    }

    private static class ElbowPathIterator
    implements PathIterator {
        private final Elbow elbow;
        private int index;
        private final AffineTransform transform;
        private static final int ELBOW_POINTS = 6;

        private ElbowPathIterator(Elbow elbow, AffineTransform at) {
            this.elbow = elbow;
            this.transform = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > 6;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= 6) {
                return 4;
            }
            switch (this.index) {
                case 0: {
                    coords[0] = (float)this.elbow.x1;
                    coords[1] = (float)this.elbow.y1;
                    break;
                }
                case 1: {
                    coords[0] = (float)this.elbow.xa;
                    coords[1] = (float)this.elbow.ya;
                    break;
                }
                case 2: {
                    coords[0] = (float)this.elbow.ctrlx;
                    coords[1] = (float)this.elbow.ctrly;
                    break;
                }
                case 3: {
                    coords[0] = (float)this.elbow.xb;
                    coords[1] = (float)this.elbow.yb;
                    break;
                }
                case 4: 
                case 5: {
                    coords[0] = (float)this.elbow.x2;
                    coords[1] = (float)this.elbow.y2;
                }
            }
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 || this.index == 5 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= 6) {
                return 4;
            }
            switch (this.index) {
                case 0: {
                    coords[0] = this.elbow.x1;
                    coords[1] = this.elbow.y1;
                    break;
                }
                case 1: {
                    coords[0] = this.elbow.xa;
                    coords[1] = this.elbow.ya;
                    break;
                }
                case 2: {
                    coords[0] = this.elbow.ctrlx;
                    coords[1] = this.elbow.ctrly;
                    break;
                }
                case 3: {
                    coords[0] = this.elbow.xb;
                    coords[1] = this.elbow.yb;
                    break;
                }
                case 4: 
                case 5: {
                    coords[0] = this.elbow.x2;
                    coords[1] = this.elbow.y2;
                }
            }
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 || this.index == 5 ? 0 : 1;
        }
    }

    private static enum Quadrant {
        ONE(Elbow.access$200(), Elbow.access$200()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return ctrlX < minX && ctrlY < minY;
            }
        }
        ,
        TWO(Elbow.access$200(), Elbow.access$200()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return minX <= ctrlX && ctrlX <= maxX && ctrlY <= minY;
            }
        }
        ,
        THREE(Elbow.access$200(), Elbow.access$200()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return maxX < ctrlX && ctrlY < minY;
            }
        }
        ,
        FOUR(Elbow.access$400(), Elbow.access$400()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return ctrlX <= minX && minY <= ctrlY && ctrlY <= maxY;
            }
        }
        ,
        FIVE(Elbow.access$200(), Elbow.access$500()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return minY <= ctrlY && ctrlY <= maxY && minX <= ctrlX && ctrlX <= maxX;
            }
        }
        ,
        SIX(Elbow.access$600(), Elbow.access$600()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return maxX <= ctrlX && minY <= ctrlY && ctrlY <= maxY;
            }
        }
        ,
        SEVEN(Elbow.access$500(), Elbow.access$500()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return ctrlX < minX && maxY < ctrlY;
            }
        }
        ,
        EIGHT(Elbow.access$500(), Elbow.access$500()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return minX <= ctrlX && ctrlX <= maxX && maxY <= ctrlY;
            }
        }
        ,
        NINE(Elbow.access$500(), Elbow.access$500()){

            @Override
            public boolean accepts(double minX, double minY, double ctrlX, double ctrlY, double maxX, double maxY) {
                return maxX < ctrlX && maxY < ctrlY;
            }
        };

        private final Predicate<Integer> flipA;
        private final Predicate<Integer> flipB;

        private Quadrant(Predicate<Integer> flipA, Predicate<Integer> flipB) {
            if (string == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Elbow$Quadrant.<init> must not be null");
            }
            this.flipA = flipA;
            this.flipB = flipB;
        }

        private boolean flipA(int rotation) {
            return this.flipA.check(rotation);
        }

        private boolean flipB(int rotation) {
            return this.flipB.check(rotation);
        }

        abstract boolean accepts(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

