/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.execution.listener;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.execution.InterceptorChain;
import oracle.bpm.execution.listener.ExecutionListener;
import oracle.bpm.execution.listener.VetoExecutionException;

public class ExecutionInterceptor
implements Interceptor {
    private ExecutionListener<Executable> listener;
    private ThreadLocal<List<Executable>> pendingEvents = new ThreadLocal();

    public ExecutionInterceptor(ExecutionListener<Executable> listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Executable executable, InterceptorChain chain) throws ExecutionException {
        List<Executable> events = this.pendingEvents.get();
        if (events == null) {
            events = new ArrayList<Executable>();
            this.pendingEvents.set(events);
        }
        boolean isTop = events.isEmpty();
        try {
            this.listener.beforeExecution(executable);
            events.add(executable);
            Object object = chain.proceed(executable);
            return object;
        }
        catch (VetoExecutionException veto) {
            throw veto;
        }
        catch (Throwable e) {
            this.listener.onException(executable, e);
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            if (isTop) {
                this.flushEvents(events);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEvents(List<Executable> events) {
        try {
            for (Executable event : events) {
                this.listener.afterExecution(event);
            }
        }
        finally {
            events.clear();
        }
    }
}

