/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.command;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.command.Command;
import oracle.bpm.command.CommandHistory;
import oracle.bpm.command.CommandHistoryListener;
import oracle.bpm.lang.Platform;

public class DefaultCommandHistory
implements CommandHistory {
    private List<Command> commands = new ArrayList<Command>();
    private int currentCommand = 0;
    private CommandHistoryListener listener;

    public DefaultCommandHistory(CommandHistoryListener listener) {
        this.listener = listener;
    }

    @Override
    public void add(Command command) {
        if (this.currentCommand < this.commands.size()) {
            this.commands = this.getUndoList();
        }
        this.commands.add(command);
        ++this.currentCommand;
        this.listener.afterAdd(command);
    }

    public List<Command> getUndoList() {
        return this.commands.subList(0, this.currentCommand);
    }

    public List<Command> getRedoList() {
        return this.commands.subList(this.currentCommand, this.commands.size());
    }

    public boolean canUndo() {
        return this.currentCommand > 0;
    }

    public boolean canRedo() {
        return this.currentCommand < this.commands.size();
    }

    public void undo() {
        assert (this.canUndo()) : "Nothing to undo";
        Command command = this.commands.get(--this.currentCommand);
        command.undo();
        this.listener.afterUndo(command);
    }

    public void redo() {
        assert (this.canRedo()) : "Nothing to redo";
        Command command = this.commands.get(this.currentCommand++);
        Platform.getExecutionService().execute(command);
        this.listener.afterRedo(command);
    }
}

