/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.bpm.lang.Cast;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private EntrySet m_entrySet;
    private Map<K, WeakValue<K, V>> m_hash;
    private final ReferenceQueue<V> m_queue = new ReferenceQueue();
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 16;

    public WeakValueHashMap() {
        this(16, 0.75f);
    }

    public WeakValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakValueHashMap(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.m_hash = new HashMap<K, WeakValue<K, V>>(initialCapacity, loadFactor);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.m_hash.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_hash.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    @Override
    public V get(Object key) {
        WeakValue<K, V> val = this.m_hash.get(key);
        return val == null ? null : (V)val.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValue<K, V> old = this.m_hash.put(key, WeakValue.create(key, value, this.m_queue));
        return old == null ? null : (V)old.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        WeakValue<K, V> val = this.m_hash.remove(key);
        return val == null ? null : (V)val.get();
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void processQueue() {
        WeakValue wv;
        while ((wv = (WeakValue)Cast.force(this.m_queue.poll())) != null) {
            this.m_hash.remove(wv.getKey());
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public Set<Map.Entry<K, WeakValue<K, V>>> getEntrySet() {
            return WeakValueHashMap.this.m_hash.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(this.getEntrySet().iterator());
        }

        @Override
        public boolean remove(Object o) {
            WeakValueHashMap.this.processQueue();
            boolean result = false;
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)Cast.force(o);
                Object ek = e.getKey();
                WeakValue wv = (WeakValue)WeakValueHashMap.this.m_hash.get(ek);
                boolean bl = wv == null ? WeakValueHashMap.this.m_hash.containsKey(ek) : (result = wv.get() != null);
                if (result) {
                    WeakValueHashMap.this.m_hash.remove(ek);
                }
            }
            return result;
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }
    }

    private static class WeakValue<K, V>
    extends WeakReference<V> {
        private final K m_key;
        private final ReferenceQueue<V> m_queue;

        private WeakValue(K k, V val, ReferenceQueue<V> q) {
            super(val, q);
            this.m_key = k;
            this.m_queue = q;
        }

        public static <V, K> WeakValue<K, V> create(K k, V val, ReferenceQueue<V> q) {
            return new WeakValue<K, V>(k, val, q);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WeakReference)) {
                return false;
            }
            Object o = ((Reference)obj).get();
            Object v = this.get();
            return WeakValueHashMap.equals(v, o);
        }

        public int hashCode() {
            Object v = this.get();
            return v == null ? 0 : v.hashCode();
        }

        public K getKey() {
            return this.m_key;
        }

        public ReferenceQueue<V> getQueue() {
            return this.m_queue;
        }
    }

    private static class EntrySetIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        boolean advance;
        final Iterator<Map.Entry<K, WeakValue<K, V>>> hashIterator;
        Entry<K, V> next;

        EntrySetIterator(Iterator<Map.Entry<K, WeakValue<K, V>>> iterator) {
            this.hashIterator = iterator;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            if (this.advance) {
                this.advance = false;
                this.advance();
            }
            return this.next != null;
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.advance = true;
            return this.next;
        }

        @Override
        public void remove() {
            if (!this.advance) {
                throw new IllegalStateException("must call next() first");
            }
            this.hashIterator.remove();
        }

        private void advance() {
            this.next = null;
            while (this.next == null && this.hashIterator.hasNext()) {
                Map.Entry<K, WeakValue<K, V>> ent = this.hashIterator.next();
                WeakValue<K, V> wv = ent.getValue();
                if (wv == null) {
                    this.next = new Entry<K, Object>(ent, null);
                    continue;
                }
                Object v = wv.get();
                if (v == null) continue;
                this.next = new Entry<K, V>(ent, v);
            }
        }
    }

    private static class Entry<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        private final Map.Entry<K, WeakValue<K, V>> m_ent;
        private static final long serialVersionUID = -5662616609804010149L;

        Entry(Map.Entry<K, WeakValue<K, V>> ent, V value) {
            super(ent.getKey(), value);
            this.m_ent = ent;
        }

        @Override
        public K getKey() {
            return this.m_ent.getKey();
        }

        @Override
        public V setValue(V value) {
            super.setValue(value);
            return (V)this.m_ent.setValue(this.create(value)).get();
        }

        private WeakValue<K, V> create(V value) {
            return WeakValue.create(this.m_ent.getKey(), value, this.m_ent.getValue().getQueue());
        }
    }
}

