/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.maps;

import java.util.Arrays;

public class LongMap<V> {
    private final float loadFactor;
    private int size;
    private Entry<V>[] table;
    private static final int[] validSizes = new int[]{53, 97, 193, 389, 769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843, 0x3000005, 100663319, 201326611, 402653189, 805306457, 0x60000005};

    public LongMap() {
        this(10, 0.75f);
    }

    public LongMap(int size, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = this.newEntryArray(size);
    }

    public V put(long key, V value) {
        int hash = (int)(key >>> 32);
        hash = (int)((long)hash ^ key);
        Entry<V>[] table = this.table;
        hash = (hash & Integer.MAX_VALUE) % table.length;
        V oldValue = null;
        Entry<V> e = table[hash];
        if (e == null) {
            Entry<V> newEntry = new Entry<V>(key, value);
            newEntry.next = newEntry;
            table[hash] = newEntry;
            this.entryAdded();
        } else {
            Entry<V> found = this.findEntry(e, key);
            if (found == null) {
                e = this.copyChain(e);
                Entry<V> newEntry = new Entry<V>(key, value);
                newEntry.next = e.next;
                e.next = newEntry;
                table[hash] = e;
                this.entryAdded();
            } else {
                oldValue = found.value;
                found.value = value;
            }
        }
        return oldValue;
    }

    public V get(long key) {
        Entry<V> found;
        int hash = (int)(key >>> 32);
        hash = (int)((long)hash ^ key);
        Entry<V>[] table = this.table;
        hash = (hash & Integer.MAX_VALUE) % table.length;
        V value = null;
        Entry<V> e = table[hash];
        if (e != null && (found = this.findEntry(e, key)) != null) {
            value = found.value;
        }
        return value;
    }

    public boolean containsKey(long key) {
        Entry<V> found;
        int hash = (int)(key >>> 32);
        hash = (int)((long)hash ^ key);
        Entry<V>[] table = this.table;
        hash = (hash & Integer.MAX_VALUE) % table.length;
        boolean result = false;
        Entry<V> e = table[hash];
        if (e != null && (found = this.findEntry(e, key)) != null) {
            result = true;
        }
        return result;
    }

    public V remove(long key) {
        int hash = (int)(key >>> 32);
        hash = (int)((long)hash ^ key);
        Entry<V>[] table = this.table;
        hash = (hash & Integer.MAX_VALUE) % table.length;
        V value = null;
        Entry<V> e = table[hash];
        if (e != null) {
            e = this.copyChain(e);
            if (e.key == key) {
                value = e.value;
                if (e.next == e) {
                    e = null;
                } else {
                    Entry first;
                    Entry current = first = e.next;
                    while (current != e) {
                        if (current.next == e) {
                            current.next = first;
                            break;
                        }
                        current = current.next;
                    }
                    e = first;
                }
            } else {
                Entry<V> last = e;
                Entry current = e.next;
                while (current != e) {
                    if (current.key == key) {
                        value = current.value;
                        last.next = current.next;
                        break;
                    }
                    last = current;
                    current = current.next;
                }
            }
            table[hash] = e;
            --this.size;
        }
        return value;
    }

    public void forEach(Visitor<V> visitor) {
        Entry<V>[] table;
        block0: for (Entry<V> entry : table = this.table) {
            if (entry == null) continue;
            if (!visitor.visit(entry.key, entry.value)) break;
            Entry current = entry.next;
            while (current != entry) {
                if (!visitor.visit(current.key, current.value)) break block0;
                current = current.next;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    private Entry<V>[] newEntryArray(int size) {
        return new Entry[this.findSize(size)];
    }

    private void entryAdded() {
        ++this.size;
        Entry<V>[] table = this.table;
        if ((float)this.size > this.loadFactor * (float)table.length) {
            Entry<V>[] newTable = this.newEntryArray(table.length * 2);
            for (Entry<V> entry : table) {
                if (entry == null) continue;
                Entry current = entry.next;
                Entry next = entry.next.next;
                while (current != entry) {
                    this.insert(new Entry(current.key, current.value), newTable);
                    current = next;
                    next = next.next;
                }
                this.insert(new Entry(entry.key, entry.value), newTable);
            }
            this.table = newTable;
        }
    }

    private void insert(Entry<V> entry, Entry<V>[] table) {
        int hash = (int)(entry.key >>> 32);
        hash = (int)((long)hash ^ entry.key);
        Entry<V> e = table[hash = (hash & Integer.MAX_VALUE) % table.length];
        if (e == null) {
            table[hash] = entry;
            entry.next = entry;
        } else {
            entry.next = e.next;
            e.next = entry;
        }
    }

    private Entry<V> findEntry(Entry<V> start, long key) {
        if (start.key == key) {
            return start;
        }
        Entry current = start.next;
        while (current != start) {
            if (current.key == key) {
                return current;
            }
            current = current.next;
        }
        return null;
    }

    private int findSize(int size) {
        int index = Arrays.binarySearch(validSizes, size);
        if (index < 0) {
            index = -(index + 1);
        }
        return validSizes[index];
    }

    private Entry<V> copyChain(Entry<V> start) {
        Entry root = new Entry(start.key, start.value);
        root.next = root;
        Entry current = start.next;
        Entry last = root;
        while (current != start) {
            Entry entry = new Entry(current.key, current.value);
            entry.next = root;
            last.next = entry;
            current = current.next;
            last = last.next;
        }
        return root;
    }

    private static class Entry<V> {
        long key;
        Entry<V> next;
        V value;

        public Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    public static interface Visitor<V> {
        public boolean visit(long var1, V var3);
    }
}

