/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    protected T next;
    private boolean advanced;
    private boolean hasCurrent;
    private boolean hasNext;

    @Override
    public final boolean hasNext() {
        if (!this.advanced) {
            this.hasNext = this.advance();
            if (!this.hasNext) {
                this.next = null;
            }
            this.hasCurrent = false;
            this.advanced = true;
        }
        return this.hasNext;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        this.hasCurrent = true;
        this.advanced = false;
        return result;
    }

    @Override
    public final void remove() {
        if (!this.hasCurrent) {
            throw new IllegalStateException();
        }
        this.remove0();
        this.hasCurrent = false;
    }

    protected abstract boolean advance();

    protected void remove0() {
        throw new UnsupportedOperationException();
    }
}

