/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.factory;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.factory.FCollectionFactory;
import oracle.bpm.collections.factory.FCollectionFactoryImpl;

public class CollectionFactory {
    private static FCollectionFactory instance;

    private CollectionFactory() {
    }

    public static synchronized FCollectionFactory getInstance() {
        if (instance == null) {
            instance = new FCollectionFactoryImpl();
        }
        return instance;
    }

    public static <K, V> Map<K, V> createMap() {
        return CollectionFactory.getInstance().createMap();
    }

    public static <T> List<T> createList() {
        return CollectionFactory.getInstance().createList();
    }

    public static <T> List<T> createListWith(T ... elements) {
        List<T> newList = CollectionFactory.createList();
        for (T t : elements) {
            newList.add(t);
        }
        return newList;
    }

    public static <T> Collection<T> createCollection() {
        return CollectionFactory.getInstance().createCollection();
    }

    public static <T> Collection<T> createCollectionWith(T ... elements) {
        Collection<T> newCollection = CollectionFactory.createCollection();
        for (T t : elements) {
            newCollection.add(t);
        }
        return newCollection;
    }

    public static <T> Set<T> createSet() {
        return CollectionFactory.getInstance().createSet();
    }

    public static <T> Set<T> createSet(Comparator<T> comparator) {
        return CollectionFactory.getInstance().createSet(comparator);
    }

    public static <T> Set<T> createSetWith(T ... elements) {
        Set<T> newList = CollectionFactory.createSet();
        for (T t : elements) {
            newList.add(t);
        }
        return newList;
    }
}

