/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.util.AbstractList;
import java.util.List;

public final class Permutation {
    private int[] data;
    private int n;

    private Permutation(int n, int[] data) {
        this.n = n;
        this.data = data;
    }

    public static <T> List<List<T>> listAll(final List<T> elements) {
        return new AbstractList<List<T>>(){
            final int size;
            {
                this.size = Permutation.factorial(elements.size());
            }

            @Override
            public List<T> get(int index) {
                return Permutation.createPermutation(elements.size(), index).applyTo(elements);
            }

            @Override
            public int size() {
                return this.size;
            }
        };
    }

    public static int factorial(int n) {
        int f = 1;
        while (n > 1) {
            f *= n--;
        }
        return f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (int i = 0; i < this.n; ++i) {
            sb.append(this.data[i]);
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    private static Permutation createPermutation(int n, int index) {
        int[] data = new int[n];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i;
        }
        int[] f = Permutation.factoradic(n, index);
        int[] temp = new int[n];
        for (int i = 0; i < f.length; ++i) {
            temp[i] = data[f[i]];
            System.arraycopy(data, f[i] + 1, data, f[i], n - f[i] - 1);
        }
        return new Permutation(n, temp);
    }

    private static int[] factoradic(int n, int k) {
        int[] factoradic = new int[n];
        for (int j = 1; j <= n; ++j) {
            factoradic[n - j] = k % j;
            k /= j;
        }
        if (k != 0) {
            throw new IndexOutOfBoundsException("k > n!");
        }
        return factoradic;
    }

    private <T> List<T> applyTo(final List<T> elements) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return elements.get(Permutation.this.data[index]);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
    }
}

