/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.iterator.AbstractIterator;
import oracle.bpm.collections.iterator.FilterIterator;
import oracle.bpm.collections.iterator.NoRemoveIterator;
import oracle.bpm.collections.iterator.ReverseIterable;
import oracle.bpm.collections.iterator.SingleValueIterator;
import oracle.bpm.collections.iterator.UnduplicateIterator;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.lang.Cast;
import oracle.bpm.util.ComparableComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionUtils {
    private CollectionUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> each(final @Nullable Iterator<T> iterator) {
        Iterable iterable = iterator == null ? CollectionUtils.emptyIterable() : new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.each must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> each(@Nullable Enumeration<T> enumeration) {
        IterableFromEnumeration<T> iterableFromEnumeration = enumeration == null || !enumeration.hasMoreElements() ? CollectionUtils.emptyIterable() : new IterableFromEnumeration<T>(enumeration);
        if (iterableFromEnumeration == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.each must not return null");
        }
        return iterableFromEnumeration;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> emptyIterable() {
        Iterable iterable = EmptyIterable.INSTANCE;
        if (iterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.emptyIterable must not return null");
        }
        return iterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterator<T> emptyIterator() {
        Iterator iterator = EmptyIterator.INSTANCE;
        if (iterator == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.emptyIterator must not return null");
        }
        return iterator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> BiMap<K, V> emptyBiMap() {
        BiMap biMap = EmptyBiMap.INSTANCE;
        if (biMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.emptyBiMap must not return null");
        }
        return biMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> emptySequence() {
        Sequence sequence = EmptySequence.INSTANCE;
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.emptySequence must not return null");
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> singletonSequence(T value) {
        SingletonSequence singletonSequence = new SingletonSequence(value);
        if (singletonSequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.singletonSequence must not return null");
        }
        return singletonSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> SortedSet<T> emptySortedSet() {
        SortedSet sortedSet = EmptySortedSetHolder.VALUE;
        if (sortedSet == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.emptySortedSet must not return null");
        }
        return sortedSet;
    }

    public static <K, V> Map<K, V> immutableMap(@Nullable Map<? extends K, ? extends V> map) {
        if (map == null || map instanceof ImmutableMap) {
            return (Map)Cast.force(map);
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> BiMap<K, V> immutableBiMap(@Nullable BiMap<? extends K, ? extends V> bm) {
        if (bm == null || bm instanceof ImmutableBiMap) {
            return (BiMap)Cast.force(bm);
        }
        if (bm.isEmpty()) {
            return CollectionUtils.emptyBiMap();
        }
        return new ImmutableBiMap<K, V>(bm);
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(@Nullable BiMap<? extends K, ? extends V> bm) {
        if (bm == null || bm instanceof UnmodifiableBiMap) {
            return (BiMap)Cast.force(bm);
        }
        if (bm.isEmpty()) {
            return CollectionUtils.emptyBiMap();
        }
        return new UnmodifiableBiMap<K, V>(bm);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> reverseList(@Nullable List<T> source) {
        ReverseIterable<T> reverseIterable = source == null ? CollectionUtils.emptyIterable() : new ReverseIterable<T>(source);
        if (reverseIterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.reverseList must not return null");
        }
        return reverseIterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> reverseIterable(@Nullable Iterable<T> source) {
        ReverseIterable<T> reverseIterable = source == null ? CollectionUtils.emptyIterable() : new ReverseIterable<T>(source);
        if (reverseIterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.reverseIterable must not return null");
        }
        return reverseIterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Collection<T> createCopy(@NotNull Iterable<T> sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.createCopy must not be null");
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : sequence) {
            result.add(element);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.createCopy must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> filterDuplicates(@Nullable Iterable<? extends T> iterable) {
        UnduplicateSequence<T> unduplicateSequence = iterable == null ? CollectionUtils.emptySequence() : new UnduplicateSequence<T>(iterable);
        if (unduplicateSequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.filterDuplicates must not return null");
        }
        return unduplicateSequence;
    }

    @Nullable
    public static <T> T first(@Nullable Iterable<T> iterable) {
        Iterator<T> iterator;
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.isEmpty()) {
                return null;
            }
            if (iterable instanceof List) {
                return (T)((List)iterable).get(0);
            }
        }
        return (iterator = iterable.iterator()).hasNext() ? (T)iterator.next() : null;
    }

    @Nullable
    public static <T> T last(@Nullable Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.isEmpty()) {
                return null;
            }
            if (iterable instanceof List) {
                List list = (List)iterable;
                return (T)list.get(list.size() - 1);
            }
        }
        T result = null;
        for (T element : iterable) {
            result = element;
        }
        return result;
    }

    @Nullable
    public static <T extends Comparable<? super T>> T min(@Nullable Iterable<? extends T> iterable) {
        return (T)((Comparable)CollectionUtils.min(iterable, ComparableComparator.getInstance()));
    }

    @Nullable
    public static <T> T min(@Nullable Iterable<? extends T> iterable, @NotNull Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.min must not be null");
        }
        Object result = null;
        if (iterable != null) {
            for (T value : iterable) {
                if (result != null && comparator.compare(value, result) >= 0) continue;
                result = value;
            }
        }
        return result;
    }

    @Nullable
    public static <T extends Comparable<? super T>> T max(@Nullable Iterable<? extends T> iterable) {
        return (T)((Comparable)CollectionUtils.max(iterable, ComparableComparator.getInstance()));
    }

    @Nullable
    public static <T> T max(@Nullable Iterable<? extends T> iterable, @NotNull Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.max must not be null");
        }
        Object result = null;
        if (iterable != null) {
            for (T value : iterable) {
                if (result != null && comparator.compare(value, result) <= 0) continue;
                result = value;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> select(@Nullable Iterable<T> input, @NotNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.select must not be null");
        }
        FilteredSequence<T> filteredSequence = input == null ? CollectionUtils.emptySequence() : new FilteredSequence<T>(input, predicate);
        if (filteredSequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.select must not return null");
        }
        return filteredSequence;
    }

    public static <T> boolean exists(@Nullable Iterable<T> input, @NotNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.exists must not be null");
        }
        return CollectionUtils.findFirst(input, predicate) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, U> Sequence<U> map(@Nullable Iterable<T> input, @NotNull Function<T, U> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.map must not be null");
        }
        MappedSequence<T, U> mappedSequence = input == null ? CollectionUtils.emptySequence() : new MappedSequence<T, U>(input, mapper);
        if (mappedSequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.map must not return null");
        }
        return mappedSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, D extends T> Sequence<T> flatten(@Nullable Iterable<? extends T> input, @NotNull Function<? super T, Iterator<D>> traversal) {
        if (traversal == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.flatten must not be null");
        }
        FlatteningSequence<? super T, D> flatteningSequence = input == null ? CollectionUtils.emptySequence() : new FlatteningSequence<T, D>(input, traversal);
        if (flatteningSequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.flatten must not return null");
        }
        return flatteningSequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Collection<T> selectLeftDiff(Collection<T> col1, Collection<T> col2, final Comparator<T> comparator) {
        Collection diff = CollectionFactory.createCollection();
        for (final T elem : col1) {
            Sequence<T> iterable = CollectionUtils.select(col2, new Predicate<T>(){

                @Override
                public boolean check(T value) {
                    return comparator.compare(elem, value) == 0;
                }
            });
            if (iterable.iterator().hasNext()) continue;
            diff.add(elem);
        }
        Collection collection = diff;
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.selectLeftDiff must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, V extends T> Iterable<V> selectInstanceOf(@Nullable Iterable<T> input, @NotNull Class<V> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.selectInstanceOf must not be null");
        }
        InstanceOfIterable<T, V> instanceOfIterable = input == null ? CollectionUtils.emptyIterable() : new InstanceOfIterable<T, V>(input, clazz);
        if (instanceOfIterable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.selectInstanceOf must not return null");
        }
        return instanceOfIterable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T, V extends T> Sequence<V> selectInstanceOf(@Nullable Sequence<T> input, final @NotNull Class<V> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.selectInstanceOf must not be null");
        }
        Function cast = new Function<T, V>(){

            @Override
            public V eval(T value) {
                return clazz.cast(value);
            }
        };
        Sequence<Object> sequence = input == null ? CollectionUtils.emptySequence() : input.select(PredicateUtils.instanceOf(clazz)).map(cast);
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.selectInstanceOf must not return null");
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> selectNotNull(@Nullable Collection<T> inputCollection) {
        Sequence<T> sequence = CollectionUtils.select(inputCollection, PredicateUtils.notNull());
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.selectNotNull must not return null");
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Collection<T> createFilteredCollection(@Nullable Iterable<T> inputIterable, @Nullable Predicate<T> predicate) {
        Collection answer = CollectionFactory.createCollection();
        CollectionUtils.selectInto(inputIterable, predicate, answer);
        Collection collection = answer;
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.createFilteredCollection must not return null");
        }
        return collection;
    }

    public static <T> void selectInto(@Nullable Iterable<T> inputIterable, @Nullable Predicate<T> predicate, @NotNull Collection<T> outputCollection) {
        if (outputCollection == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.selectInto must not be null");
        }
        if (inputIterable != null && predicate != null) {
            for (T item : inputIterable) {
                if (!predicate.check(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    @Nullable
    public static <T> T findFirst(@Nullable Iterable<T> iterable, @Nullable Predicate<T> predicate) {
        if (iterable != null && predicate != null) {
            for (T item : iterable) {
                if (!predicate.check(item)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> sort(@NotNull Collection<T> collection, @NotNull Comparator<? super T> comparator) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.sort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.sort must not be null");
        }
        ArrayList<T> result = new ArrayList<T>(collection);
        Collections.sort(result, comparator);
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.sort must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> sort(@NotNull Sequence<T> sequence, @NotNull Comparator<? super T> comparator) {
        if (sequence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.sort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.sort must not be null");
        }
        ArrayList result = new ArrayList();
        sequence.addAllTo(result);
        Collections.sort(result, comparator);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.sort must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Collection<T> concat(Collection<T> ... collections) {
        SequenceBuilder<T> builder = SequenceBuilder.create();
        for (Collection<T> iterable : collections) {
            if (iterable == null) continue;
            builder.append((Iterable<T>)iterable);
        }
        Collection collection = builder.toCollection();
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.concat must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Collection<T> concat(@NotNull Collection<T> c1, @NotNull Collection<T> c2) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.concat must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.concat must not be null");
        }
        Collection<T> collection = SequenceBuilder.create(c1).append((Iterable<T>)c2).toCollection();
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.concat must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> concat(Iterable<? extends T> ... iterables) {
        SequenceBuilder<? extends T> builder = SequenceBuilder.create();
        for (Iterable<? extends T> iterable : iterables) {
            if (iterable == null) continue;
            builder.append(iterable);
        }
        Sequence sequence = builder.build();
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.concat must not return null");
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Sequence<T> concat(@NotNull Iterable<? extends T> c1, @NotNull Iterable<? extends T> c2) {
        if (c1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.concat must not be null");
        }
        if (c2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.concat must not be null");
        }
        Sequence<? extends T> sequence = SequenceBuilder.create(c1).append(c2).build();
        if (sequence == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.concat must not return null");
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Enumeration<T> asEnumeration(final @NotNull Iterator<T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.asEnumeration must not be null");
        }
        Enumeration enumeration = new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
        if (enumeration == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asEnumeration must not return null");
        }
        return enumeration;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> Iterable<T> filtered(final Iterable<? extends T> iterable, final Predicate<? super T> predicate) {
        Iterable iterable2 = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = iterable.iterator();
                return new AbstractIterator<T>(){

                    @Override
                    protected boolean advance() {
                        Iterator itr = iterator;
                        while (itr.hasNext()) {
                            Object e = itr.next();
                            if (!predicate.check(e)) continue;
                            this.next = e;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
        if (iterable2 == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.filtered must not return null");
        }
        return iterable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Sequence<E> take(final @NotNull Iterable<E> iterable, final int howMany) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.take must not be null");
        }
        Sequence.Default default_ = new Sequence.Default<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<E>(){
                    int count;

                    @Override
                    public boolean hasNext() {
                        return it.hasNext() && this.count < howMany;
                    }

                    @Override
                    public E next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.count;
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }
        };
        if (default_ == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.take must not return null");
        }
        return default_;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> String toSeparatedString(@NotNull Iterable<E> collection, @NotNull String separator) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toSeparatedString must not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toSeparatedString must not be null");
        }
        StringBuilder builder = new StringBuilder();
        for (E element : collection) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            if (element == null) continue;
            builder.append(element.toString());
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.toSeparatedString must not return null");
        }
        return string;
    }

    public static int size(@NotNull Iterable<?> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.size must not be null");
        }
        if (iterable instanceof SequenceAdaptor) {
            return ((SequenceAdaptor)iterable).c.size();
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int result = 0;
        for (Object anIterable : iterable) {
            ++result;
        }
        return result;
    }

    public static boolean contains(@NotNull Iterable<?> iterable, Object element) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.contains must not be null");
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).contains(element);
        }
        for (Object e : iterable) {
            if (e != element && (e == null || !e.equals(element))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> T[] toArray(@NotNull Iterable<? extends T> iterable, @NotNull T[] array) {
        ArrayList<T> c;
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toArray must not be null");
        }
        if (array == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toArray must not be null");
        }
        if (iterable instanceof Collection) {
            c = (ArrayList<T>)iterable;
        } else {
            c = new ArrayList<T>();
            for (T e : iterable) {
                c.add(e);
            }
        }
        T[] TArray = c.toArray(array);
        if (TArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.toArray must not return null");
        }
        return TArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> Map<K, V> hashMap(int capacity) {
        if (capacity > 0) {
            capacity = (int)((double)capacity / 0.75 + 0.75);
        }
        HashMap hashMap = new HashMap(capacity);
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.hashMap must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Object[] toArray(@NotNull Iterable<?> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toArray must not be null");
        }
        Object[] objectArray = CollectionUtils.toArray(iterable, new Object[0]);
        if (objectArray == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.toArray must not return null");
        }
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Sequence<E> asSequence(@NotNull Collection<? extends E> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.asSequence must not be null");
        }
        SequenceAdaptor<? extends E> sequenceAdaptor = new SequenceAdaptor<E>(collection);
        if (sequenceAdaptor == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asSequence must not return null");
        }
        return sequenceAdaptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Sequence<E> asSequence(E ... array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.asSequence must not be null");
        }
        SequenceAdaptor<E> sequenceAdaptor = new SequenceAdaptor<E>(Arrays.asList(array));
        if (sequenceAdaptor == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asSequence must not return null");
        }
        return sequenceAdaptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> Sequence<E> asSequence(@NotNull Iterable<? extends E> iterable) {
        Sequence.Default default_;
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.asSequence must not be null");
        }
        final Iterable eIterable = (Iterable)Cast.force(iterable);
        if (iterable instanceof Sequence) {
            default_ = (Sequence.Default)eIterable;
            if (default_ == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asSequence must not return null");
            return default_;
        }
        if (iterable instanceof Collection) {
            default_ = CollectionUtils.asSequence((Collection)eIterable);
            if (default_ == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asSequence must not return null");
            return default_;
        }
        default_ = new Sequence.Default<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return eIterable.iterator();
            }
        };
        if (default_ != null) return default_;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.asSequence must not return null");
    }

    public static <E> boolean equals(@NotNull Iterable<? extends E> it1, @NotNull Iterable<? extends E> it2) {
        if (it1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.equals must not be null");
        }
        if (it2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.equals must not be null");
        }
        if (it2 == it1) {
            return true;
        }
        Iterator<E> e1 = it1.iterator();
        Iterator<E> e2 = it2.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            E o1 = e1.next();
            E o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public static int hashCode(@NotNull Iterable<?> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.hashCode must not be null");
        }
        int hashCode = 1;
        for (Object obj : iterable) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public static Sequence<Node> asSequence(final @NotNull NodeList nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.asSequence must not be null");
        }
        return new Sequence.Default<Node>(){

            @Override
            @NotNull
            public Iterator<Node> iterator() {
                return new NoRemoveIterator<Node>(){
                    int next = 0;

                    @Override
                    public boolean hasNext() {
                        return this.next < nodes.getLength();
                    }

                    @Override
                    public Node next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return nodes.item(this.next++);
                    }
                };
            }
        };
    }

    public static <E> List<E> immutableList(@Nullable Collection<? extends E> elements) {
        if (elements == null || elements instanceof ImmutableList) {
            return (List)Cast.force(elements);
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return new ImmutableList<E>(elements);
    }

    public static <E> Set<E> immutableSet(@Nullable Collection<? extends E> elements) {
        if (elements == null || elements instanceof ImmutableSet) {
            return (Set)Cast.force(elements);
        }
        if (elements.isEmpty()) {
            return Collections.emptySet();
        }
        return new ImmutableSet<E>(elements);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <E> List<E> toList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils.toList must not be null");
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E element : iterable) {
            list.add(element);
        }
        ArrayList<E> arrayList = list;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils.toList must not return null");
        }
        return arrayList;
    }

    private static class UnmodifiableIterator<E>
    implements Iterator<E> {
        @NotNull
        private final Iterator<? extends E> delegate;

        private UnmodifiableIterator(@NotNull Iterator<? extends E> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$UnmodifiableIterator.<init> must not be null");
            }
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableBiMap<K, V>
    implements BiMap<K, V> {
        private final BiMap<? extends K, ? extends V> bm;
        @Nullable
        private BiMap<V, K> unmodifiableInverse;
        @Nullable
        private Map<K, V> unmodifiableMap;

        UnmodifiableBiMap(BiMap<? extends K, ? extends V> bm) {
            this.bm = bm;
        }

        private UnmodifiableBiMap(UnmodifiableBiMap<V, K> unmodifiableInverse) {
            this.bm = unmodifiableInverse.bm.inverse();
            this.unmodifiableInverse = unmodifiableInverse;
        }

        @Override
        public int hashCode() {
            return this.bm.hashCode();
        }

        public String toString() {
            return this.bm.toString();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || this.bm.equals(obj);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public BiMap<V, K> inverse() {
            BiMap<K, V> result = this.unmodifiableInverse;
            if (result == null) {
                this.unmodifiableInverse = result = new UnmodifiableBiMap<K, V>(this);
            }
            BiMap<K, V> biMap = result;
            if (biMap == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$UnmodifiableBiMap.inverse must not return null");
            }
            return biMap;
        }

        @Override
        public V forcePut(@Nullable K key, @Nullable V value) {
            throw UnmodifiableBiMap.unsupported();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Set<V> values() {
            Set set = this.inverse().keySet();
            if (set == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$UnmodifiableBiMap.values must not return null");
            }
            return set;
        }

        @Override
        public int size() {
            return this.bm.size();
        }

        @Override
        public boolean isEmpty() {
            return this.bm.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.bm.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.bm.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.bm.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw UnmodifiableBiMap.unsupported();
        }

        @Override
        public V remove(Object key) {
            throw UnmodifiableBiMap.unsupported();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw UnmodifiableBiMap.unsupported();
        }

        @Override
        public void clear() {
            throw UnmodifiableBiMap.unsupported();
        }

        @Override
        public Set<K> keySet() {
            return this.getUnmodifiableMap().keySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.getUnmodifiableMap().entrySet();
        }

        private static UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        private Map<K, V> getUnmodifiableMap() {
            void var1_3;
            Map<K, V> map = this.unmodifiableMap;
            if (map == null) {
                Map<? extends K, ? extends V> map2 = Collections.unmodifiableMap(this.bm);
                this.unmodifiableMap = map2;
            }
            void v0 = var1_3;
            if (v0 == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$UnmodifiableBiMap.getUnmodifiableMap must not return null");
            }
            return v0;
        }
    }

    private static final class UnduplicateSequence<E>
    extends Sequence.Default<E> {
        @NotNull
        private final Iterable<? extends E> iterable;

        UnduplicateSequence(@NotNull Iterable<? extends E> iterable) {
            if (iterable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$UnduplicateSequence.<init> must not be null");
            }
            this.iterable = iterable;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<E> iterator() {
            UnduplicateIterator<? extends E> unduplicateIterator = new UnduplicateIterator<E>(this.iterable.iterator());
            if (unduplicateIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$UnduplicateSequence.iterator must not return null");
            }
            return unduplicateIterator;
        }
    }

    private static final class SingletonSequence<E>
    extends Sequence.Default<E>
    implements Serializable {
        private final E value;
        private static final long serialVersionUID = -6340519220769465841L;

        private SingletonSequence(E value) {
            this.value = value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<E> iterator() {
            SingleValueIterator<E> singleValueIterator = SingleValueIterator.create(this.value);
            if (singleValueIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SingletonSequence.iterator must not return null");
            }
            return singleValueIterator;
        }
    }

    private static final class SequenceAdaptor<E>
    implements Sequence<E> {
        @NotNull
        private final Collection<? extends E> c;

        SequenceAdaptor(@NotNull Collection<? extends E> c) {
            if (c == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.<init> must not be null");
            }
            this.c = c;
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <V extends E> Sequence<V> selectInstanceOf(@NotNull Class<V> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.selectInstanceOf must not be null");
            }
            Sequence<V> sequence = CollectionUtils.selectInstanceOf(this, clazz);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.selectInstanceOf must not return null");
            }
            return sequence;
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Object[] toArray() {
            Object[] objectArray = this.c.toArray();
            if (objectArray == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.toArray must not return null");
            }
            return objectArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.toArray must not be null");
            }
            T[] TArray = this.c.toArray(a);
            if (TArray == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.toArray must not return null");
            }
            return TArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Sequence<E> select(@NotNull Predicate<E> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.select must not be null");
            }
            Sequence<E> sequence = CollectionUtils.select(this, predicate);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.select must not return null");
            }
            return sequence;
        }

        @Override
        public boolean exists(@NotNull Predicate<E> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.exists must not be null");
            }
            return CollectionUtils.exists(this, predicate);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <D extends E> Sequence<E> flatten(@NotNull Function<? super E, Iterator<D>> traversal) {
            if (traversal == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.flatten must not be null");
            }
            Sequence<? super E> sequence = CollectionUtils.flatten(this, traversal);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.flatten must not return null");
            }
            return sequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public <U> Sequence<U> map(@NotNull Function<E, U> mapper) {
            if (mapper == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.map must not be null");
            }
            Sequence<U> sequence = CollectionUtils.map(this, mapper);
            if (sequence == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.map must not return null");
            }
            return sequence;
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public boolean addAllTo(@NotNull Collection<? super E> col) {
            if (col == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$SequenceAdaptor.addAllTo must not be null");
            }
            return col.addAll(this.c);
        }

        public boolean equals(Object o) {
            return o instanceof Sequence && CollectionUtils.equals(this, (Sequence)o);
        }

        public int hashCode() {
            return CollectionUtils.hashCode(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<E> iterator() {
            UnmodifiableIterator unmodifiableIterator = new UnmodifiableIterator(this.c.iterator());
            if (unmodifiableIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$SequenceAdaptor.iterator must not return null");
            }
            return unmodifiableIterator;
        }
    }

    private static final class MappedSequence<T, U>
    extends Sequence.Default<U> {
        private final Iterable<T> input;
        private final Function<T, U> mapper;

        MappedSequence(Iterable<T> input, Function<T, U> mapper) {
            this.input = input;
            this.mapper = mapper;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<U> iterator() {
            final Iterator<T> original = this.input.iterator();
            NoRemoveIterator noRemoveIterator = new NoRemoveIterator<U>(){

                @Override
                public boolean hasNext() {
                    return original.hasNext();
                }

                @Override
                public U next() {
                    return MappedSequence.this.mapper.eval(original.next());
                }
            };
            if (noRemoveIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$MappedSequence.iterator must not return null");
            }
            return noRemoveIterator;
        }
    }

    private static final class IterableFromEnumeration<T>
    implements Iterable<T> {
        @NotNull
        private final Enumeration<T> enumeration;

        IterableFromEnumeration(@NotNull Enumeration<T> e) {
            if (e == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$IterableFromEnumeration.<init> must not be null");
            }
            this.enumeration = e;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return IterableFromEnumeration.this.enumeration.hasMoreElements();
                }

                @Override
                public T next() {
                    return IterableFromEnumeration.this.enumeration.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class InstanceOfIterable<T, V extends T>
    implements Iterable<V> {
        @NotNull
        private final Class<V> clazz;
        @NotNull
        private final Iterable<T> input;

        InstanceOfIterable(@NotNull Iterable<T> input, @NotNull Class<V> clazz) {
            if (input == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$InstanceOfIterable.<init> must not be null");
            }
            if (clazz == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$InstanceOfIterable.<init> must not be null");
            }
            this.input = input;
            this.clazz = clazz;
        }

        @Override
        public Iterator<V> iterator() {
            return new InstanceOfFilterIterator<T, V>(this.input.iterator(), this.clazz);
        }
    }

    private static final class InstanceOfFilterIterator<T, V extends T>
    extends NoRemoveIterator<V> {
        @NotNull
        private final Class<V> clazz;
        @NotNull
        private final Iterator<T> iterator;

        InstanceOfFilterIterator(@NotNull Iterator<T> iterator, @NotNull Class<V> clazz) {
            if (iterator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$InstanceOfFilterIterator.<init> must not be null");
            }
            if (clazz == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/collections/CollectionUtils$InstanceOfFilterIterator.<init> must not be null");
            }
            this.iterator = new FilterIterator<T>(iterator, PredicateUtils.instanceOf(clazz));
            this.clazz = clazz;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.clazz.cast(this.iterator.next());
        }
    }

    private static final class ImmutableSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private final Set<E> delegate;
        private static final long serialVersionUID = 2260769660676902708L;

        ImmutableSet(Collection<? extends E> elements) {
            this.delegate = new LinkedHashSet<E>(elements);
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }
    }

    private static class ImmutableMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> delegate;

        ImmutableMap(Map<? extends K, ? extends V> map) {
            this.delegate = Collections.unmodifiableMap(new HashMap<K, V>(map));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public V get(Object key) {
            return this.delegate.get(key);
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.delegate.entrySet();
        }
    }

    private static final class ImmutableList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private final List<E> delegate;
        private static final long serialVersionUID = 1869262768521038996L;

        ImmutableList(Collection<? extends E> elements) {
            this.delegate = new ArrayList<E>(elements);
        }

        @Override
        public E get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }
    }

    private static class ImmutableBiMap<K, V>
    extends UnmodifiableBiMap<K, V> {
        ImmutableBiMap(BiMap<? extends K, ? extends V> bm) {
            super(new HashBiMap<K, V>(bm));
        }
    }

    private static class FlatteningSequence<T, D extends T>
    extends Sequence.Default<T> {
        private final Function<? super T, Iterator<D>> flattener;
        private final Iterable<? extends T> iterable;

        FlatteningSequence(Iterable<? extends T> iterable, Function<? super T, Iterator<D>> flattener) {
            this.flattener = flattener;
            this.iterable = iterable;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<T> iterator() {
            FlatteningIterator<? extends T, D> flatteningIterator = new FlatteningIterator<T, D>(this.flattener, this.iterable.iterator());
            if (flatteningIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$FlatteningSequence.iterator must not return null");
            }
            return flatteningIterator;
        }

        @Override
        public String toString() {
            return '[' + CollectionUtils.toSeparatedString(CollectionUtils.take(this, 10), ", ") + ']';
        }
    }

    private static class FlatteningIterator<T, D extends T>
    extends NoRemoveIterator<T> {
        private final Function<? super T, Iterator<D>> flattener;
        private boolean hasNext;
        private T next;
        private final Deque<Iterator<? extends T>> stack = new ArrayDeque<Iterator<? extends T>>();

        FlatteningIterator(Function<? super T, Iterator<D>> flattener, Iterator<? extends T> iterator) {
            this.flattener = flattener;
            this.stack.addFirst(iterator);
            this.hasNext = true;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.next;
            this.advance();
            return result;
        }

        private void advance() {
            while (!this.stack.isEmpty()) {
                if (this.stack.getFirst().hasNext()) {
                    this.next = this.stack.getFirst().next();
                    Iterator<D> it = this.flattener.eval(this.next);
                    if (it != null) {
                        this.stack.addFirst(it);
                    }
                    return;
                }
                this.stack.removeFirst();
            }
            this.hasNext = false;
        }
    }

    private static final class FilteredSequence<T>
    extends Sequence.Default<T> {
        private final Iterable<T> input;
        private final Predicate<T> predicate;

        FilteredSequence(Iterable<T> input, Predicate<T> predicate) {
            this.input = input;
            this.predicate = predicate;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator<T> iterator() {
            FilterIterator<T> filterIterator = new FilterIterator<T>(this.input.iterator(), this.predicate);
            if (filterIterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$FilteredSequence.iterator must not return null");
            }
            return filterIterator;
        }
    }

    private static final class EmptySortedSetHolder {
        static final SortedSet VALUE = Collections.unmodifiableSortedSet(new TreeSet());

        private EmptySortedSetHolder() {
        }
    }

    private static final class EmptySequence
    extends Sequence.Default
    implements Serializable {
        static final Sequence INSTANCE = new EmptySequence();
        private static final long serialVersionUID = 8304050378500744809L;

        private EmptySequence() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Iterator iterator() {
            Iterator iterator = EmptyIterator.INSTANCE;
            if (iterator == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$EmptySequence.iterator must not return null");
            }
            return iterator;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EmptyIterator
    implements Iterator,
    Serializable {
        static final Iterator INSTANCE = new EmptyIterator();
        private static final long serialVersionUID = 227911309491140242L;

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EmptyIterable
    implements Iterable,
    Serializable {
        static final Iterable INSTANCE = new EmptyIterable();
        private static final long serialVersionUID = -7963811798315174500L;

        private EmptyIterable() {
        }

        public Iterator iterator() {
            return EmptyIterator.INSTANCE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EmptyBiMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable,
    BiMap<K, V> {
        private static final long serialVersionUID = -37380417121418289L;
        static final BiMap INSTANCE = new EmptyBiMap();

        private EmptyBiMap() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Set<V> values() {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$EmptyBiMap.values must not return null");
            }
            return set;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public BiMap<V, K> inverse() {
            BiMap biMap = CollectionUtils.emptyBiMap();
            if (biMap == null) {
                throw new IllegalArgumentException("@NotNull method oracle/bpm/collections/CollectionUtils$EmptyBiMap.inverse must not return null");
            }
            return biMap;
        }

        @Override
        public V forcePut(@Nullable K key, @Nullable V value) {
            return this.put(key, value);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

