/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.organization.client.soap;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.services.organization.BPMOrganizationException;
import oracle.bpm.services.organization.IBPMOrganizationService;
import oracle.bpm.services.organization.client.soap.OrganizationServicePortType;
import oracle.bpm.services.organization.client.soap.WorkflowErrorMessage;
import oracle.bpm.services.organization.common.BPMContextType;
import oracle.bpm.services.organization.common.CredentialType;
import oracle.bpm.services.organization.model.ApplicationContext;
import oracle.bpm.services.organization.model.ApplicationRoleOrgUnitCalendarAssociation;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.ChildOrganizationalUnitRetrievalModeTypeEnum;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.LogicalPeopleGroup;
import oracle.bpm.services.organization.model.ObjectFactory;
import oracle.bpm.services.organization.model.Organization;
import oracle.bpm.services.organization.model.OrganizationEntitySearchContext;
import oracle.bpm.services.organization.model.OrganizationEntityTypeEnum;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.bpm.services.organization.model.Participant;
import oracle.bpm.services.organization.model.ParticipantProperties;
import oracle.bpm.services.organization.model.ParticipantProperty;
import oracle.bpm.services.organization.model.PeopleQuery;
import oracle.bpm.services.organization.model.PeopleQueryContext;
import oracle.bpm.services.organization.model.PeopleQueryContextType;
import oracle.bpm.services.organization.model.PeopleQueryType;
import oracle.bpm.services.organization.model.Permission;
import oracle.bpm.services.organization.model.Predicate;
import oracle.bpm.services.organization.model.PredicateType;
import oracle.bpm.services.organization.model.PrincipleRefType;
import oracle.bpm.services.organization.model.RoleProfile;
import oracle.bpm.services.organization.model.RoleProfileType;
import oracle.bpm.services.organization.model.SearchModeTypeEnum;

public class OrganizationWebServiceClient
implements IBPMOrganizationService {
    private oracle.bpm.services.organization.common.ObjectFactory comObjectFactory;
    private ObjectFactory orgObjectFactory;
    private OrganizationServicePortType port;

    public OrganizationWebServiceClient(OrganizationServicePortType p) {
        this.port = p;
        this.orgObjectFactory = new ObjectFactory();
        this.comObjectFactory = new oracle.bpm.services.organization.common.ObjectFactory();
    }

    @Override
    public void createParticipantProperty(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.createParticipantProperty(bpmContext, property);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void addParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.addParticipantPropertyValue(bpmContext, property);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void createAppRole(IBPMContext wctx, ApplicationContext appCtx, String appRoleName, String optionalDisplayName, String optionalDesc) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.createAppRole(bpmContext, appCtx, appRoleName, optionalDisplayName, optionalDesc);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public ApplicationRoleOrgUnitCalendarAssociation createApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)applicationRoleOrgUnitCalendarAssociation);
            this.port.createApplicationRoleOrgUnitCalendarAssociation(bpmContext, (Holder<ApplicationRoleOrgUnitCalendarAssociation>)holder);
            return (ApplicationRoleOrgUnitCalendarAssociation)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public CalendarRule createCalendarRule(IBPMContext ctx, CalendarRule cal) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)cal);
            this.port.createCalendarRule(bpmContext, (Holder<CalendarRule>)holder);
            return (CalendarRule)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public HolidayRule createHolidayRule(IBPMContext ctx, HolidayRule holidayRule) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)holidayRule);
            this.port.createHolidayRule(bpmContext, (Holder<HolidayRule>)holder);
            return (HolidayRule)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public OrganizationalUnit createOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)organizationalUnit);
            this.port.createOrganizationalUnit(bpmContext, (Holder<OrganizationalUnit>)holder);
            return (OrganizationalUnit)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteAllPropertiesOnParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            ArrayList<PrincipleRefType> prtList = new ArrayList<PrincipleRefType>();
            for (Participant p : participants) {
                prtList.add((PrincipleRefType)p.getValue());
            }
            this.port.deleteAllPropertiesOnParticipants(bpmContext, prtList);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, String applicationRoleOrgUnitCalendarAssociationId) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteApplicationRoleOrgUnitCalendarAssociation(bpmContext, applicationRoleOrgUnitCalendarAssociationId);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteCalendarRule(IBPMContext ctx, String calendarID, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteCalendarRule(bpmContext, calendarID, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteHolidayRule(IBPMContext ctx, String holidayRuleId, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteHolidayRule(bpmContext, holidayRuleId, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, boolean includingChildren, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteOrganizationalUnit(bpmContext, organizationalUnitId, includingChildren, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteParticipantProperty(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteParticipantProperty(bpmContext, property, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void deleteParticipantPropertyValue(IBPMContext ctx, ParticipantProperty property, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.deleteParticipantPropertyValue(bpmContext, property, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public LogicalPeopleGroup createLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        return new LogicalPeopleGroup();
    }

    @Override
    public LogicalPeopleGroup updateLogicalPeopleGroup(IBPMContext ctx, LogicalPeopleGroup lpg, boolean isExecuteImmediate) throws BPMOrganizationException {
        return new LogicalPeopleGroup();
    }

    @Override
    public void deleteLogicalPeopleGroup(IBPMContext ctx, String lpgId, boolean force) throws BPMOrganizationException {
    }

    @Override
    public LogicalPeopleGroup getLogicalPeopleGroup(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        return new LogicalPeopleGroup();
    }

    @Override
    public List<LogicalPeopleGroup> getLogicalPeopleGroupsForUser(IBPMContext ctx, PrincipleRefType user) throws BPMOrganizationException {
        return new ArrayList<LogicalPeopleGroup>();
    }

    @Override
    public List<LogicalPeopleGroup> searchLogicalPeopleGroups(IBPMContext ctx, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        return new ArrayList<LogicalPeopleGroup>();
    }

    @Override
    public List<Participant> getLogicalPeopleGroupMembers(IBPMContext ctx, String lpgId) throws BPMOrganizationException {
        return new ArrayList<Participant>();
    }

    @Override
    public List<Participant> executePeopleQuery(IBPMContext ctx, PeopleQuery peopleQuery, PeopleQueryContext peopleQueryCtx) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            List<PrincipleRefType> prtList = this.port.executePeopleQuery(bpmContext, (PeopleQueryType)peopleQuery.getValue(), (PeopleQueryContextType)peopleQueryCtx.getValue());
            ArrayList<Participant> partList = new ArrayList<Participant>();
            for (PrincipleRefType prt : prtList) {
                Participant part = this.orgObjectFactory.createParticipant(prt);
                partList.add(part);
            }
            return partList;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public Organization exportOrganization(IBPMContext ctx) throws BPMOrganizationException {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This operation not supported via SOAP over HTTP. Use the remote EJB interface.");
        throw new BPMOrganizationException(uoe);
    }

    @Override
    public List<ParticipantProperties> getAllAssignedParticipantProperties(IBPMContext ctx) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getAllAssignedParticipantProperties(bpmContext);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<ApplicationRoleOrgUnitCalendarAssociation> getApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, RoleProfile applicationRole) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getApplicationRoleOrgUnitCalendarAssociation(bpmContext, (RoleProfileType)applicationRole.getValue());
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public CalendarRule getCalendarRule(IBPMContext ctx, String organizationalUnitId) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getCalendarRule(bpmContext, organizationalUnitId);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public CalendarRule getCalendarRuleForRole(IBPMContext ctx, String organizationalUnitId, RoleProfile applicationRole) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getCalendarRuleForRole(bpmContext, organizationalUnitId, (RoleProfileType)applicationRole.getValue());
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public HolidayRule getHolidayRule(IBPMContext ctx, String holidayRuleId) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getHolidayRule(bpmContext, holidayRuleId);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit(IBPMContext ctx, String organizationalUnitId, ChildOrganizationalUnitRetrievalModeTypeEnum childOrganizationalUnitRetrievalMode) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.getOrganizationalUnit(bpmContext, organizationalUnitId, childOrganizationalUnitRetrievalMode);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<Participant> getParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, List<ParticipantProperty> props, int startRow, int endRow) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            List<PrincipleRefType> prtList = new ArrayList<PrincipleRefType>();
            for (Participant part : setOfParticipants) {
                prtList.add((PrincipleRefType)part.getValue());
            }
            prtList = this.port.getParticipantsWithProperties(bpmContext, prtList, props, startRow, endRow);
            ArrayList<Participant> result = new ArrayList<Participant>();
            for (PrincipleRefType prt : prtList) {
                Participant part = this.orgObjectFactory.createParticipant(prt);
                result.add(part);
            }
            return result;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<ParticipantProperties> getPropertiesOfParticipants(IBPMContext ctx, List<Participant> participants) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            ArrayList<PrincipleRefType> prtList = new ArrayList<PrincipleRefType>();
            for (Participant part : participants) {
                prtList.add((PrincipleRefType)part.getValue());
            }
            return this.port.getPropertiesOfParticipants(bpmContext, prtList);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void grantAppRoleToPrincipal(IBPMContext wctx, ApplicationContext appCtx, String approleName, Participant participant) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.grantAppRoleToPrincipal(bpmContext, appCtx, approleName, (PrincipleRefType)participant.getValue());
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void grantPermissionToAppRole(IBPMContext wctx, ApplicationContext appCtx, String approleName, Permission perm) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.grantPermissionToAppRole(bpmContext, appCtx, approleName, perm);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public Organization importOrganization(IBPMContext ctx, Organization organization, boolean validateUsers) throws BPMOrganizationException {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This operation not supported via SOAP over HTTP. Use the remote EJB interface.");
        throw new BPMOrganizationException(uoe);
    }

    @Override
    public void removeAppRole(IBPMContext wctx, ApplicationContext appCtx, String appRoleName, boolean force) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.removeAppRole(bpmContext, appCtx, appRoleName, force);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void revokeAppRoleFromPrincipal(IBPMContext wctx, ApplicationContext appCtx, String approleName, Participant participant) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.revokeAppRoleFromPrincipal(bpmContext, appCtx, approleName, (PrincipleRefType)participant.getValue());
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void revokePermissionFromAppRole(IBPMContext wctx, ApplicationContext appCtx, String approleName, Permission perm) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(wctx);
            this.port.revokePermissionFromAppRole(bpmContext, appCtx, approleName, perm);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<OrganizationalUnit> searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow, OrganizationEntitySearchContext organizationEntitySearchContext) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.searchOrganizationEntity(bpmContext, organizationEntity, searchMode, searchCriteria, startRow, endRow, organizationEntitySearchContext);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<OrganizationalUnit> searchOrganizationEntity(IBPMContext ctx, OrganizationEntityTypeEnum organizationEntity, SearchModeTypeEnum searchMode, String searchCriteria, int startRow, int endRow) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.searchOrganizationEntity(bpmContext, organizationEntity, searchMode, searchCriteria, startRow, endRow, null);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<Participant> searchParticipantsWithProperties(IBPMContext ctx, List<Participant> setOfParticipants, Predicate predicate, int startRow, int endRow) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            List<PrincipleRefType> prtList = new ArrayList<PrincipleRefType>();
            for (Participant part : setOfParticipants) {
                prtList.add((PrincipleRefType)part.getValue());
            }
            prtList = this.port.searchParticipantsWithProperties(bpmContext, prtList, (PredicateType)predicate.getValue(), startRow, endRow);
            ArrayList<Participant> result = new ArrayList<Participant>();
            for (PrincipleRefType prt : prtList) {
                Participant part = this.orgObjectFactory.createParticipant(prt);
                result.add(part);
            }
            return result;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void setPropertiesOnParticipants(IBPMContext ctx, List<ParticipantProperties> properties) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.setPropertiesOnParticipants(bpmContext, properties);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public ApplicationRoleOrgUnitCalendarAssociation updateApplicationRoleOrgUnitCalendarAssociation(IBPMContext ctx, ApplicationRoleOrgUnitCalendarAssociation applicationRoleOrgUnitCalendarAssociation) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder();
            holder.value = applicationRoleOrgUnitCalendarAssociation;
            this.port.updateApplicationRoleOrgUnitCalendarAssociation(bpmContext, (Holder<ApplicationRoleOrgUnitCalendarAssociation>)holder);
            return (ApplicationRoleOrgUnitCalendarAssociation)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public CalendarRule updateCalendarRule(IBPMContext ctx, CalendarRule updatedCalendar) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)updatedCalendar);
            this.port.updateCalendarRule(bpmContext, (Holder<CalendarRule>)holder);
            return (CalendarRule)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public HolidayRule updateHolidayRule(IBPMContext ctx, HolidayRule updatedHolidayRule) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder((Object)updatedHolidayRule);
            this.port.updateHolidayRule(bpmContext, (Holder<HolidayRule>)holder);
            return (HolidayRule)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public OrganizationalUnit updateOrganizationalUnit(IBPMContext ctx, OrganizationalUnit organizationalUnit) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            Holder holder = new Holder();
            holder.value = organizationalUnit;
            this.port.updateOrganizationalUnit(bpmContext, (Holder<OrganizationalUnit>)holder);
            return (OrganizationalUnit)holder.value;
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void updateParticipantPropertyName(IBPMContext ctx, String oldName, String newname) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.updateParticipantPropertyName(bpmContext, oldName, newname);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public void updateParticipantPropertyValue(IBPMContext ctx, String propertyName, String oldValue, String newValue) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            this.port.updateParticipantPropertyValue(bpmContext, propertyName, oldValue, newValue);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<ParticipantProperty> searchExtendedUserProperties(IBPMContext ctx, String propertyName) throws BPMOrganizationException {
        try {
            BPMContextType bpmContext = this.createBPMContextTypeFrom(ctx);
            return this.port.searchExtendedUserProperties(bpmContext, propertyName);
        }
        catch (WorkflowErrorMessage e) {
            e.printStackTrace();
            throw new BPMOrganizationException(e);
        }
    }

    @Override
    public List<OrganizationalUnit> getOrganizationalUnitForUser(IBPMContext ctx, String userId, String identityContext, boolean direct) throws BPMOrganizationException {
        return null;
    }

    protected BPMContextType createBPMContextTypeFrom(IBPMContext ctx) {
        BPMContextType bpmCtxt = this.comObjectFactory.createBPMContextType();
        CredentialType credType = bpmCtxt.getCredential();
        credType.setIdentityContext(ctx.getIdentityContext());
        credType.setLogin(ctx.getUser());
        bpmCtxt.setCredential(credType);
        bpmCtxt.setToken(ctx.getToken());
        bpmCtxt.setLocale(ctx.getLocale().toString());
        bpmCtxt.setTimeZone(ctx.getTimeZone().toString());
        return bpmCtxt;
    }
}

