/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.client.internal.processmodel;

import java.io.UnsupportedEncodingException;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpm.client.internal.processmodel.marshalling.ProcessModelLoader;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.internal.processmodel.ejb.IProcessModelServiceRemote;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessMarshallingException;

public class ProcessModelServiceRemoteClient
implements IProcessModelService {
    private IProcessModelServiceRemote stub;

    public ProcessModelServiceRemoteClient(IProcessModelServiceRemote stub) {
        this.stub = stub;
    }

    @Override
    public IProcessModelPackage getProcessModel(IBPMContext context, String compositeDN, String processName) throws BPMException {
        try {
            byte[] modelXMLBytes = this.getStub().getProcessModelXML(context, compositeDN, processName);
            String modelXML = new String(modelXMLBytes, "UTF-8");
            return ProcessModelLoader.create().unmarshall(modelXML);
        }
        catch (UnsupportedEncodingException e) {
            throw new BPMException(71201, null, e);
        }
        catch (ProcessMarshallingException e) {
            throw new BPMException(71201, null, e);
        }
    }

    private IProcessModelServiceRemote getStub() {
        return this.stub;
    }
}

