/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.MaskUtilities;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOTextFieldComponentDelegate {
    private XOTextFieldComponent component;
    private XFormText xText;
    private static final String DEFAULT_MASK_ERROR_COLOR = "#FF0000";
    private static final String DEFAULT_PATTERN_ERROR_COLOR = "#FF0000";

    public XOTextFieldComponentDelegate(XOTextFieldComponent component) {
        this.component = component;
        this.xText = (XFormText)this.component.getPresentationXMLObject();
        this.init();
    }

    public String getInputPattern() {
        return this.xText.inputpattern;
    }

    public String getInputPatternErrorColor() {
        if (this.hasInputPattern()) {
            String msg = this.xText.inputpatternerrorcolor;
            return msg != null && !msg.trim().equals("") ? msg : this.getDefaultPatternErrorColor();
        }
        return null;
    }

    public String getInputPatternErrorMsg() {
        if (this.hasInputPattern()) {
            String msg = this.xText.inputpatternerrormessage;
            msg = msg != null && !msg.trim().equals("") ? this.component.getI18NText(msg) : this.getDefaultPatternErrorMsg();
            return msg;
        }
        return null;
    }

    public String getMask() {
        return this.xText.mask;
    }

    public String getMaskErrorColor() {
        if (this.hasMask()) {
            String msg = this.xText.maskerrorcolor;
            return msg != null && !msg.trim().equals("") ? msg : this.getDefaultMaskErrorColor();
        }
        return null;
    }

    public String getMaskErrorMsg() {
        if (this.hasMask()) {
            String msg = this.xText.maskerrormessage;
            msg = msg != null && !msg.trim().equals("") ? this.component.getI18NText(msg) : this.getDefaultMaskErrorMsg();
            return msg;
        }
        return null;
    }

    public String getNonEditableText(Locale locale, String valueStr, int kind) {
        if (this.hasOutputMask()) {
            try {
                switch (this.getOutputMaskType()) {
                    case 0: {
                        return MaskUtilities.applyGenericOutputMask(locale, this.getOutputMask(), valueStr, kind);
                    }
                    case 1: {
                        return MaskUtilities.applyNumericOutputMask(locale, this.getOutputMask(), valueStr, kind);
                    }
                }
                return valueStr;
            }
            catch (Throwable e) {
                Log.logDebug(e);
                Log.logWarning(XObjectRuntimeMsg.MASK_OUTPUT_ERROR(this.component.getId(), this.component.getXScreen().getRuntimeManager().getPresentationName(), e.getMessage()));
                return valueStr;
            }
        }
        return valueStr;
    }

    public String getOutputMask() {
        return this.xText.outputmask;
    }

    public int getOutputMaskType() {
        return this.xText.outputmasktype;
    }

    public String applyMask(String mask, String value) {
        if (value == null || value.trim().equals("")) {
            return value;
        }
        return MaskUtilities.applyMask(mask, value);
    }

    public String convertToString(Object value) {
        return ConversionUtilities.convertToString(value);
    }

    public boolean hasInputPattern() {
        return this.xText.inputpattern != null && !this.xText.inputpattern.trim().equals("");
    }

    public boolean hasMask() {
        return this.xText.mask != null && !this.xText.mask.trim().equals("");
    }

    public boolean hasOutputMask() {
        String outputMask = this.getOutputMask();
        return outputMask != null && outputMask.trim().length() > 0;
    }

    private String getDefaultMaskErrorColor() {
        return "#FF0000";
    }

    private String getDefaultMaskErrorMsg() {
        return XObjectRuntimeMsg.INVALID_INPUT_BY_MASK(this.getMask()).toString();
    }

    private String getDefaultPatternErrorColor() {
        return "#FF0000";
    }

    private String getDefaultPatternErrorMsg() {
        return XObjectRuntimeMsg.INVALID_INPUT_BY_PATTERN(this.getInputPattern()).toString();
    }

    private void init() {
        this.component.addValueChangeListener(this.component.getXScreen().getRuntimeManager());
    }
}

