/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.log.Log;
import oracle.bpm.util.CILUtils;
import oracle.bpm.xobject.GroupArray;
import oracle.bpm.xobject.GroupArrayChangeListener;
import oracle.bpm.xobject.presentationmodel.XFormRepeatable;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.presentationComponents.XOElementComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOGroupComponentDelegate
implements GroupArrayChangeListener {
    private final Map<String, XOPresentationComponent> columnElementMap;
    private XOGroupComponent component;
    private final Map<String, String> dataPresentationMap;
    private DynamicGroupProperties dynamicGroupProperties = null;
    private Map<String, String> presentationDataMap = null;
    private SortEvent sortEvent = null;

    public XOGroupComponentDelegate(XOGroupComponent component) {
        this.component = component;
        this.presentationDataMap = new LinkedHashMap<String, String>(0);
        this.dataPresentationMap = new LinkedHashMap<String, String>(0);
        this.columnElementMap = new LinkedHashMap<String, XOPresentationComponent>(0);
        this.dynamicGroupProperties = new DynamicGroupProperties();
        this.init();
    }

    public void setBgColorProperty(int index, String colPresId, String color) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setBgColorProperty(index, colPresId, color);
        }
    }

    public String getBgColorProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getBgColorProperty(index, colPresId, columnElementByPresId.getBackgroundColor());
        }
        return null;
    }

    public Iterator<XOPresentationComponent> getColumnComponents() {
        return this.columnElementMap.values().iterator();
    }

    public String[] getColumnDataIds() {
        Set<String> keys = this.dataPresentationMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public XOPresentationComponent getColumnElementByDataId(String dataId) {
        return this.columnElementMap.get(this.dataPresentationMap.get(dataId));
    }

    public XOElementComponent getColumnElementByPresId(String presId) {
        return (XOElementComponent)this.columnElementMap.get(presId);
    }

    public String[] getColumnPresentationIds() {
        Set<String> keys = this.columnElementMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public String getDataIdtWithPressId(String pressId) {
        return this.presentationDataMap.get(pressId);
    }

    public Object getDefaultValue() {
        return null;
    }

    public void setEditableProperty(int index, String colPresId, boolean isEditable) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setEditableProperty(index, colPresId, isEditable);
        }
    }

    public boolean getEditableProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getEditableProperty(index, colPresId, columnElementByPresId.isEditable());
        }
        return true;
    }

    public String getEventListener() {
        return ((XFormRepeatable)this.component.getPresentationXMLObject()).getEventhandlermethod();
    }

    public void setFgColorProperty(int index, String colPresId, String color) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setFgColorProperty(index, colPresId, color);
        }
    }

    public String getFgColorProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getFgColorProperty(index, colPresId, columnElementByPresId.getForegroundColor());
        }
        return null;
    }

    public void setLinkProperty(int index, String colPresId, String link) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setLinkProperty(index, colPresId, link);
        }
    }

    public String getLinkProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getLinkProperty(index, colPresId, columnElementByPresId.getLink());
        }
        return null;
    }

    public DynamicRowProperties getRowProperties(int index) {
        return this.dynamicGroupProperties.getRowProperties(index);
    }

    public void setTextProperty(int index, String colPresId, String text) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setTextProperty(index, colPresId, text);
        }
    }

    public String getTextProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getTextProperty(index, colPresId, columnElementByPresId.getText());
        }
        return null;
    }

    public void setValue(Object value) {
        assert (value instanceof List);
        List valueList = (List)value;
        for (int i = 0; i < valueList.size(); ++i) {
            Object val = valueList.get(i);
            assert (val instanceof Map);
            Map rowValues = (Map)val;
            this.component.setValue(i, rowValues);
        }
    }

    public Object getValue() {
        try {
            return this.component.getXScreen().getRuntimeManager().getXObject().getAttributeValue(this.component.getReference());
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_GET_VALUE_PROBLEM(this.component.getId(), e.getLocalizedMessage()));
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            return null;
        }
    }

    public void setVisibleProperty(int index, String colPresId, boolean isVisible) {
        if (this.getColumnElementByPresId(colPresId) != null) {
            this.dynamicGroupProperties.setVisibleProperty(index, colPresId, isVisible);
        }
    }

    public boolean getVisibleProperty(int index, String colPresId) {
        XOElementComponent columnElementByPresId = this.getColumnElementByPresId(colPresId);
        if (columnElementByPresId != null && this.dynamicGroupProperties.hasRowProperties(index)) {
            return this.dynamicGroupProperties.getVisibleProperty(index, colPresId, columnElementByPresId.isVisible());
        }
        return true;
    }

    public void applyPropertiesToModelRow(int index, XOGroupComponent groupComponent) {
        if (this.hasRowProperties(index)) {
            DynamicRowProperties rowProperties = this.getRowProperties(index);
            rowProperties.applyPropertiesToModelRow(groupComponent);
        }
    }

    public void cleanRowProperties() {
        this.dynamicGroupProperties.cleanRowProperties();
    }

    @Override
    public void contentsChanged(int index) {
    }

    public boolean hasBeenApplied(int index) {
        return this.dynamicGroupProperties.hasBeenApplied(index);
    }

    public boolean hasEventListener() {
        return this.getEventListener() != null;
    }

    public boolean hasRowProperties(int index) {
        return this.dynamicGroupProperties.hasRowProperties(index);
    }

    public void initMaps(int mapSize) {
        this.presentationDataMap = new LinkedHashMap<String, String>(mapSize);
        this.dataPresentationMap.clear();
        this.columnElementMap.clear();
    }

    public void initPresentationGroupComponents() {
        for (String dataId : this.getColumnDataIds()) {
            XOInputComponent comp = (XOInputComponent)this.getColumnElementByDataId(dataId);
            comp.applyRestrictions();
        }
    }

    @Override
    public void intervalAdded(int startIndex, int endIndex) {
        this.dynamicGroupProperties.intervalAdded(startIndex, endIndex);
    }

    @Override
    public void intervalRemoved(GroupArray source, int startIndex, int endIndex) {
        this.dynamicGroupProperties.intervalRemoved(source, startIndex, endIndex);
    }

    public void registerColumnElement(XOPresentationComponent component) {
        if (component != null) {
            String reference = component.getReference();
            String string = reference = reference != null && reference.indexOf("[].") != -1 ? reference.substring(reference.indexOf("[].") + 3) : reference;
            if (reference != null) {
                this.registerDataIdWithPresentationId(reference, component.getId());
            }
            this.registerPresentationIdWithDataId(component.getId(), reference);
            this.registerPresentationIdWithElement(component.getId(), component);
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_GROUP_REGISTER_PROBLEM(this.component.getId()));
        }
    }

    public void restorePropertiesToModelRow(int index, XOGroupComponent groupComponent) {
        if (this.hasRowProperties(index)) {
            DynamicRowProperties rowProperties = this.getRowProperties(index);
            rowProperties.restorePropertiesToModelRow(groupComponent);
        }
    }

    public void sort(int columnIndex) {
        try {
            XObjectInstance xo = this.component.getXScreen().getXO();
            List<XObjectGroupRowInstance> xobjectInstanceList = xo.getGroupRows(this.component.getReference());
            ArrayList<XObjectGroupRowInstance> originalList = new ArrayList<XObjectGroupRowInstance>(xobjectInstanceList);
            String columnReference = this.getColumnDataIds()[columnIndex];
            this.registerSortEvent(columnIndex);
            MyComparator comparator = new MyComparator(columnReference);
            try {
                Collections.sort(xobjectInstanceList, comparator);
                GroupArray groupArray = (GroupArray)xo.getAttributeValue(this.component.getReference());
                ArrayList<DynamicRowProperties> propertyList = new ArrayList<DynamicRowProperties>(xobjectInstanceList.size());
                for (int i = 0; i < xobjectInstanceList.size(); ++i) {
                    XObjectGroupRowInstance groupRowInstance = xobjectInstanceList.get(i);
                    int originalIndex = originalList.indexOf(groupRowInstance);
                    propertyList.add(this.getRowProperties(originalIndex));
                    groupArray.set(i, groupRowInstance.getTarget());
                }
                this.setRowProperties(propertyList);
                this.component.handleSortEvent(this.sortEvent.getColumnIndex(), this.sortEvent.getOrderType());
            }
            catch (Throwable t) {
                Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_SORTING_ERROR(this.component.getId(), t.getMessage()));
                Log.logDebug(t);
            }
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_GROUP_SORTING_ERROR(this.component.getId(), e.getMessage()));
            Log.logDebug(e);
        }
    }

    public void syncroRowProperties(int rowQty) {
        if (!this.dynamicGroupProperties.hasBeenInitiated() && rowQty > 0) {
            this.intervalAdded(0, rowQty - 1);
        }
    }

    private void setRowProperties(List<DynamicRowProperties> properties) {
        this.dynamicGroupProperties.setRowProperties(properties);
    }

    private void init() {
        block3: {
            try {
                int groupSize = this.component.getXScreen().getXO().getGroupSize(this.component.getReference());
                if (groupSize > 0) {
                    this.dynamicGroupProperties.intervalAdded(0, groupSize - 1);
                }
            }
            catch (InvalidXOAttributeException e) {
                Log.logWarning(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENT_GET_VALUE_PROBLEM(this.component.getId(), e.getLocalizedMessage()));
                if (!Log.isDebugging()) break block3;
                Log.logDebug(e);
            }
        }
        this.component.addValueChangeListener(this.component.getXScreen().getRuntimeManager());
    }

    private void registerDataIdWithPresentationId(String dataId, String presentationId) {
        this.dataPresentationMap.put(dataId, presentationId);
    }

    private void registerPresentationIdWithDataId(String presentationId, String dataId) {
        this.presentationDataMap.put(presentationId, dataId);
    }

    private void registerPresentationIdWithElement(String presentationId, XOPresentationComponent component) {
        this.columnElementMap.put(presentationId, component);
    }

    private void registerSortEvent(int columnIndex) {
        if (this.sortEvent == null) {
            this.sortEvent = new SortEvent();
        }
        if (this.sortEvent.belongsTo(columnIndex)) {
            this.sortEvent.toggleSortType();
        } else {
            this.sortEvent.init(columnIndex);
        }
    }

    private class MyComparator
    implements Comparator<XObjectGroupRowInstance> {
        private final String columnReference;

        public MyComparator(String columnReference) {
            this.columnReference = columnReference;
        }

        @Override
        public int compare(XObjectGroupRowInstance xo1, XObjectGroupRowInstance xo2) {
            try {
                Object value2;
                Object value1;
                if (XOGroupComponentDelegate.this.sortEvent.getOrderType() == 0) {
                    value1 = xo1.getAttributeValue(this.columnReference);
                    value2 = xo2.getAttributeValue(this.columnReference);
                } else {
                    value2 = xo1.getAttributeValue(this.columnReference);
                    value1 = xo2.getAttributeValue(this.columnReference);
                }
                if (value1 instanceof Boolean || value2 instanceof Boolean) {
                    assert (value1 == null || value1 instanceof Boolean);
                    if (value1 == value2) {
                        return 0;
                    }
                    if (value1 == null) {
                        return -1;
                    }
                    if (((Boolean)value1).booleanValue()) {
                        return 1;
                    }
                    return -1;
                }
                return CILUtils.compare((Comparable)value1, (Comparable)value2);
            }
            catch (InvalidXOAttributeException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class DynamicRowProperties {
        private Map<String, DynamicComponentProperties> columnPropertyMap = null;
        private boolean hasBeenApplied = false;

        public void setProperty(String colPresId, int property, String value) {
            if (this.columnPropertyMap == null) {
                this.columnPropertyMap = new HashMap<String, DynamicComponentProperties>(1, 1.0f);
            }
            this.hasBeenApplied = false;
            DynamicComponentProperties componentProperties = this.columnPropertyMap.containsKey(colPresId) ? this.columnPropertyMap.get(colPresId) : new DynamicComponentProperties(colPresId);
            componentProperties.setProperty(property, value);
            this.columnPropertyMap.put(colPresId, componentProperties);
        }

        public DynamicComponentProperty getProperty(String colPresId, int property) {
            DynamicComponentProperties dynamicComponentProperties;
            if (this.hasProperties() && this.columnPropertyMap.containsKey(colPresId) && (dynamicComponentProperties = this.columnPropertyMap.get(colPresId)) != null) {
                return dynamicComponentProperties.getProperty(property);
            }
            return null;
        }

        public void applyPropertiesToModelRow(XOGroupComponent groupComponent) {
            this.hasBeenApplied = true;
            if (this.columnPropertyMap != null) {
                String[] keys;
                Set<String> strings = this.columnPropertyMap.keySet();
                for (String colPresId : keys = strings.toArray(new String[strings.size()])) {
                    DynamicComponentProperties componentProperties = this.columnPropertyMap.get(colPresId);
                    XOElementComponent component = groupComponent.getColumnElementByPresId(colPresId);
                    componentProperties.applyPropertiesTo(component);
                    if (componentProperties.hasProperties()) continue;
                    this.cleanProperties(colPresId);
                }
            }
        }

        public void cleanProperties(String colPresId) {
            if (this.columnPropertyMap != null) {
                if (this.columnPropertyMap.containsKey(colPresId)) {
                    this.columnPropertyMap.remove(colPresId);
                }
                if (this.columnPropertyMap.isEmpty()) {
                    this.columnPropertyMap = null;
                }
            }
        }

        public boolean hasBeenApplied() {
            return this.hasBeenApplied;
        }

        public boolean hasProperties() {
            return this.columnPropertyMap != null && this.columnPropertyMap.size() > 0;
        }

        public void restorePropertiesToModelRow(XOGroupComponent groupComponent) {
            if (this.columnPropertyMap != null) {
                for (String id : this.columnPropertyMap.keySet()) {
                    DynamicComponentProperties componentProperties = this.columnPropertyMap.get(id);
                    XOElementComponent component = groupComponent.getColumnElementByPresId(id);
                    componentProperties.restorePropertiesTo(component);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*************");
            stringBuffer.append("DynamicRowProperties@");
            stringBuffer.append(this.hashCode());
            stringBuffer.append("*************");
            stringBuffer.append("\n   - HasBeenApplied: ").append(this.hasBeenApplied);
            stringBuffer.append("\n   - ColQtyWithProps: ").append(this.columnPropertyMap != null ? String.valueOf(this.columnPropertyMap.size()) : "null");
            if (this.columnPropertyMap != null) {
                for (String id : this.columnPropertyMap.keySet()) {
                    DynamicComponentProperties componentProperties = this.columnPropertyMap.get(id);
                    stringBuffer.append("\n\n   >> colPresId [").append(id).append("] = ");
                    stringBuffer.append(componentProperties.toString());
                }
            }
            return stringBuffer.toString();
        }

        private final class DynamicComponentProperty {
            private String defaultValue;
            private int propertyCode;
            private String value;
            public static final int EDITABLE_PROPERTY = 1;
            public static final int VISIBLE_PROPERTY = 2;
            public static final int BGCOLOR_PROPERTY = 3;
            public static final int FGCOLOR_PROPERTY = 4;
            public static final int TEXT_PROPERTY = 5;
            public static final int LINK_PROPERTY = 6;

            public DynamicComponentProperty(int propertyCode, String value) {
                this.propertyCode = propertyCode;
                this.value = value;
                this.defaultValue = null;
            }

            public void setPropertyCode(int propertyCode) {
                this.propertyCode = propertyCode;
            }

            public int getPropertyCode() {
                return this.propertyCode;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public boolean applyPropertyTo(XOElementComponent component) {
                switch (this.getPropertyCode()) {
                    case 1: {
                        boolean currentEditableValue = component.isEditable();
                        boolean newEditableValue = Boolean.valueOf(this.value);
                        if (newEditableValue != currentEditableValue) {
                            this.setDefaultValue(String.valueOf(currentEditableValue));
                            component.setEditable(newEditableValue);
                            return true;
                        }
                        return false;
                    }
                    case 2: {
                        boolean currentVisibleValue = component.isVisible();
                        boolean newVisibleValue = Boolean.valueOf(this.value);
                        if (newVisibleValue != currentVisibleValue) {
                            this.setDefaultValue(String.valueOf(currentVisibleValue));
                            component.setVisible(newVisibleValue, component.isVisibleCollapsed());
                            return true;
                        }
                        return false;
                    }
                    case 3: {
                        String currentBgColorValue = component.getBackgroundColor();
                        String newBgColorValue = this.value;
                        if (!this.isEqual(newBgColorValue, currentBgColorValue)) {
                            this.setDefaultValue(currentBgColorValue);
                            component.setBackgroundColor(newBgColorValue);
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        String currentFgColorValue = component.getForegroundColor();
                        String newFgColorValue = this.value;
                        if (!this.isEqual(newFgColorValue, currentFgColorValue)) {
                            this.setDefaultValue(currentFgColorValue);
                            component.setForegroundColor(newFgColorValue);
                            return true;
                        }
                        return false;
                    }
                    case 5: {
                        String currentTextValue = component.getText();
                        String newTextValue = this.value;
                        if (!this.isEqual(newTextValue, currentTextValue)) {
                            this.setDefaultValue(currentTextValue);
                            component.setText(newTextValue);
                            return true;
                        }
                        return false;
                    }
                    case 6: {
                        String currentLinkValue = component.getLink();
                        String newLinkValue = this.value;
                        if (!this.isEqual(newLinkValue, currentLinkValue)) {
                            this.setDefaultValue(currentLinkValue);
                            component.setLink(newLinkValue);
                            return true;
                        }
                        return false;
                    }
                }
                return false;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DynamicComponentProperty)) {
                    return false;
                }
                DynamicComponentProperty dynamicComponentProperty = (DynamicComponentProperty)o;
                return this.propertyCode == dynamicComponentProperty.propertyCode;
            }

            public int hashCode() {
                return this.propertyCode;
            }

            public void restorePropertyTo(XOElementComponent component) {
                switch (this.getPropertyCode()) {
                    case 1: {
                        boolean defaultEditableValue;
                        boolean currentEditableValue = component.isEditable();
                        boolean bl = defaultEditableValue = this.defaultValue != null ? Boolean.valueOf(this.defaultValue) : true;
                        if (defaultEditableValue != currentEditableValue) {
                            component.setEditable(defaultEditableValue);
                        }
                        this.resetDefaultValue();
                        break;
                    }
                    case 2: {
                        boolean defaultVisibleValue;
                        boolean currentVisibleValue = component.isVisible();
                        boolean bl = defaultVisibleValue = this.defaultValue != null ? Boolean.valueOf(this.defaultValue) : true;
                        if (defaultVisibleValue != currentVisibleValue) {
                            component.setVisible(defaultVisibleValue, component.isVisibleCollapsed());
                        }
                        this.resetDefaultValue();
                        break;
                    }
                    case 3: {
                        String currentBgColorValue = component.getBackgroundColor();
                        String defaultBgColorValue = this.defaultValue;
                        if (!this.isEqual(defaultBgColorValue, currentBgColorValue)) {
                            component.setBackgroundColor(defaultBgColorValue);
                        }
                        this.resetDefaultValue();
                        break;
                    }
                    case 4: {
                        String currentFgColorValue = component.getForegroundColor();
                        String defaultFgColorValue = this.defaultValue;
                        if (!this.isEqual(defaultFgColorValue, currentFgColorValue)) {
                            component.setForegroundColor(defaultFgColorValue);
                        }
                        this.resetDefaultValue();
                        break;
                    }
                    case 5: {
                        String currentTextValue = component.getText();
                        String defaultTextValue = this.defaultValue;
                        if (!this.isEqual(defaultTextValue, currentTextValue)) {
                            component.setText(defaultTextValue);
                        }
                        this.resetDefaultValue();
                        break;
                    }
                    case 6: {
                        String currentLinkValue = component.getLink();
                        String defaultLinkValue = this.defaultValue;
                        if (!this.isEqual(defaultLinkValue, currentLinkValue)) {
                            component.setText(defaultLinkValue);
                        }
                        this.resetDefaultValue();
                    }
                }
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("=========");
                stringBuffer.append("DynamicComponentProperty@");
                stringBuffer.append(this.hashCode());
                stringBuffer.append("=========");
                stringBuffer.append("\n   - Code: ").append(this.propertyCode);
                stringBuffer.append("\n   - Value: ").append(this.value);
                stringBuffer.append("\n   - DefaultValue: ").append(this.defaultValue);
                return stringBuffer.toString();
            }

            private void setDefaultValue(String defaultValue) {
                if (this.defaultValue == null) {
                    this.defaultValue = defaultValue;
                }
            }

            private boolean isEqual(String defaultValue, String currentValue) {
                if (defaultValue == null) {
                    return currentValue == null;
                }
                return defaultValue.equals(currentValue);
            }

            private void resetDefaultValue() {
                this.defaultValue = null;
            }
        }

        private final class DynamicComponentProperties {
            private String colPresId;
            private List<DynamicComponentProperty> propertyList;

            public DynamicComponentProperties(String colPresId) {
                this.colPresId = colPresId;
            }

            public void setProperty(int propertyCode, String value) {
                int index;
                if (this.propertyList == null) {
                    this.propertyList = new ArrayList<DynamicComponentProperty>(1);
                }
                if ((index = this.indexOfProperty(propertyCode)) >= 0) {
                    DynamicComponentProperty dynamicComponentProperty = this.propertyList.get(index);
                    dynamicComponentProperty.setValue(value);
                } else {
                    DynamicComponentProperty dynamicComponentProperty = new DynamicComponentProperty(propertyCode, value);
                    this.propertyList.add(dynamicComponentProperty);
                }
            }

            public DynamicComponentProperty getProperty(int property) {
                int index;
                if (this.hasProperties() && (index = this.propertyList.indexOf(new DynamicComponentProperty(property, null))) != -1) {
                    return this.propertyList.get(index);
                }
                return null;
            }

            public void applyPropertiesTo(XOElementComponent component) {
                if (component != null && component.getId().equals(this.colPresId)) {
                    for (int i = 0; i < this.propertyList.size(); ++i) {
                        DynamicComponentProperty dynamicComponentProperty = this.propertyList.get(i);
                        boolean isNotDefaultValue = dynamicComponentProperty.applyPropertyTo(component);
                        if (isNotDefaultValue) continue;
                        this.propertyList.remove(i--);
                    }
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DynamicComponentProperties)) {
                    return false;
                }
                DynamicComponentProperties dynamicComponentProperties = (DynamicComponentProperties)o;
                return !(this.colPresId == null ? dynamicComponentProperties.colPresId != null : !this.colPresId.equals(dynamicComponentProperties.colPresId));
            }

            public boolean hasProperties() {
                return this.propertyList != null && this.propertyList.size() > 0;
            }

            public int hashCode() {
                return this.colPresId != null ? this.colPresId.hashCode() : 0;
            }

            public void restorePropertiesTo(XOElementComponent component) {
                if (component != null && component.getId().equals(this.colPresId)) {
                    for (DynamicComponentProperty dynamicComponentProperty : this.propertyList) {
                        dynamicComponentProperty.restorePropertyTo(component);
                    }
                }
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(">>>>>>>>>>>>");
                stringBuffer.append("DynamicComponentProperties@");
                stringBuffer.append(this.hashCode());
                stringBuffer.append(">>>>>>>>>>>>");
                stringBuffer.append("\n   - colPresId: ").append(this.colPresId);
                if (this.propertyList != null) {
                    for (DynamicComponentProperty dynamicComponentProperty : this.propertyList) {
                        stringBuffer.append("\n   >> property: ").append(dynamicComponentProperty);
                    }
                }
                return stringBuffer.toString();
            }

            private int indexOfProperty(int propertyCode) {
                if (this.propertyList != null) {
                    return this.propertyList.indexOf(new DynamicComponentProperty(propertyCode, null));
                }
                return -2;
            }
        }
    }

    private final class DynamicGroupProperties
    implements GroupArrayChangeListener {
        private List<DynamicRowProperties> rowPropertyList;

        public void setBgColorProperty(int index, String colPresId, String color) {
            this.setProperty(index, colPresId, 3, color);
        }

        public String getBgColorProperty(int index, String colPresId, String defaultColor) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 3);
            if (componentProperty != null) {
                return componentProperty.getValue();
            }
            return defaultColor;
        }

        public void setEditableProperty(int index, String colPresId, boolean isEditable) {
            this.setProperty(index, colPresId, 1, String.valueOf(isEditable));
        }

        public boolean getEditableProperty(int index, String colPresId, boolean defaultEditable) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 1);
            if (componentProperty != null) {
                return Boolean.valueOf(componentProperty.getValue());
            }
            return defaultEditable;
        }

        public void setFgColorProperty(int index, String colPresId, String color) {
            this.setProperty(index, colPresId, 4, color);
        }

        public String getFgColorProperty(int index, String colPresId, String defaultColor) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 4);
            if (componentProperty != null) {
                return componentProperty.getValue();
            }
            return defaultColor;
        }

        public void setLinkProperty(int index, String colPresId, String link) {
            this.setProperty(index, colPresId, 6, link);
        }

        public String getLinkProperty(int index, String colPresId, String defaultLink) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 6);
            if (componentProperty != null) {
                return componentProperty.getValue();
            }
            return defaultLink;
        }

        public DynamicRowProperties getRowProperties(int index) {
            if (this.rowPropertyList != null && this.rowPropertyList.size() > index) {
                return this.rowPropertyList.get(index);
            }
            return null;
        }

        public void setTextProperty(int index, String colPresId, String text) {
            this.setProperty(index, colPresId, 5, text);
        }

        public String getTextProperty(int index, String colPresId, String defaultText) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 5);
            if (componentProperty != null) {
                return componentProperty.getValue();
            }
            return defaultText;
        }

        public void setVisibleProperty(int index, String colPresId, boolean isVisible) {
            this.setProperty(index, colPresId, 2, String.valueOf(isVisible));
        }

        public boolean getVisibleProperty(int index, String colPresId, boolean defaultVisibility) {
            DynamicRowProperties.DynamicComponentProperty componentProperty = this.getProperty(index, colPresId, 2);
            if (componentProperty != null) {
                return Boolean.valueOf(componentProperty.getValue());
            }
            return defaultVisibility;
        }

        public void cleanRowProperties() {
            if (this.rowPropertyList != null) {
                for (int i = 0; i < this.rowPropertyList.size(); ++i) {
                    DynamicRowProperties dynamicRowProperties = this.rowPropertyList.get(i);
                    if (dynamicRowProperties == null || dynamicRowProperties.hasProperties()) continue;
                    this.rowPropertyList.set(i, null);
                }
            }
        }

        @Override
        public void contentsChanged(int index) {
        }

        public boolean hasBeenApplied(int index) {
            return this.hasRowProperties(index) && this.getRowProperties(index).hasBeenApplied();
        }

        public boolean hasBeenInitiated() {
            return this.rowPropertyList != null;
        }

        public boolean hasRowProperties(int index) {
            DynamicRowProperties rowProperties = this.getRowProperties(index);
            return rowProperties != null && rowProperties.hasProperties();
        }

        @Override
        public void intervalAdded(int startIndex, int endIndex) {
            if (this.rowPropertyList == null) {
                this.rowPropertyList = new ArrayList<DynamicRowProperties>(endIndex - startIndex);
            }
            if (startIndex > this.rowPropertyList.size()) {
                startIndex = this.rowPropertyList.size();
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                this.rowPropertyList.add(i, null);
            }
        }

        @Override
        public void intervalRemoved(GroupArray source, int startIndex, int endIndex) {
            if (this.rowPropertyList != null) {
                if (this.rowPropertyList.size() > endIndex) {
                    for (int i = startIndex; i <= endIndex; ++i) {
                        this.rowPropertyList.remove(startIndex);
                    }
                }
                if (this.rowPropertyList.isEmpty()) {
                    this.rowPropertyList = null;
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("##############");
            stringBuffer.append("DynamicGroupProperties@");
            stringBuffer.append(this.hashCode());
            stringBuffer.append("##############");
            stringBuffer.append("\n   - Qty: ");
            stringBuffer.append(this.rowPropertyList != null ? String.valueOf(this.rowPropertyList.size()) : "null");
            if (this.rowPropertyList != null) {
                for (DynamicRowProperties dynamicRowProperties : this.rowPropertyList) {
                    stringBuffer.append("\n");
                    if (dynamicRowProperties != null) {
                        stringBuffer.append(dynamicRowProperties.toString());
                        continue;
                    }
                    stringBuffer.append("null");
                }
            }
            return stringBuffer.toString();
        }

        private void setRowProperties(List<DynamicRowProperties> properties) {
            this.rowPropertyList = properties;
        }

        private void setProperty(int index, String colPresId, int property, String value) {
            if (this.rowPropertyList != null && this.rowPropertyList.size() > index) {
                DynamicRowProperties rowProperties = this.rowPropertyList.get(index);
                if (rowProperties == null) {
                    rowProperties = new DynamicRowProperties();
                }
                rowProperties.setProperty(colPresId, property, value);
                this.rowPropertyList.set(index, rowProperties);
            }
        }

        private DynamicRowProperties.DynamicComponentProperty getProperty(int index, String colPresId, int property) {
            if (this.hasRowProperties(index)) {
                DynamicRowProperties rowProperties = this.getRowProperties(index);
                return rowProperties.getProperty(colPresId, property);
            }
            return null;
        }
    }

    private static final class SortEvent {
        private int columnIndex = -1;
        private int orderType = 0;
        private static final int ASCENDING_ORDER = 0;
        private static final int DESCENDING_ORDER = 1;

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getOrderType() {
            return this.orderType;
        }

        public boolean belongsTo(int columnIndex) {
            return this.getColumnIndex() == columnIndex;
        }

        public void init(int columnIndex) {
            this.setColumnIndex(columnIndex);
            this.setOrderType(0);
        }

        public void toggleSortType() {
            this.setOrderType(this.getOrderType() == 0 ? 1 : 0);
        }

        private void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        private void setOrderType(int orderType) {
            this.orderType = orderType;
        }
    }
}

