/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.lib.chart.FusionChartXmlFactory;
import oracle.bpm.xobject.lib.chart.GraphicType;
import oracle.bpm.xobject.runtime.presentationComponents.XOGaugeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponentDelegate;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XOGaugeComponentDelegate
extends XOGraphicComponentDelegate {
    private XOGraphicComponentDelegate.GraphicComponentInfo<Number, XOGaugeComponent> componentInfo;

    public XOGaugeComponentDelegate(XOGaugeComponent component) {
        super(component);
    }

    public final XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo() {
        XOGaugeComponent gaugeComponent = (XOGaugeComponent)this.component;
        Number value = null;
        boolean hasError = false;
        String dataMethodInvocation = gaugeComponent.getDataMethodInvocation();
        try {
            value = (Number)gaugeComponent.getXScreen().getXO().invokeMethod(dataMethodInvocation, null);
        }
        catch (Throwable t) {
            hasError = true;
            Throwable cause = t;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Log.logWarning(XObjectRuntimeMsg.GRAPHIC_LOADING_ERROR(gaugeComponent.getId(), dataMethodInvocation, cause.getMessage()));
            Log.logDebug(t);
        }
        gaugeComponent.setHasError(hasError);
        return this.getGraphicComponentInfo(value);
    }

    @Override
    public List<XOGraphicComponentDelegate.GraphicType> getGraphicTypes(Locale locale) {
        ArrayList<XOGraphicComponentDelegate.GraphicType> graphicTypes = new ArrayList<XOGraphicComponentDelegate.GraphicType>(2);
        List<GraphicType> list = GraphicType.getSubtypes("GAUGE");
        for (GraphicType type : list) {
            graphicTypes.add(new XOGraphicComponentDelegate.GraphicType(type, locale));
        }
        return graphicTypes;
    }

    @Override
    public void recreateGraphic(XOGraphicComponentDelegate.GraphicComponentInfo info) {
    }

    @Override
    void init() {
    }

    private XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo(Number value) {
        if (this.componentInfo == null) {
            this.componentInfo = new XOGraphicComponentDelegate.GraphicComponentInfo<Number, XOGaugeComponent>(value, (XOGaugeComponent)this.component){

                @Override
                public String getGraphicImageData() {
                    return FusionChartXmlFactory.getFusionChartData((Number)this.getValue(), (XOGaugeComponent)this.getComponent());
                }
            };
        } else {
            this.componentInfo.updateValue(value);
        }
        return this.componentInfo;
    }
}

