/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.presentationComponents;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.util.DateFormatSymbolUtils;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;

public class XODateTimeComponentDelegate {
    private int datePresicion = -123;
    private boolean isAbsoluteDate = false;
    private Locale locale = null;
    private TimeZone timeZone = null;

    public XODateTimeComponentDelegate(XODateTimeComponent component, Locale locale, TimeZone timezone) {
        this.locale = locale;
        this.timeZone = timezone;
        this.init();
    }

    public void setAbsoluteDate(boolean isAbsolute) {
        this.isAbsoluteDate = isAbsolute;
    }

    public boolean isAbsoluteDate() {
        return this.isAbsoluteDate;
    }

    public boolean isDate() {
        return this.datePresicion != -123;
    }

    public final DateFormat getDateFormat(Locale locale) {
        String patternStr;
        switch (this.getDatePrecision()) {
            case 0: {
                patternStr = DateFormatSymbolUtils.getSimpleFuegoDatePattern(locale);
                break;
            }
            case 1: {
                patternStr = DateFormatSymbolUtils.getSimpleFuegoTimePattern(locale);
                break;
            }
            default: {
                patternStr = DateFormatSymbolUtils.getSimpleFuegoDateTimePattern(locale);
            }
        }
        return new SimpleDateFormat(patternStr, locale);
    }

    public void setDatePrecision(int precision) {
        this.datePresicion = precision;
    }

    public int getDatePrecision() {
        return this.datePresicion;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final String convertDataValueToPresentationValue(Time time) {
        return this.convertDataValueToPresentationValue(time, this.getDateFormat(this.locale));
    }

    public final String convertDataValueToPresentationValue(Time time, String mask) {
        return time.format(mask);
    }

    public final String convertPresentationValueToDataValue(String value) throws ParseException {
        Time resultTime = null;
        if (value != null && value.trim().length() > 0) {
            if (value.startsWith("EDITABLE")) {
                StringTokenizer st = new StringTokenizer(value, "$");
                st.nextToken();
                String dateStr = null;
                String hourStr = null;
                String minuteStr = null;
                switch (this.getDatePrecision()) {
                    case 0: {
                        if (st.countTokens() != 1) break;
                        dateStr = st.nextToken();
                        break;
                    }
                    case 1: {
                        hourStr = st.nextToken();
                        minuteStr = st.nextToken();
                        break;
                    }
                    case 2: {
                        if (st.countTokens() == 3) {
                            dateStr = st.nextToken();
                        }
                        hourStr = st.nextToken();
                        minuteStr = st.nextToken();
                    }
                }
                resultTime = this.getTimeFrom(dateStr, hourStr, minuteStr);
            } else if (!value.startsWith("NON_EDITABLE")) {
                DateFormat dateFormat = this.getDateFormat(this.locale);
                dateFormat.setCalendar(Calendar.getInstance(this.timeZone, this.locale));
                Time tmpTime = null;
                try {
                    tmpTime = Time.valueOf(dateFormat.parse(value));
                }
                catch (ParseException e) {
                    try {
                        tmpTime = Time.valueOf(Long.parseLong(value));
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                }
                if (tmpTime != null) {
                    switch (this.getDatePrecision()) {
                        case 0: {
                            resultTime = Time.valueOf(tmpTime.getYear(), tmpTime.getMonth(), tmpTime.getDayOfMonth(), 0, 0, 0);
                            break;
                        }
                        case 1: {
                            resultTime = Time.valueOf(tmpTime.getHourOfDay() + ":" + tmpTime.getMinute() + ":" + tmpTime.getSecond());
                            break;
                        }
                        default: {
                            resultTime = Time.valueOf(tmpTime.getYear(), tmpTime.getMonth(), tmpTime.getDayOfMonth(), tmpTime.getHourOfDay(), tmpTime.getMinute(), tmpTime.getSecond());
                        }
                    }
                }
            }
        }
        return resultTime != null ? resultTime.toString() : "";
    }

    public long convertDataValueToMicroseconds(String strTime) {
        long microseconds = -1L;
        try {
            Time t = Time.valueOf(strTime);
            if (t != null) {
                String formattedTime = this.convertDataValueToPresentationValue(t);
                String cleanValue = this.convertPresentationValueToDataValue(formattedTime);
                Time cleanTime = Time.valueOf(cleanValue);
                microseconds = cleanTime.getMicroSeconds();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return microseconds;
    }

    public void restrict(int precision, boolean isAbsolute) {
        this.setDatePrecision(precision);
        this.setAbsoluteDate(isAbsolute);
    }

    private Time getTimeFrom(String dateStr, String hourStr, String minuteStr) throws ParseException {
        Time date;
        int nullCounter = 0;
        int hour = 0;
        int minutes = 0;
        Time resultTime = null;
        if (dateStr != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateFormatSymbolUtils.getSimpleFuegoDatePattern(this.locale), this.locale);
            dateFormat.setCalendar(Calendar.getInstance(this.timeZone, this.locale));
            date = Time.valueOf(dateFormat.parse(dateStr));
        } else {
            ++nullCounter;
            date = Time.now();
        }
        if (hourStr != null && !hourStr.equals("-1")) {
            hour = Integer.parseInt(hourStr);
        } else {
            ++nullCounter;
        }
        if (minuteStr != null && !minuteStr.equals("-1")) {
            minutes = Integer.parseInt(minuteStr);
        } else {
            ++nullCounter;
        }
        if (nullCounter == 3) {
            return null;
        }
        switch (this.getDatePrecision()) {
            case 0: {
                resultTime = Time.valueOf(date.getYear(), date.getMonth(), date.getDayOfMonth(), 0, 0, 0);
                break;
            }
            case 1: {
                resultTime = Time.valueOf(String.valueOf(hour) + ":" + String.valueOf(minutes));
                break;
            }
            case 2: {
                resultTime = Time.valueOf(date.getYear(), date.getMonth(), date.getDayOfMonth(), hour, minutes, 0);
            }
        }
        return resultTime;
    }

    private String convertDataValueToPresentationValue(Time time, DateFormat dateFormat) {
        return this.isAbsoluteDate() ? time.formatGMT(dateFormat) : time.format(dateFormat, this.timeZone);
    }

    private void init() {
    }
}

