/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOTextFieldComponentDelegate;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLTextField
extends HTMLInputElement
implements XOTextFieldComponent,
XODateTimeComponent {
    private final XOTextFieldComponentDelegate componentDelegate;
    private final XODateTimeComponentDelegate dateComponentDelegate;
    private final DecimalFormatSymbols decimalSymb;
    private Input editableTextfield;
    private boolean isDisplayAsLabel;
    private DIV nonEditableDIV;
    private Text nonEditableText;
    private String onChangeScript;
    private boolean restrictLength;
    private int restrictLengthValue = -1;
    private boolean restrictPrecision;
    private int restrictPrecisionValue = -1;
    private boolean restrictType;
    private int restrictTypeValue = -1;
    private String theValue;
    private static final double SIZE_X_FACTOR = 1.2;

    public HTMLTextField(XScreen xScreen, XFormText t, Locale locale, TimeZone tz) {
        super(xScreen, t);
        this.decimalSymb = new DecimalFormatSymbols(locale);
        this.componentDelegate = new XOTextFieldComponentDelegate(this);
        this.dateComponentDelegate = new XODateTimeComponentDelegate(this, locale, tz);
        this.initTextField(t);
    }

    public static HTMLTextField newInstance(HTMLTextField originalElement) {
        HTMLTextField newElement = new HTMLTextField(originalElement.getXScreen(), (XFormText)originalElement.getPresentationXMLObject(), originalElement.getLocale(), originalElement.getTimeZone());
        newElement.setValue(originalElement.getDefaultValue());
        if (originalElement.restrictLength) {
            newElement.restrictLength(originalElement.restrictLengthValue);
        }
        if (originalElement.restrictPrecision) {
            newElement.restrictPrecision(originalElement.restrictPrecisionValue);
        }
        if (originalElement.restrictType) {
            newElement.restrictType(originalElement.restrictTypeValue);
        }
        return newElement;
    }

    @Override
    public void _setEditable(boolean editable) {
        super._setEditable(editable);
        if (this.editableTextfield != null) {
            this.editableTextfield.setReadOnly(!this.isEditable());
            if (!this.isDisplayAsLabel) {
                String value = null;
                if (editable) {
                    value = this.theValue;
                    XFormText t = (XFormText)this.getPresentationXMLObject();
                    if (t.getColqty() > 0) {
                        this.editableTextfield.setSize(String.valueOf((int)((double)t.getColqty() * 1.2)));
                    }
                } else {
                    value = this.componentDelegate.getNonEditableText(this.getLocale(), this.theValue, this.getKind());
                }
                this.editableTextfield.setValue(value);
            }
        }
        this.applyStyle();
    }

    @Override
    public Object clone() {
        return HTMLTextField.newInstance(this);
    }

    @Override
    public String convertDataValueToPresentationValue(Time time) {
        return this.dateComponentDelegate.convertDataValueToPresentationValue(time);
    }

    @Override
    public String convertPresentationValueToDataValue(String value) throws ParseException {
        return this.dateComponentDelegate.convertPresentationValueToDataValue(value);
    }

    @Override
    public int getDatePrecision() {
        return this.dateComponentDelegate.getDatePrecision();
    }

    @Override
    public String getElementHtmlId() {
        return this.getPureElement().getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public String getFormatString() {
        return null;
    }

    @Override
    public String getInputPattern() {
        return this.componentDelegate.getInputPattern();
    }

    @Override
    public String getInputPatternErrorColor() {
        return this.componentDelegate.getInputPatternErrorColor();
    }

    @Override
    public String getInputPatternErrorMsg() {
        return this.componentDelegate.getInputPatternErrorMsg();
    }

    @Override
    public Locale getLocale() {
        return this.dateComponentDelegate.getLocale();
    }

    @Override
    public String getMask() {
        return this.componentDelegate.getMask();
    }

    @Override
    public String getMaskErrorColor() {
        return this.componentDelegate.getMaskErrorColor();
    }

    @Override
    public String getMaskErrorMsg() {
        return this.componentDelegate.getMaskErrorMsg();
    }

    @Override
    public Element getPureElement() {
        if (!this.isEditable() && this.isDisplayAsLabel) {
            return this.nonEditableDIV;
        }
        return this.editableTextfield;
    }

    @Override
    public String getStyle() {
        XFormText t = (XFormText)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(t.fonttype, t.getFontStyle(), t.fontsize));
            css.append(this.getInlineTextAlignmentCSS(t.alignment));
            String foregroundColor = this.getForegroundColor();
            if (foregroundColor == null && !this.isEditable()) {
                foregroundColor = "#000000";
            }
            css.append(this.getInlineForegroundColorCCS(foregroundColor));
            if (this.isEditable()) {
                css.append(this.getInlineBorderCSS(t.borderstyle, t.bordercolor, t.borderwidth));
            }
        }
        return css.toString();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.dateComponentDelegate.getTimeZone();
    }

    @Override
    public boolean hasInputPattern() {
        return this.componentDelegate.hasInputPattern();
    }

    @Override
    public boolean hasMask() {
        return this.componentDelegate.hasMask();
    }

    @Override
    public boolean isAbsoluteDate() {
        return this.dateComponentDelegate.isAbsoluteDate();
    }

    @Override
    public boolean isDate() {
        return this.dateComponentDelegate.isDate();
    }

    public boolean isDisplayAsLabel() {
        return this.isDisplayAsLabel;
    }

    @Override
    public void restrict(int precision, boolean isAbsolute) {
        this.dateComponentDelegate.restrict(precision, isAbsolute);
        ((XScreenHTMLImpl)this.getXScreen()).getPage().initPageWithDateTimeElement(this.getLocale(), this.getTimeZone());
        this.editableTextfield.setOnChange(this.getOnChangeScript());
    }

    @Override
    public void restrictLength(int length) {
        this.restrictLength = true;
        this.restrictLengthValue = length;
        this.editableTextfield.setMaxlength(String.valueOf(length));
    }

    @Override
    public void restrictPrecision(int precision) {
        this.restrictPrecision = true;
        this.restrictPrecisionValue = precision;
        this.applyRestrictions(this.restrictType, this.restrictPrecision);
    }

    @Override
    public void restrictType(int kind) {
        this.restrictType = true;
        this.restrictTypeValue = kind;
        this.applyRestrictions(this.restrictType, this.restrictPrecision);
    }

    @Override
    public void setName(String name) {
        if (this.editableTextfield != null) {
            this.editableTextfield.setName(name);
            this.editableTextfield.setHtmlId(name);
        }
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.editableTextfield != null) {
            this.editableTextfield.setTabindex(tabIndex);
        }
    }

    @Override
    public void setValue(Object value) {
        try {
            String valueStr = this.componentDelegate.convertToString(value);
            if (this.isDate()) {
                if (valueStr != null && !valueStr.trim().isEmpty()) {
                    Time fullDate = Time.valueOf(valueStr);
                    valueStr = this.convertDataValueToPresentationValue(fullDate);
                }
            } else {
                int kind = this.getKind();
                if (kind == 2 || kind == 5) {
                    Pattern pattern;
                    String warningMsg = null;
                    XORuntimeManager runtimeMgr = this.getXScreen().getRuntimeManager();
                    if (this.hasMask()) {
                        try {
                            valueStr = this.componentDelegate.applyMask(this.getMask(), valueStr);
                        }
                        catch (RuntimeException e) {
                            warningMsg = XObjectRuntimeMsg.INVALID_INPUT_BY_MASK2(valueStr, this.getMask()).getString(this.getLocale());
                            valueStr = null;
                        }
                    }
                    if (this.hasInputPattern() && valueStr != null && runtimeMgr.isInitialized() && !(pattern = Pattern.compile(this.getInputPattern())).matcher(valueStr).matches()) {
                        Locale locale = this.getLocale();
                        warningMsg = XObjectRuntimeMsg.INVALID_INPUT_BY_PATTERN2(valueStr, this.getInputPattern()).getString(locale);
                        valueStr = CoreMsg.ERROR.getString(locale);
                    }
                    if (warningMsg != null) {
                        String htmlId = null;
                        if (this.isEditable()) {
                            htmlId = this.getElementHtmlId();
                        }
                        XScreenHTMLImpl xScreen = (XScreenHTMLImpl)this.getXScreen();
                        String msg = XScreenHTMLImpl.buildHTMLMessage(this.getReference(), warningMsg, htmlId);
                        xScreen.showWarning(msg);
                    }
                } else if (kind == 3 || kind == 4) {
                    valueStr = valueStr.replace('.', this.decimalSymb.getDecimalSeparator());
                }
            }
            if (valueStr != null) {
                String nonEditableText = this.componentDelegate.getNonEditableText(this.getLocale(), valueStr, this.getKind());
                this.editableTextfield.setValue(!this.isEditable() && !this.isDisplayAsLabel ? nonEditableText : valueStr);
                this.nonEditableText.setText(nonEditableText);
                this.theValue = valueStr;
                if (!this.isEditable() && !this.isDisplayAsLabel) {
                    XFormText xText = (XFormText)this.getPresentationXMLObject();
                    int visibleSize = (int)((double)(valueStr.length() > xText.getColqty() ? valueStr.length() : xText.getColqty()) * 1.2);
                    this.editableTextfield.setSize(String.valueOf(visibleSize));
                }
            }
        }
        catch (Exception e) {
            this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
            Log.logDebug(e);
        }
    }

    @Override
    protected void _applyStyle(String style) {
        this.applyEditableStyle(style);
        this.applyNonEditableStyle(style);
    }

    @Override
    void _setOnFocus(String js) {
        this.editableTextfield.setOnFocus(js + "lastElementValue = this.value;");
    }

    private void applyEditableStyle(String style) {
        if (this.editableTextfield != null) {
            StringBuilder css = new StringBuilder(style);
            if (!this.isEditable()) {
                css.append(this.getInlineBorderCSS("none", "#FFFFFF", 0));
            }
            if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
                String bgColorStyle = "";
                bgColorStyle = this.isEditable() ? this.getInlineBackgroundColorCCS(this.getBackgroundColor()) : this.getInlineBackgroundColorCCS("transparent");
                css.append(bgColorStyle);
            }
            this.editableTextfield.setStyle(css.toString());
            if (this.isCssEnabled()) {
                this.editableTextfield.setCssClass(this.getCssClassName());
            } else {
                this.editableTextfield.setCssClass("");
            }
        }
    }

    private void applyNonEditableStyle(String style) {
        if (this.nonEditableDIV != null) {
            StringBuilder css = new StringBuilder(style);
            if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
                String bgColorStyle = this.isEditable() ? this.getInlineBackgroundColorCCS(this.getBackgroundColor()) : this.getInlineBackgroundColorCCS("transparent");
                css.append(bgColorStyle);
            }
            this.nonEditableDIV.setStyle(css.toString());
            if (this.isCssEnabled()) {
                this.nonEditableDIV.setCssClass(this.getCssClassName());
            } else {
                this.nonEditableDIV.setCssClass("");
            }
        }
    }

    private void applyRestrictions(boolean type, boolean precision) {
        if (this.isEditable()) {
            StringBuilder js = new StringBuilder();
            js.append("if(!isEnterKey(event) && (isSpecialKey(event) || ");
            if (type) {
                switch (this.restrictTypeValue) {
                    case 2: 
                    case 3: 
                    case 4: {
                        int thePrecision = this.getPrecision() == -1 ? 100 : this.getPrecision();
                        js.append(this.hasMask() ? "true" : "checkNumber(this, " + this.getLength() + ", " + thePrecision + ", '" + this.decimalSymb.getDecimalSeparator() + "')");
                        this.editableTextfield.setOnKeyUp(this.hasMask() ? "true" : "checkNumber(this, " + this.getLength() + ", " + thePrecision + ", '" + this.decimalSymb.getDecimalSeparator() + "')");
                        StringBuilder onBlur = new StringBuilder();
                        onBlur.append("if(navigator.appName == 'Microsoft Internet Explorer' && lastElementValue != this.value){");
                        onBlur.append(this.getOnChangeScript());
                        onBlur.append('}');
                        this.editableTextfield.setOnBlur(onBlur.toString());
                        break;
                    }
                    default: {
                        js.append("true");
                    }
                }
            }
            js.append(")){return true;}else{return false;}");
            this.editableTextfield.setOnKeyPress(js.toString());
            this.editableTextfield.setOnSelect("setSelectedComponent(this.name)");
        }
    }

    private String getOnChangeScript() {
        XFormText xText = (XFormText)this.getPresentationXMLObject();
        StringBuilder onChangeScript = new StringBuilder();
        if (!this.isPreview()) {
            if (this.isDate()) {
                String pattern = ((SimpleDateFormat)this.dateComponentDelegate.getDateFormat(this.getLocale())).toLocalizedPattern();
                this.editableTextfield.setTitle(pattern);
                onChangeScript.append("if(performInlineValidation(isDate(this.value, '");
                onChangeScript.append(pattern);
                onChangeScript.append("'), '");
                onChangeScript.append(this.escape(XObjectRuntimeMsg.INVALID_DATE_FORMAT(pattern).getString(), true));
                onChangeScript.append("', this.style.bgcolor, this");
                if (!this.isClientErrorAsPopup()) {
                    onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                }
                onChangeScript.append(")){");
            }
            onChangeScript.append("isMaskOk=true;isPatternOk=true;");
            if (!(xText.passwordfield || xText.getReference() == null || this.getKind() != 5 && this.getKind() != 2)) {
                if (this.hasMask()) {
                    String mask = this.escape(this.getMask(), true);
                    onChangeScript.append("mask='");
                    onChangeScript.append(mask);
                    onChangeScript.append("';");
                    onChangeScript.append("isMaskOk=performInlineValidation(eval('applyMask(mask, this)'),'");
                    onChangeScript.append(this.escape(this.getMaskErrorMsg(), true));
                    onChangeScript.append("', '");
                    onChangeScript.append(this.getMaskErrorColor());
                    onChangeScript.append("', this");
                    if (!this.isClientErrorAsPopup()) {
                        onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    onChangeScript.append(");");
                    this.editableTextfield.setTitle(mask);
                }
                if (this.hasInputPattern()) {
                    onChangeScript.append("pattern=/");
                    onChangeScript.append(this.escape(this.getInputPattern(), false));
                    onChangeScript.append("/;");
                    onChangeScript.append("if(isMaskOk){isPatternOk=performInlineValidation(eval('isPatternMatch(this.value, pattern)'),'");
                    onChangeScript.append(this.escape(this.getInputPatternErrorMsg(), true));
                    onChangeScript.append("', '");
                    onChangeScript.append(this.getInputPatternErrorColor());
                    onChangeScript.append("', this");
                    if (!this.isClientErrorAsPopup()) {
                        onChangeScript.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    onChangeScript.append(");}");
                }
            }
            if (!this.isPreview()) {
                onChangeScript.append("if(isMaskOk && isPatternOk){valueChanged(this.name, ");
                onChangeScript.append(this.onChangeScript);
                onChangeScript.append(");}");
            }
            if (this.isDate()) {
                onChangeScript.append('}');
            }
        }
        return onChangeScript.toString();
    }

    private void initEditableTextField(XFormText t) {
        this.editableTextfield = new Input(this.getId());
        if (!t.passwordfield) {
            this.editableTextfield.setType("TEXT");
        } else {
            this.editableTextfield.setType("PASSWORD");
        }
        this.editableTextfield.setName(this.getHtmlAttString());
        this.editableTextfield.setHtmlId(this.getHtmlAttString());
        this.editableTextfield.setTabindex(this.getTabindex());
        if (t.getColqty() > 0) {
            this.editableTextfield.setSize(String.valueOf((int)((double)t.getColqty() * 1.2)));
        }
        this.editableTextfield.setReadOnly(!this.isEditable());
        this.onChangeScript = Boolean.toString(t.getOnChange() != null);
        this.editableTextfield.setOnChange(this.getOnChangeScript());
    }

    private void initNonEditableTextField(XFormText t) {
        this.nonEditableText = new Text();
        if (t.value != null) {
            this.nonEditableText.setText(this.componentDelegate.getNonEditableText(this.getLocale(), t.value.value_d, this.getKind()));
        }
        this.nonEditableDIV = new DIV(this.getId());
        this.nonEditableDIV.addChild(this.nonEditableText);
    }

    private void initTextField(XFormText t) {
        this.isDisplayAsLabel = t.displayaslabel;
        this.initEditableTextField(t);
        this.initNonEditableTextField(t);
        this.applyStyle();
        this.applyFocusPersistence();
    }
}

