/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLContainerElement;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.presentationComponents.ComponentIdFactory;
import oracle.bpm.xobject.runtime.presentationComponents.XOTableComponent;
import oracle.bpm.xobject.xhb.COL;
import oracle.bpm.xobject.xhb.ColGroup;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Table;

public class HTMLTable
extends HTMLContainerElement
implements XOTableComponent,
Cloneable {
    Table table;
    private List<HTMLElement> rows;

    public HTMLTable(XScreen xScreen, XFormTable t) {
        super(xScreen, t);
        this.initTable();
    }

    public static HTMLTable newInstance(HTMLTable originalElement) {
        HTMLTable newElement = new HTMLTable(originalElement.getXScreen(), (XFormTable)originalElement.getPresentationXMLObject());
        for (int i = 0; i < originalElement.rows.size(); ++i) {
            newElement.addElement((HTMLElement)originalElement.rows.get(i).clone());
        }
        return newElement;
    }

    @Override
    public Element getElement() {
        String id = ComponentIdFactory.buildComponentId(this.getId());
        DIV div = new DIV(id);
        div.setHtmlId(id);
        div.addChild(this.getPureElement());
        return div;
    }

    public void setAlign(String align) {
        if (align != null && !align.trim().equals("")) {
            this.table.setAlign(align);
        }
    }

    public void setBorder(String border) {
        if (border != null && !border.trim().equals("")) {
            this.table.setBorder(border);
        }
    }

    public void setCellPadding(String cellpadding) {
        if (cellpadding != null && !cellpadding.trim().equals("")) {
            this.table.setCellPadding(cellpadding);
        }
    }

    public void setCellSpacing(String cellspacing) {
        if (cellspacing != null && !cellspacing.trim().equals("")) {
            this.table.setCellSpacing(cellspacing);
        }
    }

    @Override
    public Element getPureElement() {
        return this.table;
    }

    @Override
    public String getStyle() {
        XFormTable xTable = (XFormTable)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineTopBorderCSS(xTable.topborderstyle, xTable.topbordercolor, xTable.topborderwidth));
            css.append(this.getInlineBottomBorderCSS(xTable.bottomborderstyle, xTable.bottombordercolor, xTable.bottomborderwidth));
            css.append(this.getInlineRightBorderCSS(xTable.rightborderstyle, xTable.rightbordercolor, xTable.rightborderwidth));
            css.append(this.getInlineLeftBorderCSS(xTable.leftborderstyle, xTable.leftbordercolor, xTable.leftborderwidth));
            if (this.hasBorder() && !this.isEditor()) {
                css.append(this.getInlineCollapseBorderCCS());
            }
        }
        return css.toString();
    }

    public void setWidth(String width) {
        if (width != null && !width.trim().equals("")) {
            this.table.setWidth(width);
        }
    }

    @Override
    public void _addElement(HTMLElement element) {
        this.rows.add(element);
        this.table.addChild(element.getElement());
    }

    public List getRows() {
        return this.rows;
    }

    @Override
    public Object clone() {
        return HTMLTable.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.table.setStyle(style);
        if (this.isCssEnabled()) {
            this.table.setCssClass(this.getCssClassName());
        } else {
            this.table.setCssClass("");
        }
    }

    private boolean hasBorder() {
        XFormTable xTable = (XFormTable)this.getPresentationXMLObject();
        return xTable.topborderstyle != null || xTable.bottomborderstyle != null || xTable.rightborderstyle != null || xTable.leftborderstyle != null;
    }

    private void initTable() {
        XFormTable xTable = (XFormTable)this.getPresentationXMLObject();
        this.table = new Table();
        this.setWidth(xTable.width);
        this.setAlign(xTable.alignment);
        this.setCellPadding(String.valueOf(xTable.cellpadding));
        this.setCellSpacing(String.valueOf(xTable.cellspacing));
        if (xTable.columnwidth != null) {
            ColGroup colGroup = new ColGroup();
            for (int i = 0; i < xTable.columnwidth.length; ++i) {
                String colWidth = xTable.columnwidth[i];
                COL col = new COL(String.valueOf(i));
                col.setWidth(colWidth);
                colGroup.addChild(col);
            }
            this.table.addChild(colGroup);
        }
        this.rows = new ArrayList<HTMLElement>();
        this.applyStyle();
    }
}

