/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import oracle.bpm.log.Log;
import oracle.bpm.util.Base64;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.html.HTMLPage;
import oracle.bpm.xobject.runtime.html.UrlBuilder;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XOImageComponent;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.IMG;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLImage
extends HTMLInputElement
implements XOImageComponent {
    byte[] imageData;
    private DIV browserDiv;
    private Text browserText;
    private TR browserTR;
    private IMG img;
    private Table imgTable;
    private String methodinvocation;

    public HTMLImage(XScreen xScreen, XFormImage xi) {
        super(xScreen, xi);
        this.initImage();
    }

    public static ImageInfo getImageData(XFormImage xi, String pageId, String screenId, int actionId, boolean isPreview, UrlBuilder builder) {
        byte[] imageBytes;
        if (xi != null && xi.gifencoded != null && !xi.gifencoded.trim().isEmpty()) {
            try {
                imageBytes = Base64.decode(xi.gifencoded);
            }
            catch (Throwable t) {
                Log.logWarning(t);
                return null;
            }
        } else {
            Log.logDebug(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_IMAGE_NULL);
            return null;
        }
        return HTMLImage.buildImageData(imageBytes, xi.getId(), xi.getName(), pageId, screenId, actionId, isPreview, builder, null);
    }

    public static HTMLImage newInstance(HTMLImage originalElement) {
        return new HTMLImage(originalElement.getXScreen(), (XFormImage)originalElement.getPresentationXMLObject());
    }

    public byte[] getBytes() {
        return this.imageData;
    }

    @Override
    public String getElementHtmlId() {
        return this.img.getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public int getMethodArgumentQty() {
        return 0;
    }

    @Override
    public String getMethodInvocation() {
        if (this.methodinvocation != null && !this.methodinvocation.trim().isEmpty()) {
            return this.methodinvocation;
        }
        return null;
    }

    @Override
    public void setName(String name) {
        if (this.img != null) {
            this.img.setName(name);
            this.img.setHtmlId(name);
            this.initBrowser();
        }
    }

    @Override
    public Element getPureElement() {
        return this.imgTable;
    }

    @Override
    public String getStyle() {
        XFormImage xImage = (XFormImage)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBorderCSS(xImage.borderstyle, xImage.bordercolor, xImage.borderwidth));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            String height = xImage.height;
            String width = xImage.width;
            if (width != null && !width.trim().isEmpty()) {
                css.append(this.getInlineWidthCSS(width));
            }
            if (height != null && !height.trim().isEmpty()) {
                css.append(this.getInlineHeightCSS(height));
            }
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    @Override
    public void setValue(Object value) {
        block8: {
            try {
                if (value == null || value instanceof String) {
                    this.imageData = null;
                } else if (value instanceof byte[]) {
                    this.imageData = (byte[])value;
                }
                XScreenHTMLImpl xScreenHTML = (XScreenHTMLImpl)this.getXScreen();
                XORuntimeManager runtimeManager = xScreenHTML.getRuntimeManager();
                UrlBuilder urlBuilder = runtimeManager.getUrlBuilder();
                ImageInfo imageInfo = this.imageData != null ? HTMLImage.buildImageData(this.imageData, this.getId(), this.getId(), xScreenHTML.getPage().getDocId(), xScreenHTML.getPage().getScreenId(), 6, this.isPreview(), urlBuilder, this.getElementHtmlId()) : HTMLImage.getImageData((XFormImage)this.getPresentationXMLObject(), xScreenHTML.getPage().getDocId(), xScreenHTML.getPage().getScreenId(), 6, this.isPreview(), urlBuilder);
                String src = "";
                if (imageInfo != null) {
                    this.imageData = imageInfo.getImageBytes();
                    src = imageInfo.getImageSrc();
                } else if (this.isEditor()) {
                    src = this.getImage(XObjectRuntimeMsg.BROKEN_IMAGE);
                }
                this.img.setSrc(src);
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block8;
                Log.logDebug(e);
            }
        }
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.parent_d != null) {
            this.initImageAction();
            this.applyStyle();
        }
    }

    public void addElement(HTMLElement element) {
        this.img.addChild(element.getElement());
    }

    @Override
    public boolean hasClick() {
        return this.getMethodInvocation() != null;
    }

    @Override
    public Object clone() {
        return HTMLImage.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        XFormImage xImage = (XFormImage)this.getPresentationXMLObject();
        if (this.imgTable != null) {
            this.imgTable.setStyle(style);
        }
        if (this.browserTR != null) {
            this.browserTR.setStyle(this.getInlineVisibilityCCS(this.getReference() != null && this.isEditable(), true));
        }
        if (this.browserDiv != null) {
            StringBuilder browserStyle = new StringBuilder();
            browserStyle.append("text-decoration: underline;");
            browserStyle.append(this.getInlineFontCCS(xImage.getFonttype(), xImage.getFontStyle(), xImage.getFontsize()));
            browserStyle.append(this.getInlineForegroundColorCCS(xImage.getFgcolor()));
            browserStyle.append(this.getInlineTextAlignmentCSS(xImage.getAlignment()));
            this.browserDiv.setStyle(browserStyle.toString());
        }
        if (this.isCssEnabled()) {
            this.imgTable.setCssClass(this.getCssClassName());
        } else {
            this.imgTable.setCssClass("");
        }
    }

    @Override
    protected void _setLink(String link) {
        this.initImageAction();
    }

    @Override
    protected void _setText(String text) {
        if (this.browserText != null) {
            this.browserText.setText(text);
        }
    }

    @Override
    void _setOnFocus(String js) {
    }

    @Override
    void initElementWithParent() {
        String src = "";
        XScreenHTMLImpl xScreenHTML = (XScreenHTMLImpl)this.getXScreen();
        HTMLPage page = xScreenHTML.getPage();
        XORuntimeManager runtimeManager = xScreenHTML.getRuntimeManager();
        ImageInfo imageInfo = HTMLImage.getImageData((XFormImage)this.getPresentationXMLObject(), page.getDocId(), page.getScreenId(), 6, this.isPreview(), runtimeManager.getUrlBuilder());
        if (imageInfo != null) {
            this.imageData = imageInfo.getImageBytes();
            src = imageInfo.getImageSrc();
        } else if (this.isEditor()) {
            src = this.getImage(XObjectRuntimeMsg.BROKEN_IMAGE);
        }
        this.img.setSrc(src);
    }

    private static ImageInfo buildImageData(byte[] imageBytes, String imageId, String imageName, String pageId, String screenId, int actionId, boolean isPreview, UrlBuilder builder, String htmlImageID) {
        if (imageBytes == null) {
            return null;
        }
        ImageInfo imageInfo = new ImageInfo();
        String ext = ".gif";
        if (imageBytes[0] == 71 && imageBytes[1] == 73 && imageBytes[2] == 70 && imageBytes[3] == 56) {
            ext = ".gif";
        } else if (imageBytes[0] == -1 && imageBytes[1] == -40) {
            ext = ".jpeg";
        } else if (imageBytes[1] == 80 && imageBytes[2] == 78 && imageBytes[3] == 71) {
            ext = ".png";
        } else {
            Log.logDebug(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_IMAGE_NON_SUPPORTED_ENCODING);
        }
        String imageSrc = "";
        if (isPreview) {
            try {
                if (imageId == null) {
                    imageId = String.valueOf(System.currentTimeMillis());
                }
                File index = File.createTempFile(imageId, ext);
                index.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(index);
                fos.write(imageBytes);
                fos.close();
                imageSrc = index.toURI().toURL().getPath();
            }
            catch (IOException ioe) {
                Log.logWarning(ioe);
            }
        } else {
            Properties params = new Properties();
            if (imageId != null) {
                params.setProperty("xo$AttName", imageId);
            }
            params.setProperty("xo$DocSessKey", pageId);
            params.setProperty("xo$ScreenSessKey", screenId);
            if (htmlImageID != null && htmlImageID.length() > 0) {
                params.setProperty("htmlImageId", htmlImageID);
            }
            StringBuilder dummyValue = new StringBuilder();
            dummyValue.append(imageBytes.length);
            for (int i = 0; i < 5 && i < imageBytes.length; ++i) {
                byte imageByte = imageBytes[i];
                dummyValue.append(imageByte);
            }
            params.setProperty("xo$dummy", dummyValue.toString());
            imageSrc = builder.htmlImageControllerCall(actionId, params);
        }
        imageInfo.setImageBytes(imageBytes);
        imageInfo.setImageSrc(imageSrc);
        imageInfo.setImageName(imageName);
        imageInfo.setImageExtension(ext);
        return imageInfo;
    }

    private String getBrowserUrl(String pageId, String screenId) {
        String onChange;
        Properties params = new Properties();
        params.setProperty("xo$DocSessKey", pageId);
        params.setProperty("xo$ScreenSessKey", screenId);
        String dataId = this.getReference();
        if (dataId != null) {
            params.setProperty("xo$FileChooserDataId", this.img.getAttribute(Element.ID_PROPERTY));
        }
        if ((onChange = ((XFormImage)this.getPresentationXMLObject()).getOnChange()) != null) {
            params.setProperty("xo$FileChooserOnChange", this.img.getAttribute(Element.ID_PROPERTY));
        }
        return this.getXScreen().getRuntimeManager().getUrlBuilder().htmlFileChooserControllerCall(params);
    }

    private void addOnClickEvent(String script) {
        if (this.areEventsAllowed() && this.img != null && script != null && !script.trim().equals("")) {
            this.img.setOnClick(script);
        }
    }

    private void initBrowser() {
        String browserTextStr = ((XFormImage)this.getPresentationXMLObject()).display;
        Locale locale = this.getXScreen().getRuntimeManager().getLocale();
        browserTextStr = browserTextStr != null && browserTextStr.trim().length() > 0 ? browserTextStr : XObjectRuntimeMsg.CHANGE.getString(locale);
        this.setText(browserTextStr);
        if (!this.isPreview()) {
            StringBuilder browserOnClickScript = new StringBuilder();
            browserOnClickScript.append("window.open('");
            browserOnClickScript.append(this.getBrowserUrl(((XScreenHTMLImpl)this.getXScreen()).getPage().getDocId(), ((XScreenHTMLImpl)this.getXScreen()).getPage().getScreenId()));
            browserOnClickScript.append("', 'fofilechooser', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=auto,resizable,modal,titlebar=no,width=300,height=100')");
            this.browserDiv.setOnClick(browserOnClickScript.toString());
            this.browserDiv.setOnMouseOver("if(isActionInProgress()){this.style.cursor = 'wait'}else{this.style.cursor = 'pointer'}");
            this.browserDiv.setOnMouseOut("this.style.cursor = 'auto'");
        }
    }

    private void initImage() {
        XFormImage xi = (XFormImage)this.getPresentationXMLObject();
        this.img = new IMG();
        this.img.setSrc("");
        this.img.setName(this.getHtmlAttString());
        this.img.setBorder(0);
        this.img.setHtmlId(this.getHtmlAttString());
        this.imgTable = new Table();
        TR imgTr = new TR();
        TD imgTd = new TD();
        this.browserTR = new TR();
        TD browserTd = new TD();
        this.browserDiv = new DIV();
        this.browserText = new Text();
        imgTd.addChild(this.img);
        imgTr.addChild(imgTd);
        this.imgTable.addChild(imgTr);
        browserTd.addChild(this.browserDiv);
        this.browserDiv.addChild(this.browserText);
        this.browserTR.addChild(browserTd);
        this.imgTable.addChild(this.browserTR);
        this.methodinvocation = xi.getOnclick();
        this.initImageAction();
        this.initBrowser();
        this.applyStyle();
        this.applyFocusPersistence();
    }

    private void initImageAction() {
        StringBuilder onClickScriptBuffer = new StringBuilder();
        boolean hasAction = false;
        if (this.getLink() != null) {
            String url = this.getLink();
            if (url.toLowerCase().startsWith("mailto:")) {
                onClickScriptBuffer.append("parent.location='");
                onClickScriptBuffer.append(url);
                onClickScriptBuffer.append('\'');
            } else {
                onClickScriptBuffer.append("window.open('");
                onClickScriptBuffer.append(url);
                onClickScriptBuffer.append("', '_blank'");
                XFormImage xImage = (XFormImage)this.getPresentationXMLObject();
                if (!xImage.isFullBrowser()) {
                    onClickScriptBuffer.append(", 'resizable,scrollbars'");
                }
                onClickScriptBuffer.append(')');
            }
            this.img.setTitle(url);
            hasAction = true;
        } else if (this.areEventsAllowed() && this.getMethodInvocation() != null) {
            this.img.removeAttribute(Element.TITLE_PROPERTY);
            onClickScriptBuffer.append("this.style.cursor = 'wait';doXoAction(");
            onClickScriptBuffer.append(14);
            onClickScriptBuffer.append(", this.name);");
            hasAction = true;
        }
        if (hasAction) {
            this.addOnClickEvent(onClickScriptBuffer.toString());
            if (!this.isPreview()) {
                this.img.setOnMouseOver("if(isActionInProgress()){this.style.cursor = 'wait'}else{this.style.cursor = 'pointer'}");
            } else {
                this.img.setOnMouseOver("this.style.cursor = 'pointer'");
            }
            this.img.setOnMouseOut("this.style.cursor = 'auto'");
        } else {
            this.removeOnClickEvent();
            this.img.removeAttribute(Element.TITLE_PROPERTY);
            this.img.setOnMouseOver("this.style.cursor = 'auto'");
            this.img.setOnMouseOut("this.style.cursor = 'auto'");
        }
    }

    private void removeOnClickEvent() {
        if (this.img != null) {
            this.img.removeAttribute(Element.ON_CLICK);
        }
    }

    public static class ImageInfo {
        private byte[] imageBytes;
        private String imageExtension;
        private String imageName;
        private String imageSrc;

        public void setImageBytes(byte[] imageBytes) {
            this.imageBytes = imageBytes;
        }

        public byte[] getImageBytes() {
            return this.imageBytes;
        }

        public void setImageExtension(String imageExtension) {
            this.imageExtension = imageExtension;
        }

        public String getImageExtension() {
            return this.imageExtension;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageSrc(String imageSrc) {
            this.imageSrc = imageSrc;
        }

        public String getImageSrc() {
            return this.imageSrc;
        }
    }
}

