/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.data.html.TextType;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormIframe;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLComponentElement;
import oracle.bpm.xobject.runtime.presentationComponents.RefreshableComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.IFrame;

public class HTMLIFrame
extends HTMLComponentElement
implements XOPresentationComponent,
Cloneable,
RefreshableComponent {
    private IFrame iframe;
    private TextType srcType;

    public HTMLIFrame(XScreen xScreen, XFormIframe xiframe) {
        super(xScreen, xiframe);
        this.srcType = xiframe.getSrctype() != null ? TextType.valueOf(xiframe.getSrctype()) : TextType.DEFAULT;
        this.initIFrame();
    }

    @Override
    public void setName(String name) {
        this.iframe.setName(name);
        this.iframe.setHtmlId(name);
    }

    @Override
    public Element getPureElement() {
        return this.iframe;
    }

    @Override
    public String getStyle() {
        XFormIframe xiframe = (XFormIframe)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineBorderCSS(xiframe.borderstyle, xiframe.bordercolor, xiframe.borderwidth));
            css.append(this.getInlineWidthCSS(xiframe.getWidth()));
            css.append(this.getInlineHeightCSS(xiframe.getHeight()));
        }
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
    }

    public TextType getTextType() {
        if (this.srcType == null) {
            this.srcType = TextType.DEFAULT;
        }
        return this.srcType;
    }

    @Override
    public void refresh(XObjectInstance xo) {
        boolean dirty;
        XFormIframe xiframe;
        String dataId;
        if (this.isReference() && (dataId = (xiframe = (XFormIframe)this.getPresentationXMLObject()).getSrc()) != null && (dirty = xo.isDirty(dataId))) {
            this.initIFrameSrc();
        }
    }

    @Override
    protected void _applyStyle(String style) {
        if (this.iframe != null) {
            this.iframe.setStyle(style);
            if (this.isCssEnabled()) {
                this.iframe.setCssClass(this.getCssClassName());
            } else {
                this.iframe.setCssClass("");
            }
        }
    }

    @Override
    protected void _setText(String text) {
        if (this.iframe != null) {
            this.iframe.setSrc(text);
        }
    }

    protected void initIFrame() {
        XFormIframe xiframe = (XFormIframe)this.getPresentationXMLObject();
        this.iframe = new IFrame();
        this.iframe.setScrolling(xiframe.getScrolling());
        this.initIFrameSrc();
        this.applyStyle();
    }

    @Override
    void _setOnFocus(String js) {
        throw new IllegalArgumentException("Cannot set onFocus to link");
    }

    private void initIFrameSrc() {
        try {
            this.iframe.setSrc(this.getSrcValue());
        }
        catch (InvalidXOAttributeException e) {
            Log.logWarning(e);
        }
    }

    private boolean isReference() {
        return TextType.REFERENCE.equals(this.getTextType());
    }

    private String getSrcValue() throws InvalidXOAttributeException {
        String currentValue;
        String dataId;
        XFormIframe xiframe = (XFormIframe)this.getPresentationXMLObject();
        String result = this.isReference() ? ((dataId = xiframe.getSrc()) != null && !this.isEditor() ? (String)this.getXScreen().getXO().getAttributeValue(dataId) : null) : (this.iframe != null ? ((currentValue = this.iframe.getAttribute("src")) != null ? currentValue : xiframe.getSrc()) : xiframe.getSrc());
        return result;
    }
}

