/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.xobject.lib.chart.DummyDataSourceFactory;
import oracle.bpm.xobject.lib.chart.FusionChartXmlFactory;
import oracle.bpm.xobject.lib.chart.FusionChartsCreator;
import oracle.bpm.xobject.lib.chart.Range;
import oracle.bpm.xobject.lib.chart.RangeKind;
import oracle.bpm.xobject.lib.chart.SwfFactory;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.runtime.XObjectInternalException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLGraphic;
import oracle.bpm.xobject.runtime.presentationComponents.XOGaugeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOGaugeComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XOGraphicComponentDelegate;

public class HTMLGauge
extends HTMLGraphic
implements XOGaugeComponent,
Cloneable {
    private XOGaugeComponentDelegate componentDelegate;
    private Range[] ranges = new Range[RangeKind.values().length];
    private String unit;

    public HTMLGauge(XScreen xScreen, XFormGauge xFormGauge) {
        super(xScreen, xFormGauge);
        this.initGauge(xFormGauge);
        this.componentDelegate = new XOGaugeComponentDelegate(this);
        if (this.hasDynamicType()) {
            this.loadGraphicTypes();
        }
        try {
            this.refreshImage();
        }
        catch (XObjectInternalException e) {
            e.printStackTrace();
        }
    }

    public static HTMLGauge newInstance(HTMLGauge originalElement) {
        return new HTMLGauge(originalElement.getXScreen(), (XFormGauge)originalElement.getPresentationXMLObject());
    }

    @Override
    public void changeGaugeRange(RangeKind rangeKind, Range range) {
        if (range != null && !range.equals(this.getRange(rangeKind))) {
            this.setRange(rangeKind, range);
            this.recreateGraphic();
        }
    }

    @Override
    public String getSWF(SwfFactory swfFactory) {
        return swfFactory.getSwf(this);
    }

    @Override
    public Object clone() {
        return HTMLGauge.newInstance(this);
    }

    @Override
    public Range getRange(RangeKind rangeKind) {
        return this.ranges[rangeKind.ordinal()];
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setRange(RangeKind rangeKind, Range range) {
        this.ranges[rangeKind.ordinal()] = range;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public String getDummyDataSourceXml() {
        return FusionChartXmlFactory.getFusionChartData(DummyDataSourceFactory.createDummyGaugeDataSource(), this);
    }

    @Override
    protected XOGraphicComponentDelegate.GraphicComponentInfo getGraphicComponentInfo() throws XObjectInternalException {
        return this.componentDelegate.getGraphicComponentInfo();
    }

    @Override
    protected XOGraphicComponentDelegate getXOGraphicComponentDelegate() {
        return this.componentDelegate;
    }

    @Override
    protected String buildGraphicScript(String dataUrl) {
        return FusionChartsCreator.createChart(this, dataUrl);
    }

    private void initGauge(XFormGauge xGauge) {
        this.setRange(RangeKind.CRITICAL_RANGE, new Range(xGauge.getAlarm_level(), xGauge.getAlarm_level_max()));
        this.setRange(RangeKind.NORMAL_RANGE, new Range(xGauge.getNormal_level(), xGauge.getNormal_level_max()));
        this.setRange(RangeKind.COMPLETE_RANGE, new Range(xGauge.getMin_limit(), xGauge.getMax_limit()));
        this.setRange(RangeKind.WARNING_RANGE, new Range(xGauge.getWarning_level(), xGauge.getWarning_level_max()));
        this.setUnit(xGauge.getUnit());
    }
}

