/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.util.DateFormatSymbolUtils;
import oracle.bpm.xobject.presentationmodel.XFormDatetimepiker;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLInputElement;
import oracle.bpm.xobject.runtime.html.XScreenHTMLImpl;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimePickerComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimePickerComponentDelegate;
import oracle.bpm.xobject.xhb.A;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.IMG;
import oracle.bpm.xobject.xhb.Input;
import oracle.bpm.xobject.xhb.Option;
import oracle.bpm.xobject.xhb.Select;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLDateTimePicker
extends HTMLInputElement
implements XODateTimePickerComponent,
XODateTimeComponent {
    A anchor;
    Input dateInput;
    Text dateString;
    Select hourCombo;
    IMG image;
    Select minuteCombo;
    String onChangeScript;
    Table pickerTable;
    TD td;
    Text timeString;
    TR tr;
    String value;
    Input valueHidden;
    private final XODateTimePickerComponentDelegate componentDelegate;
    private final XODateTimeComponentDelegate dateComponentDelegate;
    private static final String[] MINUTES = new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    public static final String EDITABLE = "EDITABLE";
    public static final String NON_EDITABLE = "NON_EDITABLE";
    public static final String DATE_PRES_ID = "$date$";
    public static final String HOUR_PRES_ID = "$hour$";
    public static final String MINUTE_PRES_ID = "$minute$";

    public HTMLDateTimePicker(XScreen xScreen, XFormDatetimepiker picker, Locale locale, TimeZone tz) {
        super(xScreen, picker);
        ((XScreenHTMLImpl)xScreen).getPage().initPageWithDateTimeElement(locale, tz);
        this.dateComponentDelegate = new XODateTimeComponentDelegate(this, locale, tz);
        this.initDatePicker();
        this.componentDelegate = new XODateTimePickerComponentDelegate(this);
    }

    public static HTMLDateTimePicker newInstance(HTMLDateTimePicker originalElement) {
        HTMLDateTimePicker newElement = new HTMLDateTimePicker(originalElement.getXScreen(), (XFormDatetimepiker)originalElement.getPresentationXMLObject(), originalElement.getLocale(), originalElement.getTimeZone());
        newElement.restrict(originalElement.getDatePrecision(), originalElement.isAbsoluteDate());
        newElement.setValue(originalElement.getDefaultValue());
        return newElement;
    }

    @Override
    public boolean isAbsoluteDate() {
        return this.dateComponentDelegate.isAbsoluteDate();
    }

    @Override
    public boolean isDate() {
        return this.dateComponentDelegate.isDate();
    }

    @Override
    public int getDatePrecision() {
        return this.dateComponentDelegate.getDatePrecision();
    }

    @Override
    public String getElementHtmlId() {
        return this.isDate() ? this.dateInput.getAttribute(Element.ID_PROPERTY) : this.hourCombo.getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public String getFormatString() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.dateComponentDelegate.getLocale();
    }

    @Override
    public void setName(String name) {
        if (this.valueHidden != null) {
            this.valueHidden.setName(name);
            this.valueHidden.setHtmlId(name);
        }
        this.setScripts(name);
    }

    @Override
    public Element getPureElement() {
        if (!this.isPreview()) {
            this.valueHidden.setOnChange("valueChanged(this.name, " + this.onChangeScript + ')');
        }
        return this.pickerTable;
    }

    public void setScripts(String name) {
        this.dateInput.setName(DATE_PRES_ID + name);
        this.dateInput.setHtmlId(DATE_PRES_ID + name);
        this.hourCombo.setName(HOUR_PRES_ID + name);
        this.hourCombo.setHtmlId(HOUR_PRES_ID + name);
        this.minuteCombo.setName(MINUTE_PRES_ID + name);
        this.minuteCombo.setHtmlId(MINUTE_PRES_ID + name);
        if (!this.isPreview() && this.isEditable()) {
            XFormDatetimepiker xDateTimePicker = (XFormDatetimepiker)this.getPresentationXMLObject();
            String pattern = DateFormatSymbolUtils.getSimpleFuegoDatePattern(this.getLocale());
            this.dateInput.setAlt(pattern);
            this.dateInput.setTitle(pattern);
            StringBuilder anchorScriptBuffer = new StringBuilder();
            anchorScriptBuffer.append(xDateTimePicker.isDhtmlcalendar() ? "calendar" : "popupcalendar");
            anchorScriptBuffer.append(".fuegoObjectSelect(document.xobjectForm.");
            anchorScriptBuffer.append(DATE_PRES_ID);
            anchorScriptBuffer.append(name);
            anchorScriptBuffer.append(",'anchor_");
            anchorScriptBuffer.append(this.getId());
            anchorScriptBuffer.append("','");
            anchorScriptBuffer.append(pattern);
            anchorScriptBuffer.append("', ");
            anchorScriptBuffer.append(this.onChangeScript);
            anchorScriptBuffer.append(");return false;");
            if (!xDateTimePicker.isCalendartabenabled()) {
                this.image.setOnClick(anchorScriptBuffer.toString());
                this.image.setOnMouseOver("this.style.cursor='pointer'");
                this.image.setOnMouseOut("this.style.cursor='default'");
            } else {
                this.anchor.setHref("#");
                this.anchor.setOnClick(anchorScriptBuffer.toString());
            }
            this.anchor.setName("anchor_" + this.getId());
            this.anchor.setHtmlId("anchor_" + this.getId());
            StringBuilder scriptBuffer = new StringBuilder();
            switch (this.getDatePrecision()) {
                case 0: {
                    scriptBuffer.append("if(performInlineValidation(isFObjectDate(document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value, '");
                    scriptBuffer.append(pattern);
                    scriptBuffer.append("'), '");
                    scriptBuffer.append(this.escape(XObjectRuntimeMsg.INVALID_DATE_FORMAT(pattern).getString(this.getLocale()), true));
                    scriptBuffer.append("', this.style.bgcolor, document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    if (!this.isClientErrorAsPopup()) {
                        scriptBuffer.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    scriptBuffer.append(")){document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value='");
                    scriptBuffer.append(EDITABLE);
                    scriptBuffer.append("$'+document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value;");
                    scriptBuffer.append("valueChanged(document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".name, ");
                    scriptBuffer.append(this.onChangeScript);
                    scriptBuffer.append(")}");
                    this.dateInput.setOnChange(scriptBuffer.toString());
                    break;
                }
                case 1: {
                    scriptBuffer.append("document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value='");
                    scriptBuffer.append(EDITABLE);
                    scriptBuffer.append("$'+document.xobjectForm.");
                    scriptBuffer.append(HOUR_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".options[document.xobjectForm.");
                    scriptBuffer.append(HOUR_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".selectedIndex].value+'$'+document.xobjectForm.");
                    scriptBuffer.append(MINUTE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".options[document.xobjectForm.");
                    scriptBuffer.append(MINUTE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".selectedIndex].value;");
                    scriptBuffer.append("valueChanged(document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".name, ");
                    scriptBuffer.append(this.onChangeScript);
                    scriptBuffer.append(");");
                    this.hourCombo.setOnChange(scriptBuffer.toString());
                    this.minuteCombo.setOnChange(scriptBuffer.toString());
                    break;
                }
                default: {
                    scriptBuffer.append("if(performInlineValidation(isFObjectDate(document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value, '");
                    scriptBuffer.append(pattern);
                    scriptBuffer.append("'), '");
                    scriptBuffer.append(this.escape(XObjectRuntimeMsg.INVALID_DATE_FORMAT(pattern).getString(this.getLocale()), true));
                    scriptBuffer.append("', this.style.bgcolor, document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    if (!this.isClientErrorAsPopup()) {
                        scriptBuffer.append(", 'fo.clientErrorContainer', 'fo.clientErrorMsg'");
                    }
                    scriptBuffer.append(")){document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value='");
                    scriptBuffer.append(EDITABLE);
                    scriptBuffer.append("$'+document.xobjectForm.");
                    scriptBuffer.append(DATE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".value+'$'+document.xobjectForm.");
                    scriptBuffer.append(HOUR_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".options[document.xobjectForm.");
                    scriptBuffer.append(HOUR_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".selectedIndex].value+'$'+document.xobjectForm.");
                    scriptBuffer.append(MINUTE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".options[document.xobjectForm.");
                    scriptBuffer.append(MINUTE_PRES_ID);
                    scriptBuffer.append(name);
                    scriptBuffer.append(".selectedIndex].value;valueChanged(document.xobjectForm.");
                    scriptBuffer.append(name);
                    scriptBuffer.append(".name, ");
                    scriptBuffer.append(this.onChangeScript);
                    scriptBuffer.append(")}");
                    this.dateInput.setOnChange(scriptBuffer.toString());
                    this.hourCombo.setOnChange(scriptBuffer.toString());
                    this.minuteCombo.setOnChange(scriptBuffer.toString());
                }
            }
        }
    }

    @Override
    public String getStyle() {
        return this.getStyle(true);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.dateInput != null) {
            this.dateInput.setTabindex(tabIndex);
        }
        if (this.hourCombo != null) {
            this.hourCombo.setTabindex(String.valueOf(tabIndex));
        }
        if (this.minuteCombo != null) {
            this.minuteCombo.setTabindex(String.valueOf(tabIndex));
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this.dateComponentDelegate.getTimeZone();
    }

    @Override
    public void setValue(Object value) {
        block9: {
            try {
                String valueStr;
                this.value = valueStr = this.componentDelegate.convertToString(value);
                String dateStr = "";
                String hourStr = "-1";
                String minuteStr = "-1";
                String hiddenValueStr = "";
                String formatedTime = "";
                if (valueStr != null && !valueStr.trim().isEmpty()) {
                    Time fullDate = Time.valueOf(valueStr);
                    if (this.isAbsoluteDate()) {
                        fullDate = fullDate.fromGMT();
                    }
                    dateStr = this.dateComponentDelegate.convertDataValueToPresentationValue(fullDate, DateFormatSymbolUtils.getSimpleFuegoDatePattern(this.getLocale()));
                    hourStr = this.dateComponentDelegate.convertDataValueToPresentationValue(fullDate, "H");
                    minuteStr = this.dateComponentDelegate.convertDataValueToPresentationValue(fullDate, "mm");
                    if (this.isEditable()) {
                        int minute = fullDate.getMinute();
                        minuteStr = String.valueOf((minute /= 5) * 5);
                        if (minute * 5 < 10) {
                            minuteStr = '0' + minuteStr;
                        }
                        hiddenValueStr = "EDITABLE$" + dateStr + '$' + hourStr + '$' + minuteStr;
                    } else {
                        Time time = Time.valueOf(hourStr + ':' + minuteStr);
                        formatedTime = this.dateComponentDelegate.convertDataValueToPresentationValue(time, DateFormatSymbolUtils.getSimpleFuegoTimePattern(this.getLocale()));
                        hiddenValueStr = "NON_EDITABLE$" + valueStr;
                    }
                }
                this.valueHidden.setValue(hiddenValueStr);
                if (this.isEditable()) {
                    this.dateInput.setValue(dateStr);
                    HTMLDateTimePicker.setCombo(this.hourCombo.getAllChilds(), hourStr);
                    HTMLDateTimePicker.setCombo(this.minuteCombo.getAllChilds(), minuteStr);
                } else {
                    this.dateString.setText(dateStr);
                    this.timeString.setText(formatedTime);
                    this.restrict(this.getPrecision(), this.isAbsoluteDate());
                }
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                this.getXScreen().showWarning(XObjectRuntimeMsg.RUNTIME_DATEPICKER_SET_ERROR.getString());
                if (!Log.isDebugging()) break block9;
                Log.logDebug(e);
            }
        }
    }

    @Override
    public void _setEditable(boolean editable) {
        if (this.pickerTable != null) {
            this.restrict(this.getDatePrecision(), this.isAbsoluteDate());
            this.setValue(this.value);
        }
    }

    @Override
    public String convertDataValueToPresentationValue(Time time) {
        return this.dateComponentDelegate.convertDataValueToPresentationValue(time);
    }

    @Override
    public String convertPresentationValueToDataValue(String value) throws ParseException {
        return this.dateComponentDelegate.convertPresentationValueToDataValue(value);
    }

    public void initDatePicker() {
        Option option;
        boolean isRequired;
        block7: {
            isRequired = false;
            try {
                if (!this.isPreview()) {
                    isRequired = this.getXScreen().getXO().isAttributeRequired(this.getReference());
                }
            }
            catch (InvalidXOAttributeException e) {
                if (!Log.isDebugging()) break block7;
                Log.logDebug(e);
            }
        }
        XFormDatetimepiker picker = (XFormDatetimepiker)this.getPresentationXMLObject();
        this.pickerTable = new Table();
        this.pickerTable.setBorder("0");
        this.pickerTable.setCellPadding("0");
        this.pickerTable.setCellSpacing("0");
        this.tr = new TR();
        this.td = HTMLDateTimePicker.getDateTD();
        this.valueHidden = new Input();
        this.valueHidden.setType("HIDDEN");
        this.valueHidden.setName(this.getHtmlAttString());
        this.valueHidden.setHtmlId(this.getHtmlAttString());
        this.valueHidden.setValue("");
        this.dateInput = new Input();
        this.dateInput.setType("TEXT");
        this.dateInput.setValue("");
        this.dateInput.setMaxlength("10");
        this.dateInput.setSize("10");
        this.dateInput.setTabindex(this.getTabindex());
        this.image = new IMG();
        this.image.setSrc(this.getImage(XObjectRuntimeMsg.CALENDAR));
        this.image.setBorder(0);
        this.anchor = new A();
        this.anchor.setOnClick("return " + (!this.isPreview() && picker.editable));
        this.anchor.addChild(this.image);
        String[][] hours = DateFormatSymbolUtils.getLocalizedHours(this.getLocale());
        this.hourCombo = new Select();
        if (!isRequired) {
            Option option2 = new Option("-1");
            option2.setValue("-1");
            option2.addChild(new Text(""));
            this.hourCombo.addChild(option2);
        }
        for (int i = 0; i < hours.length; ++i) {
            option = new Option(String.valueOf(i));
            option.setValue(String.valueOf(hours[i][1]));
            option.addChild(new Text(String.valueOf(i), String.valueOf(hours[i][0])));
            this.hourCombo.addChild(option);
        }
        this.hourCombo.setDisabled(!picker.editable);
        this.hourCombo.setTabindex(String.valueOf(this.getTabindex()));
        this.minuteCombo = new Select();
        if (!isRequired) {
            Option option3 = new Option("-1");
            option3.setValue("-1");
            option3.addChild(new Text(""));
            this.minuteCombo.addChild(option3);
        }
        for (int i = 0; i < MINUTES.length; ++i) {
            option = new Option(MINUTES[i]);
            option.setValue(MINUTES[i]);
            option.addChild(new Text(String.valueOf(i), MINUTES[i]));
            this.minuteCombo.addChild(option);
        }
        this.minuteCombo.setDisabled(!picker.editable);
        this.minuteCombo.setTabindex(String.valueOf(this.getTabindex()));
        this.dateString = new Text("dateString_d");
        this.timeString = new Text("timeString_d");
        this.onChangeScript = Boolean.toString(picker.getOnChange() != null);
        this.setScripts(this.getHtmlAttString());
        this.td.addChild(this.valueHidden);
        this.tr.addChild(this.td);
        this.pickerTable.addChild(this.tr);
        this.applyStyle();
        this.applyFocusPersistence();
    }

    @Override
    public Object clone() {
        return HTMLDateTimePicker.newInstance(this);
    }

    @Override
    public void restrict(int precision, boolean isAbsolute) {
        this.dateComponentDelegate.restrict(precision, isAbsolute);
        this.tr.removeChild(this.td);
        this.td = HTMLDateTimePicker.getDateTD();
        this.td.addChild(this.valueHidden);
        switch (this.getDatePrecision()) {
            case 0: {
                if (this.isEditable()) {
                    this.td.addChild(this.dateInput);
                    this.td.addChild(this.anchor);
                    break;
                }
                this.td.addChild(this.dateString);
                break;
            }
            case 1: {
                if (this.isEditable()) {
                    this.td.addChild(this.hourCombo);
                    this.td.addChild(new Text(":", ":"));
                    this.td.addChild(this.minuteCombo);
                    break;
                }
                this.td.addChild(this.timeString);
                break;
            }
            default: {
                if (this.isEditable()) {
                    this.td.addChild(this.dateInput);
                    this.td.addChild(this.anchor);
                    this.td.addChild(this.hourCombo);
                    this.td.addChild(new Text(":", ":"));
                    this.td.addChild(this.minuteCombo);
                    break;
                }
                this.td.addChild(this.dateString);
                this.td.addChild(new Text("separator"));
                this.td.addChild(this.timeString);
            }
        }
        this.setScripts(this.valueHidden.getAttribute("name"));
        this.tr.addChild(this.td);
        this.applyStyle();
    }

    @Override
    protected void _applyStyle(String style) {
        this.td.setStyle(style);
        style = this.getStyle(false);
        this.dateInput.setStyle(style);
        this.hourCombo.setStyle(style);
        this.minuteCombo.setStyle(style);
        if (this.isCssEnabled()) {
            this.dateInput.setCssClass(this.getCssClassName());
            this.hourCombo.setCssClass(this.getCssClassName());
            this.minuteCombo.setCssClass(this.getCssClassName());
            this.td.setCssClass(this.getCssClassName());
        } else {
            this.dateInput.setCssClass("");
            this.hourCombo.setCssClass("");
            this.minuteCombo.setCssClass("");
            this.td.setCssClass("");
        }
    }

    @Override
    int getDefaultPrecision() {
        return 2;
    }

    @Override
    void _setOnFocus(String js) {
        this.dateInput.setOnFocus(js);
        this.anchor.setOnFocus(js);
        this.hourCombo.setOnFocus(js);
        this.minuteCombo.setOnFocus(js);
    }

    private static void setCombo(Iterator it, String targetValue) {
        while (it.hasNext()) {
            Option item = (Option)it.next();
            String optionValue = item.getAttribute("value");
            if (optionValue.equals(targetValue)) {
                item.setSelected(true);
                continue;
            }
            item.setSelected(false);
        }
    }

    private static TD getDateTD() {
        TD td = new TD();
        td.setAlign("left");
        td.setVAlign("middle");
        td.setNoWrap(true);
        return td;
    }

    private String getStyle(boolean hasBorder) {
        XFormDatetimepiker t = (XFormDatetimepiker)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(t.fonttype, t.getFontStyle(), t.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
            if (hasBorder && this.isEditable()) {
                css.append(this.getInlineBorderCSS(t.borderstyle, t.bordercolor, t.borderwidth));
            }
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }
}

