/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormCombo;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLMultivaluatedElement;
import oracle.bpm.xobject.runtime.presentationComponents.XOComboBoxComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOComboBoxComponentDelegate;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XODateTimeComponentDelegate;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.Option;
import oracle.bpm.xobject.xhb.Select;
import oracle.bpm.xobject.xhb.TD;
import oracle.bpm.xobject.xhb.TR;
import oracle.bpm.xobject.xhb.Table;
import oracle.bpm.xobject.xhb.Text;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class HTMLComboBox
extends HTMLMultivaluatedElement
implements XOComboBoxComponent,
XODateTimeComponent {
    private Select combo_d;
    private final XOComboBoxComponentDelegate componentDelegate;
    private final XODateTimeComponentDelegate dateComponentDelegate;
    private Text nonEditableText;
    private String onChangeScript;
    private Table sTable;
    private TD sTD_d;

    public HTMLComboBox(XScreen xScreen, XFormCombo c, Locale locale, TimeZone tz) {
        super(xScreen, c);
        this.dateComponentDelegate = new XODateTimeComponentDelegate(this, locale, tz);
        this.initComboBox();
        this.componentDelegate = new XOComboBoxComponentDelegate(this);
    }

    public static HTMLComboBox newInstance(HTMLComboBox originalElement) {
        Object[][] vv;
        HTMLComboBox newElement = new HTMLComboBox(originalElement.getXScreen(), (XFormCombo)originalElement.getPresentationXMLObject(), originalElement.getLocale(), originalElement.getTimeZone());
        if (originalElement.isDate()) {
            newElement.restrict(originalElement.getPrecision(), originalElement.isAbsoluteDate());
        }
        if ((vv = originalElement.getValidValues()) != null && vv.length == 2) {
            newElement.setValidValues(vv[0], vv[1]);
        }
        newElement.setValue(originalElement.getDefaultValue());
        return newElement;
    }

    @Override
    public boolean isAbsoluteDate() {
        return this.dateComponentDelegate.isAbsoluteDate();
    }

    @Override
    public int getDatePrecision() {
        return this.dateComponentDelegate.getDatePrecision();
    }

    @Override
    public String getElementHtmlId() {
        return this.combo_d.getAttribute(Element.ID_PROPERTY);
    }

    @Override
    public String getFormatString() {
        return null;
    }

    @Override
    public Locale getLocale() {
        return this.dateComponentDelegate.getLocale();
    }

    @Override
    public void setName(String name) {
        if (this.combo_d != null) {
            this.combo_d.setName(name);
            this.combo_d.setHtmlId(name);
        }
    }

    @Override
    public Element getPureElement() {
        if (this.isEditable()) {
            if (!this.isPreview()) {
                this.combo_d.setOnChange("valueChanged(this.name, " + this.onChangeScript + ");");
            }
            return this.combo_d;
        }
        return this.sTable;
    }

    @Override
    public String getStyle() {
        XFormCombo xCombo = (XFormCombo)this.getPresentationXMLObject();
        StringBuilder css = new StringBuilder();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xCombo.fonttype, xCombo.getFontStyle(), xCombo.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.getBackgroundColor()));
            css.append(this.getInlineForegroundColorCCS(this.getForegroundColor()));
        }
        css.append(this.getInlineVisibilityCCS(this.isVisible(), this.isVisibleCollapsed()));
        return css.toString();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.combo_d != null) {
            this.combo_d.setTabindex(String.valueOf(tabIndex));
        }
    }

    @Override
    public TimeZone getTimeZone() {
        return this.dateComponentDelegate.getTimeZone();
    }

    @Override
    public Object[][] getValidValues() {
        return this.componentDelegate.getValidValues();
    }

    @Override
    public void setValue(Object value) {
        block2: {
            try {
                this.setSelectedOption(this.componentDelegate.convertToString(value));
            }
            catch (Exception e) {
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_SET_VALUE_PROBLEM(String.valueOf(value), this.getId()));
                if (!Log.isDebugging()) break block2;
                Log.logDebug(e);
            }
        }
    }

    public void _setDefaultValue(Object value) {
        this.setSelectedOption((String)value);
    }

    @Override
    public void _setValidValues(Object[] values, Object[] presValues) {
        assert (values == presValues || values != null && presValues != null && presValues.length == values.length);
        if (values != null) {
            String[] strValues = ConversionUtilities.convertToString(values);
            String[] labels = ConversionUtilities.convertToString(presValues);
            if (this.isDate()) {
                for (int i = 0; i < values.length; ++i) {
                    long microseconds = this.dateComponentDelegate.convertDataValueToMicroseconds(strValues[i]);
                    strValues[i] = microseconds != -1L ? String.valueOf(microseconds) : "";
                    try {
                        Time t = Time.valueOf(labels[i]);
                        if (t == null) continue;
                        labels[i] = this.convertDataValueToPresentationValue(t);
                        continue;
                    }
                    catch (TimeFormatException e) {
                        // empty catch block
                    }
                }
            }
            this.setOptions(labels, strValues);
        } else {
            this.combo_d.removeAllChilds();
        }
    }

    @Override
    public boolean isDate() {
        return this.dateComponentDelegate.isDate();
    }

    @Override
    public Object clone() {
        return HTMLComboBox.newInstance(this);
    }

    @Override
    public String convertDataValueToPresentationValue(Time time) {
        return this.dateComponentDelegate.convertDataValueToPresentationValue(time);
    }

    @Override
    public String convertPresentationValueToDataValue(String value) throws ParseException {
        return this.dateComponentDelegate.convertPresentationValueToDataValue(value);
    }

    @Override
    public void restrict(int precision, boolean isAbsolute) {
        this.dateComponentDelegate.restrict(precision, isAbsolute);
    }

    @Override
    protected void _applyStyle(String style) {
        this.combo_d.setStyle(style);
        this.sTD_d.setStyle(style);
        if (this.isCssEnabled()) {
            this.combo_d.setCssClass(this.getCssClassName());
            this.sTD_d.setCssClass(this.getCssClassName());
        } else {
            this.combo_d.setCssClass("");
            this.sTD_d.setCssClass("");
        }
    }

    @Override
    void _setOnFocus(String js) {
        this.combo_d.setOnFocus(js);
    }

    private static TD getComboTD() {
        TD td = new TD();
        td.setAlign("left");
        td.setVAlign("middle");
        td.setNoWrap(true);
        return td;
    }

    private void setOptions(String[] labels, String[] values) {
        assert (labels.length == values.length);
        this.combo_d.removeAllChilds();
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null) {
                labels[i] = "";
                this.log(XObjectRuntimeMsg.RUNTIME_PRES_COMPONENTS_MULTIVALUATED_NULL_LABEL(this.getId(), this.getReference()));
            }
            if (values[i] == null) {
                values[i] = "";
            }
            Option option = new Option(String.valueOf(i));
            option.setValue(values[i]);
            option.addChild(new Text(String.valueOf(i), labels[i]));
            this.combo_d.addChild(option);
        }
    }

    private void setSelectedOption(String value) {
        if (value == null) {
            value = "";
        } else if (this.isDate()) {
            long microseconds = this.dateComponentDelegate.convertDataValueToMicroseconds(value);
            value = microseconds != -1L ? String.valueOf(microseconds) : "";
        }
        String selectedValue = null;
        String selectedLabel = null;
        Iterator<Element> optionIterator = this.combo_d.getAllChilds();
        while (optionIterator.hasNext()) {
            Option item = (Option)optionIterator.next();
            String itemValue = item.getAttribute("value") != null ? item.getAttribute("value") : "";
            boolean isSelected = itemValue.equals(value);
            if (isSelected) {
                selectedValue = item.getAttribute("value");
                selectedLabel = ((Text)item.getChild(item.getId())).getText();
            }
            item.setSelected(isSelected);
        }
        if (selectedValue == null) {
            selectedLabel = "";
        }
        this.nonEditableText.setText(selectedLabel);
    }

    private void initComboBox() {
        this.initEditableCombo();
        this.initNonEditableCombo();
        this.applyStyle();
        this.applyFocusPersistence();
    }

    private void initEditableCombo() {
        this.combo_d = new Select(this.getId());
        this.combo_d.setName(this.getHtmlAttString());
        this.combo_d.setHtmlId(this.getHtmlAttString());
        this.combo_d.setTabindex(String.valueOf(this.getTabindex()));
        this.onChangeScript = String.valueOf(((XFormCombo)this.getPresentationXMLObject()).getOnChange() != null);
    }

    private void initNonEditableCombo() {
        this.sTable = new Table();
        TR tr = new TR();
        this.sTD_d = HTMLComboBox.getComboTD();
        this.nonEditableText = new Text();
        this.sTD_d.addChild(this.nonEditableText);
        tr.addChild(this.sTD_d);
        this.sTable.addChild(tr);
    }
}

