/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime.html;

import oracle.bpm.xobject.presentationmodel.ColorProperties;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.html.HTMLContainerElement;
import oracle.bpm.xobject.runtime.html.HTMLElement;
import oracle.bpm.xobject.runtime.presentationComponents.XOCellComponent;
import oracle.bpm.xobject.xhb.DIV;
import oracle.bpm.xobject.xhb.Element;
import oracle.bpm.xobject.xhb.TD;

public class HTMLCell
extends HTMLContainerElement
implements XOCellComponent,
Cloneable {
    HTMLElement child_d;
    TD td_d;
    private String bgColor;
    private String bottomBorderColor;
    private String bottomBorderStyle;
    private int bottomBorderWidth;
    private String fgColor;
    private String leftBorderColor;
    private String leftBorderStyle;
    private int leftBorderWidth;
    private String rightBorderColor;
    private String rightBorderStyle;
    private int rightBorderWidth;
    private String topBorderColor;
    private String topBorderStyle;
    private int topBorderWidth;

    public HTMLCell(XScreen xScreen, XFormCell cell) {
        super(xScreen, cell);
        this.topBorderStyle = cell.topborderstyle;
        this.topBorderColor = cell.topbordercolor;
        this.topBorderWidth = cell.topborderwidth;
        this.bottomBorderStyle = cell.bottomborderstyle;
        this.bottomBorderColor = cell.bottombordercolor;
        this.bottomBorderWidth = cell.bottomborderwidth;
        this.leftBorderStyle = cell.leftborderstyle;
        this.leftBorderColor = cell.leftbordercolor;
        this.leftBorderWidth = cell.leftborderwidth;
        this.rightBorderStyle = cell.rightborderstyle;
        this.rightBorderColor = cell.rightbordercolor;
        this.rightBorderWidth = cell.rightborderwidth;
        this.bgColor = cell.bgcolor;
        this.fgColor = cell.fgcolor;
        this.initCell();
    }

    public static HTMLCell newInstance(HTMLCell originalElement) {
        HTMLCell newElement = new HTMLCell(originalElement.getXScreen(), (XFormCell)originalElement.getPresentationXMLObject());
        newElement.addElement((HTMLElement)originalElement.child_d.clone());
        return newElement;
    }

    public void setAlign(String align) {
        if (align != null && !align.trim().equals("")) {
            ((XFormCell)this.getPresentationXMLObject()).alignment = align;
            this.td_d.setAlign(align);
        }
    }

    public String getAlign() {
        return ((XFormCell)this.getPresentationXMLObject()).alignment;
    }

    public void setBgColor(String bgColor) {
        if (bgColor != null && !bgColor.trim().equals("")) {
            ((XFormCell)this.getPresentationXMLObject()).bgcolor = bgColor;
            this.td_d.setBgColor(bgColor);
        }
    }

    public String getBgColor() {
        return ((XFormCell)this.getPresentationXMLObject()).bgcolor;
    }

    public void setColSpan(int colspan) {
        if (colspan > 0) {
            ((XFormCell)this.getPresentationXMLObject()).hexpand = colspan;
            this.td_d.setColSpan("" + colspan);
        }
    }

    public int getColSpan() {
        return ((XFormCell)this.getPresentationXMLObject()).hexpand;
    }

    @Override
    public Element getPureElement() {
        if (this.isEditor() && this.child_d == null) {
            DIV div = new DIV();
            div.setStyle(this.getInlineWidthCSS("22px") + this.getInlineHeightCSS("22px"));
            this.td_d.addChild(div);
        }
        return this.td_d;
    }

    public void setRowSpan(int rowspan) {
        if (rowspan > 0) {
            ((XFormCell)this.getPresentationXMLObject()).vexpand = rowspan;
            this.td_d.setRowSpan("" + rowspan);
        }
    }

    public int getRowSpan() {
        return ((XFormCell)this.getPresentationXMLObject()).vexpand;
    }

    @Override
    public String getStyle() {
        XFormCell xCell = (XFormCell)this.getPresentationXMLObject();
        StringBuffer css = new StringBuffer();
        if (!this.isCssEnabled() || this.isCssEnabled() && this.isMixedCss()) {
            css.append(this.getInlineFontCCS(xCell.fonttype, xCell.getFontStyle(), xCell.fontsize));
            css.append(this.getInlineBackgroundColorCCS(this.bgColor));
            css.append(this.getInlineForegroundColorCCS(this.fgColor));
            css.append(this.getInlineTopBorderCSS(this.topBorderStyle, this.topBorderColor, this.topBorderWidth));
            css.append(this.getInlineBottomBorderCSS(this.bottomBorderStyle, this.bottomBorderColor, this.bottomBorderWidth));
            css.append(this.getInlineRightBorderCSS(this.rightBorderStyle, this.rightBorderColor, this.rightBorderWidth));
            css.append(this.getInlineLeftBorderCSS(this.leftBorderStyle, this.leftBorderColor, this.leftBorderWidth));
        }
        return css.toString();
    }

    public void setVAlign(String valign) {
        if (valign != null && !valign.trim().equals("")) {
            ((XFormCell)this.getPresentationXMLObject()).valignment = valign;
            if (valign.equals("center")) {
                valign = "middle";
            }
            this.td_d.setVAlign(valign);
        }
    }

    public String getVAlign() {
        return ((XFormCell)this.getPresentationXMLObject()).valignment;
    }

    @Override
    public void _addElement(HTMLElement element) {
        this.child_d = element;
        this.td_d.addChild(element.getElement());
    }

    @Override
    public Object clone() {
        return HTMLCell.newInstance(this);
    }

    @Override
    protected void _applyStyle(String style) {
        this.td_d.setStyle(style);
        if (this.isCssEnabled()) {
            this.td_d.setCssClass(this.getCssClassName());
        } else {
            this.td_d.setCssClass("");
        }
    }

    void applyStyle(HTMLElement parentTable) {
        if (parentTable != null) {
            FullBorderProperties xBorder;
            XFormPresentationXMLObject xElement = parentTable.getPresentationXMLObject();
            XFormCell xCell = (XFormCell)this.getPresentationXMLObject();
            if (xElement instanceof FullBorderProperties && (xBorder = (FullBorderProperties)((Object)xElement)).isBorderActive()) {
                if (xCell.topborderstyle == null && xBorder.getTopStyle() != null) {
                    this.topBorderStyle = xBorder.getTopStyle().toString();
                    this.topBorderColor = xBorder.getTopColor();
                    this.topBorderWidth = xBorder.getTopWidth();
                }
                if (xCell.bottomborderstyle == null && xBorder.getBottomStyle() != null) {
                    this.bottomBorderStyle = xBorder.getBottomStyle().toString();
                    this.bottomBorderColor = xBorder.getBottomColor();
                    this.bottomBorderWidth = xBorder.getBottomWidth();
                }
                if (xCell.leftborderstyle == null && xBorder.getLeftStyle() != null) {
                    this.leftBorderStyle = xBorder.getLeftStyle().toString();
                    this.leftBorderColor = xBorder.getLeftColor();
                    this.leftBorderWidth = xBorder.getLeftWidth();
                }
                if (xCell.rightborderstyle == null && xBorder.getRightStyle() != null) {
                    this.rightBorderStyle = xBorder.getRightStyle().toString();
                    this.rightBorderColor = xBorder.getRightColor();
                    this.rightBorderWidth = xBorder.getRightWidth();
                }
            }
            if (xElement instanceof ColorProperties) {
                ColorProperties xColor = (ColorProperties)((Object)xElement);
                if (xCell.bgcolor == null && xColor.getBgcolor() != null) {
                    this.bgColor = parentTable.getBackgroundColor();
                }
                if (xCell.fgcolor == null && xColor.getFgcolor() != null) {
                    this.fgColor = parentTable.getForegroundColor();
                }
            }
            this.applyStyle();
        }
    }

    private void initCell() {
        XFormCell cell = (XFormCell)this.getPresentationXMLObject();
        this.td_d = new TD();
        this.setAlign(cell.alignment);
        this.setVAlign(cell.valignment);
        this.setColSpan(cell.hexpand);
        this.setRowSpan(cell.vexpand);
    }
}

