/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionRelayedThrowable;
import oracle.bpm.component.InteractiveExecutionException;
import oracle.bpm.component.Modifiable;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.FuegoClass;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.FuegoObjectCatalog;
import oracle.bpm.xml.Serializer;
import oracle.bpm.xml.XMLSerializer;
import oracle.bpm.xml.XMLSerializerWriter;
import oracle.bpm.xobject.GroupArray;
import oracle.bpm.xobject.GroupArrayChangeListener;
import oracle.bpm.xobject.XObjectInternalException;
import oracle.bpm.xobject.io.FOClonner;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.runtime.InvalidPresentationException;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectGroupRowInstance;
import oracle.bpm.xobject.runtime.XObjectRuntimeInternalException;
import oracle.bpm.xobject.runtime.components.Executor;
import oracle.bpm.xobject.runtime.components.FuegoObject;
import oracle.bpm.xobject.runtime.components.Presentable;
import oracle.bpm.xobject.runtime.components.PresentableDelegate;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class XObjectInstance
implements Serializable {
    protected transient ObjectTypeDescription objectType;
    private transient Map i18nResources;
    private Map<Long, Object> immutableReferences;
    private transient Map<String, XObjectInnerCacheReference> innerXOMap;
    private boolean interpreted = false;
    private Invokeable invokeable;
    private boolean needToBeCloned;
    private final Object origXobj;
    private transient ReferenceQueue<XObjectInstance> referenceQueue;
    private Object xobj;
    private static final long serialVersionUID = -4551165954100974583L;
    public static final Class[] PRES_DELE = new Class[]{PresentableDelegate.class};
    public static final String GET_DELEGATE_METHOD = "get__presentableDelegate_delegate";
    public static final String SET_DELEGATE_METHOD = "set__presentableDelegate_delegate";
    private static final Class[] PRES_MODIF_INTERF = new Class[]{Presentable.class, Modifiable.class};
    private static final Class[] PRES_INTERF = new Class[]{Presentable.class};
    private static final int PRESENTATION_RESOURCE = 0;
    private static final int I18N_RESOURCE = 1;
    static final int SIMPLE_ATTR_TYPE = 0;
    static final int INNER_FOBJECT_ATTR_TYPE = 1;
    static final int GROUP_ATTR_TYPE = 2;
    static final int GROUP_ITEM_ATTR_TYPE = 3;

    public XObjectInstance(Object instance) {
        this(instance, null);
    }

    public XObjectInstance(Object instance, boolean needToBeCloned) {
        this(instance, null, needToBeCloned);
    }

    protected XObjectInstance() {
        this.origXobj = null;
        this.objectType = null;
    }

    protected XObjectInstance(Object instance, ObjectTypeDescription objectType) {
        this(instance, objectType, true);
    }

    protected XObjectInstance(Object instance, ObjectTypeDescription objectType, boolean needToBeCloned) {
        assert (instance != null);
        this.needToBeCloned = needToBeCloned;
        if (instance instanceof Invokeable) {
            this.interpreted = true;
        }
        this.initilize(instance, objectType);
        this.innerXOMap = new HashMap<String, XObjectInnerCacheReference>(0, 5.0f);
        this.referenceQueue = new ReferenceQueue();
        this.immutableReferences = new HashMap<Long, Object>();
        this.origXobj = this.shouldClone() ? FOClonner.overrideClone(instance, this.immutableReferences) : null;
    }

    public static void dump(Object obj) {
        try {
            DynamicObject result = DynamicObject.valueOf(obj);
            XMLSerializer bxs = new XMLSerializer();
            XMLSerializerWriter dd = new XMLSerializerWriter((OutputStream)System.out, (Serializer)bxs, "UTF8");
            dd.write(obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode()), result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printFOInfo(Object fo, String desc) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            try {
                System.out.println();
                System.out.println("############################");
                System.out.println("Showing " + desc + " info.");
                System.out.println("Current thread = " + Thread.currentThread());
                System.out.println("Caller method = " + new Throwable().getStackTrace()[1].getMethodName());
                System.out.println("Name = " + fo.getClass().getName());
                System.out.println("Object = " + fo);
                Class<?> cl = fo.getClass();
                try {
                    Field parentField = JavaClass.getParentField(cl);
                    parentField.setAccessible(true);
                    Object parent = parentField.get(fo);
                    System.out.println("Parent = " + parent);
                }
                catch (NoSuchFieldException ignored) {
                }
                catch (IllegalAccessException ignored) {
                    // empty catch block
                }
            }
            finally {
                System.out.println("############################");
                System.out.println();
            }
        }
    }

    public boolean isAbsoluteTime(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.isAbsoluteTime();
    }

    public int getAttributeArrayKind(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        if (attrType.getResultType().getKind() == 12) {
            return attrType.getResultType().getElementType().getKind();
        }
        return -1;
    }

    public String getAttributeJavaType(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.getJavaType();
    }

    public int getAttributeKind(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.getResultType().getKind();
    }

    public int getAttributeLength(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.getMemberLength();
    }

    public int getAttributePrecision(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.getPrecision();
    }

    public boolean isAttributeRequired(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.isRequired();
    }

    public Object[][] getAttributeValidValues(String dataId) throws InvalidXOAttributeException {
        int attrKind = this.getXObjectAttNameType(dataId);
        switch (attrKind) {
            case 1: {
                XObjectInstance innerXO = this.getInnerXObjectInstance(dataId);
                return innerXO.getAttributeValidValues(this.getInnerXOAttName(dataId));
            }
            case 2: {
                return null;
            }
        }
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        TreeMap<Integer, String> result = null;
        if (attrType.getType().isEnum()) {
            EnumTypeDescription enumType = (EnumTypeDescription)attrType.getType();
            TreeMap<Integer, String> values = new TreeMap<Integer, String>();
            String[] enumLabels = enumType.getLabels();
            for (int i = 0; i < enumLabels.length; ++i) {
                values.put(i, enumLabels[i]);
            }
            result = values;
        } else {
            String validValueMethodSignature = XObjectTypeDescription.getValidValuesMethodSignature(this.objectType, attrType);
            Object[] methodArgs = null;
            try {
                try {
                    result = this.invokeMethod(validValueMethodSignature, methodArgs);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof ExecutionRelayedThrowable)) {
                        throw new ComponentExecutionException(cause, this.getName(), JavaClass.getMethodNameFromSignature(validValueMethodSignature));
                    }
                }
            }
            catch (ComponentExecutionException cee) {
                throw new RuntimeExceptionShell(cee);
            }
        }
        List<Object> vvValuesList = null;
        List<String> vvPresentationList = null;
        if (result != null) {
            assert (result instanceof List || result instanceof Map) : "ValidValues methods only return Lists or Maps. The returned value was: " + result.getClass().getName();
            if (result instanceof List) {
                List list = (List)((Object)result);
                if (list.size() == 2 && list.get(0) instanceof List && list.get(1) instanceof List) {
                    vvValuesList = (List)Cast.force(list.get(0));
                    vvPresentationList = (List)Cast.force(list.get(1));
                } else {
                    vvValuesList = (List)Cast.force(list);
                }
            } else {
                Map vvMap = (Map)Cast.force(result);
                vvValuesList = new ArrayList(vvMap.keySet());
                vvPresentationList = new ArrayList(vvMap.values());
            }
        }
        if (vvValuesList == null) {
            vvPresentationList = null;
        } else if (vvPresentationList == null || vvValuesList == vvPresentationList) {
            vvPresentationList = new ArrayList<String>(vvValuesList);
        }
        Object[] vvValues = null;
        Object[] vvPresentation = null;
        boolean isAttrRequired = this.isAttributeRequired(dataId);
        if (vvValuesList != null) {
            ArrayList conversionList = new ArrayList(vvValuesList);
            if (!isAttrRequired) {
                conversionList.add(0, null);
            }
            vvValues = conversionList.toArray();
        }
        if (vvPresentationList != null) {
            if (!isAttrRequired) {
                vvPresentationList.add(0, " ");
            }
            vvPresentation = vvPresentationList.toArray();
        }
        return new Object[][]{vvValues, vvPresentation};
    }

    public void setAttributeValue(String dataId, Object value) throws ComponentExecutionException, InvocationTargetException {
        int attrType = this.getXObjectAttNameType(dataId);
        switch (attrType) {
            case 1: {
                XObjectInstance innerXO = this.getInnerXObjectInstance(dataId);
                innerXO.setAttributeValue(this.getInnerXOAttName(dataId), value);
                break;
            }
            case 2: {
                this.setAttributeValue(this.getGroupDataId(dataId), value);
                break;
            }
            case 3: {
                XObjectGroupRowInstance grpXO = this.getGroupXObjectInstance(this.getGroupItemDataId(dataId), this.getGroupItemIndex(dataId));
                grpXO.setAttributeValue(this.getGroupItemAttName(dataId), value);
                break;
            }
            default: {
                String attributeSignature = this.getAttWriteSignature(dataId);
                if (attributeSignature == null) break;
                String targetType = this.parseAtrSignature(attributeSignature);
                if (targetType != null) {
                    try {
                        Class<?> cl = JavaClass.loadByJavaType(targetType);
                        if (value == null || !value.getClass().isAssignableFrom(cl)) {
                            value = Conversion.convertTo(value, cl);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                this.invokeable.setAttributeValue(attributeSignature, value);
            }
        }
    }

    public Object getAttributeValue(String dataId) throws InvalidXOAttributeException {
        int attrType = this.getXObjectAttNameType(dataId);
        switch (attrType) {
            case 1: {
                XObjectInstance innerXO = this.getInnerXObjectInstance(dataId);
                return innerXO.getAttributeValue(this.getInnerXOAttName(dataId));
            }
            case 2: {
                return this.getAttributeValue(this.getGroupDataId(dataId));
            }
            case 3: {
                XObjectGroupRowInstance grpXO = this.getGroupXObjectInstance(this.getGroupItemDataId(dataId), this.getGroupItemIndex(dataId));
                return grpXO.getAttributeValue(this.getGroupItemAttName(dataId));
            }
        }
        return this.invokeable.getAttributeValue(this.getAttReadSignature(dataId));
    }

    public boolean isDirty(String dataId) {
        int attrType = this.getXObjectAttNameType(dataId);
        switch (attrType) {
            case 1: {
                boolean isInnerDirty = this.isDirty(this.getInnerDataId(dataId));
                if (!isInnerDirty) {
                    try {
                        XObjectInstance innerXO = this.getInnerXObjectInstance(dataId);
                        return innerXO.isDirty(this.getInnerXOAttName(dataId));
                    }
                    catch (InvalidXOAttributeException e) {
                        Log.logWarning(e);
                        return true;
                    }
                }
                return true;
            }
            case 2: {
                assert (false) : "isDirty: Can not be called for a Group row";
                return true;
            }
        }
        boolean isDirty = true;
        if (this.xobj instanceof Modifiable) {
            Modifiable m = (Modifiable)this.xobj;
            try {
                int field = m._indexForField(dataId);
                if (field != -1) {
                    isDirty = m._isModified(field);
                }
            }
            catch (UndeclaredThrowableException e) {
                // empty catch block
            }
        }
        return isDirty;
    }

    public Executor getExecutor() {
        assert (!Component.isRunningOnDebugger());
        Executor executor = null;
        try {
            executor = this.xobj instanceof FuegoObject ? ((FuegoObject)this.xobj).geetExecutor() : Executor.getCurrent();
        }
        catch (UndeclaredThrowableException e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            e.printStackTrace();
            e.getCause().printStackTrace();
        }
        return executor;
    }

    public String[] getFields() {
        List<MethodTypeDescription> attributes = this.objectType.getAttributes();
        String[] fieldNames = new String[attributes.size()];
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeTypeDescription attribute = attributes.get(i).asAttribute();
            fieldNames[i] = attribute.getName();
        }
        return fieldNames;
    }

    public void setGroupAttributeValue(String groupDataId, String columnDataId, int index, Object value) throws ComponentExecutionException, InvocationTargetException {
        XObjectGroupRowInstance groupXO = this.getGroupXObjectInstance(groupDataId, index);
        groupXO.setAttributeValue(columnDataId, value);
    }

    public Object getGroupAttributeValue(String groupDataId, String columnDataId, int index) throws InvalidXOAttributeException {
        XObjectGroupRowInstance groupXO = this.getGroupXObjectInstance(groupDataId, index);
        return groupXO.getAttributeValue(columnDataId);
    }

    public List<XObjectGroupRowInstance> getGroupRows(String groupName) throws InvalidXOAttributeException {
        assert (groupName != null);
        ArrayList<XObjectGroupRowInstance> xobjectInstanceList = null;
        GroupArray xoGroup = this.getGroupArray(groupName);
        if (xoGroup != null) {
            try {
                xobjectInstanceList = new ArrayList<XObjectGroupRowInstance>(xoGroup.size());
                for (int i = 0; i < xoGroup.size(); ++i) {
                    Object instance = xoGroup.get(i);
                    XObjectGroupRowInstance xobjectGroupRowInstance = new XObjectGroupRowInstance(instance);
                    xobjectGroupRowInstance.setDirty(xoGroup.isRowModified(i));
                    xobjectInstanceList.add(xobjectGroupRowInstance);
                }
            }
            catch (ComponentExecutionException e) {
                throw new InvalidXOAttributeException(e);
            }
        }
        return xobjectInstanceList;
    }

    public List<XObjectGroupRowInstance> getGroupRows(String groupName, int beginIndex, int endIndex) throws InvalidXOAttributeException {
        assert (groupName != null);
        ArrayList<XObjectGroupRowInstance> xobjectInstanceList = null;
        GroupArray xoGroup = this.getGroupArray(groupName);
        if (xoGroup != null) {
            try {
                xobjectInstanceList = new ArrayList<XObjectGroupRowInstance>(xoGroup.size());
                for (int i = beginIndex; i < xoGroup.size() && i <= endIndex; ++i) {
                    Object instance = xoGroup.get(i);
                    XObjectGroupRowInstance xobjectGroupRowInstance = new XObjectGroupRowInstance(instance);
                    xobjectGroupRowInstance.setDirty(xoGroup.isRowModified(i));
                    xobjectInstanceList.add(xobjectGroupRowInstance);
                }
            }
            catch (ComponentExecutionException e) {
                throw new InvalidXOAttributeException(e);
            }
        }
        return xobjectInstanceList;
    }

    public int getGroupSize(String groupName) throws InvalidXOAttributeException {
        assert (groupName != null);
        List xoGroup = (List)this.getAttributeValue(groupName);
        if (xoGroup != null) {
            return xoGroup.size();
        }
        return -1;
    }

    public XObjectGroupRowInstance getGroupXObjectInstance(String groupDataId, int index) throws InvalidXOAttributeException {
        assert (groupDataId != null);
        try {
            List groupXO = (List)this.getAttributeValue(groupDataId);
            if (groupXO != null && groupXO.size() > index) {
                XObjectGroupRowInstance xobjectInstance = new XObjectGroupRowInstance(groupXO.get(index));
                if (groupXO instanceof GroupArray) {
                    xobjectInstance.setDirty(((GroupArray)groupXO).isRowModified(index));
                }
                return xobjectInstance;
            }
            throw new InvalidXOAttributeException(XObjectRuntimeMsg.XOBJ_INV_ATTR_0004(groupDataId, this.getName()));
        }
        catch (ComponentExecutionException e) {
            throw new InvalidXOAttributeException(e);
        }
    }

    public String getName() {
        String name = this.invokeable.getName();
        if (this.isInterpreted()) {
            name = "xobject." + name;
        }
        return name;
    }

    public Object getTarget() {
        if (this.isInterpreted()) {
            return this.invokeable;
        }
        return this.invokeable.getTarget();
    }

    public String getXODefaultPresentation() {
        String pres = this.objectType.getProperty("defaultPresentation");
        try {
            this.validatePresentationName(pres);
        }
        catch (InvalidPresentationException ip) {
            return null;
        }
        return pres;
    }

    public String getI18NResource(String key, Locale locale) {
        String resource = null;
        if (this.objectType != null && this.objectType.isBpmObject()) {
            XObjectTypeDescription.ResourceValue currentMap;
            if (this.i18nResources == null) {
                block6: {
                    try {
                        this.i18nResources = (Map)this.getXOResource("i18n", 1);
                    }
                    catch (XObjectRuntimeInternalException e) {
                        if (!Log.isDebugging()) break block6;
                        Log.logDebug(e);
                    }
                }
                if (this.i18nResources == null) {
                    this.i18nResources = Collections.EMPTY_MAP;
                }
            }
            if ((currentMap = (XObjectTypeDescription.ResourceValue)this.i18nResources.get(key)) != null) {
                LocaleStringMap map = currentMap.getLocaleMap();
                resource = map.getString(locale);
            }
        }
        return resource != null ? resource : key;
    }

    public boolean addNewRowToGroup(String groupDataId) throws InvalidXOAttributeException {
        Object newRowInstance = this.newGroupRowInstance(groupDataId);
        List xoGroup = (List)Cast.force(this.getAttributeValue(groupDataId));
        return xoGroup.add(newRowInstance);
    }

    public void dump() {
        XObjectInstance.dump(this.getTarget());
    }

    public boolean hasValidValues(String dataId) throws InvalidXOAttributeException {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return attrType.hasValidValues() || attrType.getType().isEnum();
    }

    public boolean insertRowDowntFromGroup(String groupDataId, int fromIndex) throws InvalidXOAttributeException {
        Object newRowInstance = this.newGroupRowInstance(groupDataId);
        List xoGroup = (List)Cast.force(this.getAttributeValue(groupDataId));
        if (fromIndex + 1 < xoGroup.size()) {
            xoGroup.add(fromIndex + 1, newRowInstance);
            return true;
        }
        if (fromIndex + 1 == xoGroup.size()) {
            return xoGroup.add(newRowInstance);
        }
        if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XO_INSTANCE_GROUP_INSERT_DOWN(String.valueOf(fromIndex), String.valueOf(xoGroup.size())));
        }
        return false;
    }

    public boolean insertRowUpFromGroup(String groupDataId, int fromIndex) throws InvalidXOAttributeException {
        Object newRowInstance = this.newGroupRowInstance(groupDataId);
        List xoGroup = (List)Cast.force(this.getAttributeValue(groupDataId));
        if (fromIndex < xoGroup.size()) {
            xoGroup.add(fromIndex, newRowInstance);
            return true;
        }
        if (fromIndex == xoGroup.size()) {
            return xoGroup.add(newRowInstance);
        }
        if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XO_INSTANCE_GROUP_INSERT_UP(String.valueOf(fromIndex), String.valueOf(xoGroup.size())));
        }
        return false;
    }

    public final Object invokeMethod(String methodName, Object[] args) throws ComponentExecutionException, InvocationTargetException {
        return this.invokeMethod(methodName, null, args);
    }

    public final Object invokeMethod(String methodName, Integer groupIndex, Object[] args) throws ComponentExecutionException, InvocationTargetException {
        XObjectInstance xo = this;
        String methodSignature = methodName;
        String[] methodSignatureInfo = this.parseMethodSignature(methodName);
        if (methodSignatureInfo != null) {
            methodSignature = methodSignatureInfo[1];
            xo = this.getXObjectInstanceFromMethodSignature(methodSignatureInfo[0], groupIndex);
        }
        if (!Component.isRunningOnDebugger()) {
            Executor.setCurrent(this.getExecutor());
        }
        try {
            return xo.invokeable.invoke(methodSignature, args);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite;
            while (!(cause instanceof InteractiveExecutionException) && ((Throwable)cause).getCause() != null) {
                cause = ((Throwable)cause).getCause();
            }
            if (cause instanceof InteractiveExecutionException) {
                throw new ComponentExecutionException(XObjectRuntimeMsg.XOBJ_INT_CMP_INV_0001(JavaClass.getMethodNameFromSignature(methodSignature), this.getName()));
            }
            throw ite;
        }
    }

    public void registerGroupArrayChangeListener(String groupName, GroupArrayChangeListener listener) throws InvalidXOAttributeException {
        this.getGroupArray(groupName).setGroupArrayChangeListener(listener);
    }

    public final void resetGroupModifiedRowsFlag(String groupDataId) throws InvalidXOAttributeException {
        assert (groupDataId != null);
        GroupArray groupXO = this.getGroupArray(groupDataId);
        if (groupXO != null) {
            groupXO.resetModifiedRows();
        }
    }

    public Object removeLastRowFromGroup(String groupDataId) throws InvalidXOAttributeException {
        List xoGroup = (List)this.getAttributeValue(groupDataId);
        if (xoGroup != null && xoGroup.size() > 0) {
            return xoGroup.remove(xoGroup.size() - 1);
        }
        if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XO_INSTANCE_GROUP_REMOVE_LAST_ROW(groupDataId));
        }
        return null;
    }

    public void removeRowFromGroup(String groupDataId, int[] indexes) throws InvalidXOAttributeException {
        List xoGroup = (List)this.getAttributeValue(groupDataId);
        if (xoGroup != null) {
            for (int i = 0; i < indexes.length; ++i) {
                int indexToRemove = indexes[i] - i;
                if (indexToRemove < xoGroup.size()) {
                    xoGroup.remove(indexToRemove);
                    continue;
                }
                if (!Log.isDebugging()) continue;
                Log.logDebug(XObjectRuntimeMsg.XO_INSTANCE_GROUP_REMOVE_ROW(String.valueOf(indexToRemove), groupDataId, String.valueOf(xoGroup.size())));
            }
        } else if (Log.isDebugging()) {
            Log.logDebug(XObjectRuntimeMsg.XO_INSTANCE_GROUP_REMOVE_LAST_ROW(groupDataId));
        }
    }

    public void resetDirty() {
        try {
            if (this.xobj instanceof Modifiable) {
                Modifiable m = (Modifiable)this.xobj;
                m._reset();
            }
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            // empty catch block
        }
    }

    public void validatePresentationName(String name) throws InvalidPresentationException {
        String[] presentationNames;
        String presentationStrNames = this.objectType.getProperty("presentationNames");
        String[] stringArray = presentationNames = presentationStrNames != null ? Str.split(presentationStrNames, ',', false) : null;
        if (name != null && presentationNames != null) {
            for (String presentationName : presentationNames) {
                if (!presentationName.equals(name)) continue;
                return;
            }
        }
        InvalidPresentationException invalidPresentationException = new InvalidPresentationException(name, presentationNames);
        Log.logWarning(invalidPresentationException);
        throw invalidPresentationException;
    }

    public final void setObjectType(ObjectTypeDescription objectType) {
        this.objectType = objectType;
    }

    public boolean hasAttribute(String dataId) {
        return this.getType(dataId, this.objectType) != null;
    }

    protected boolean shouldClone() {
        return this.needToBeCloned;
    }

    protected GroupArray getGroupArray(String groupName) throws InvalidXOAttributeException {
        Object value = this.getAttributeValue(groupName);
        assert (value instanceof GroupArray) : "Expected GroupArray but was: " + (value != null ? value.getClass().getName() : "null");
        return (GroupArray)value;
    }

    protected boolean isXObjectReferenceAtt(String dataId) {
        ObjectTypeDescription resultType;
        TypeDescription elementType;
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        int kind = attrType.getResultType().getKind();
        return (kind == 11 || kind == 12) && (elementType = kind == 11 ? attrType.getResultType() : attrType.getResultType().getElementType()) instanceof ObjectTypeDescription && (resultType = (ObjectTypeDescription)attrType.getResultType()).isBpmObject();
    }

    protected void initObjectType(ObjectTypeDescription objectType) {
        if (objectType != null) {
            this.objectType = objectType;
        } else if (this.isInterpreted() && this.invokeable.getType() instanceof ObjectTypeDescription) {
            this.objectType = (ObjectTypeDescription)this.invokeable.getType();
        } else {
            try {
                String fuegoName = this.invokeable.getFuegoName();
                if (fuegoName == null) {
                    String prefix;
                    fuegoName = this.invokeable.getName();
                    if ((fuegoName = fuegoName.replace('$', '.')).startsWith(prefix = "xobject.")) {
                        fuegoName = fuegoName.substring(prefix.length());
                    }
                }
                this.objectType = FuegoClass.forName(fuegoName, this.xobj.getClass().getClassLoader());
            }
            catch (Throwable t) {
                Log.logWarning(t);
            }
        }
    }

    final boolean isGroupItemAttName(String attName) {
        assert (attName != null);
        return this.getXObjectAttNameType(attName) == 3;
    }

    final boolean isGroupXOAttName(String attName) {
        assert (attName != null);
        return this.getXObjectAttNameType(attName) == 2;
    }

    final boolean isInnerXOAttName(String attName) {
        assert (attName != null);
        return this.getXObjectAttNameType(attName) == 1;
    }

    final int getXObjectAttNameType(String attName) {
        int groupMarkIndex = attName.indexOf("[]");
        int groupItemMarkIndex = attName.indexOf("[");
        int firstDotIndex = attName.indexOf(46);
        if (groupMarkIndex != -1) {
            if (firstDotIndex != -1 && firstDotIndex < groupMarkIndex) {
                return 1;
            }
            return 2;
        }
        if (groupItemMarkIndex != -1) {
            if (firstDotIndex != -1 && firstDotIndex < groupItemMarkIndex) {
                return 1;
            }
            return 3;
        }
        if (firstDotIndex != -1) {
            return 1;
        }
        return 0;
    }

    final boolean hasGroupXOAttName(String attName) {
        int groupMarkIndex = attName.indexOf("[]");
        return groupMarkIndex != -1;
    }

    XObjectInstance getInnerXObjectInstance(String dataId) throws InvalidXOAttributeException {
        XObjectInstance innerXObject;
        assert (this.isInnerXOAttName(dataId));
        this.pollXObjectInnerCacheReference();
        String innerDataId = this.getInnerDataId(dataId);
        XObjectInnerCacheReference value = this.innerXOMap.get(innerDataId);
        if (this.isDirty(innerDataId) || value == null || ((Reference)value).get() == null) {
            try {
                String attributeSignature = this.getAttReadSignature(innerDataId);
                Object innerXO = this.invokeable.getAttributeValue(attributeSignature);
                if (innerXO == null) {
                    throw new InvalidXOAttributeException(XObjectRuntimeMsg.XOBJ_INV_ATTR_0004(dataId.substring(0, dataId.indexOf(46)), this.getName()));
                }
                ObjectTypeDescription innerType = this.getAttrObjectType(innerDataId, this.objectType);
                innerXObject = new XObjectInstance(innerXO, innerType, this.needToBeCloned);
                this.innerXOMap.put(innerDataId, new XObjectInnerCacheReference(innerDataId, innerXObject, this.referenceQueue));
            }
            catch (ComponentExecutionException e) {
                throw new InvalidXOAttributeException(e);
            }
        } else {
            innerXObject = (XObjectInstance)((Reference)value).get();
        }
        return innerXObject;
    }

    boolean isInterpreted() {
        return this.interpreted;
    }

    XFormPresentationModel getXOPresentationModel(String name) throws XObjectRuntimeInternalException {
        if (name == null || name.equals("")) {
            String defPress = this.getXODefaultPresentation();
            if (defPress == null || defPress.equals("")) {
                return null;
            }
            name = defPress;
        }
        try {
            XFormPresentationModel current = (XFormPresentationModel)this.getXOResource(name, 0);
            return current;
        }
        catch (XObjectRuntimeInternalException e) {
            Log.logSevere(e);
            throw e;
        }
    }

    void reset() {
        try {
            PresentableDelegate pd = this.getPD();
            XORuntimeManager rm = XObjectInstance.getRM(pd);
            HashMap<Long, Object> cleanReplaceables = new HashMap<Long, Object>();
            if (this.isInterpreted()) {
                Object newInstance = FOClonner.clone(this.origXobj, cleanReplaceables);
                this.initilize(newInstance, this.objectType);
            } else {
                this.setPD(null);
                FOClonner.clone(this.origXobj, cleanReplaceables);
                FOClonner.applyReplaceableGraph(this.immutableReferences, cleanReplaceables);
                this.innerXOMap = new HashMap<String, XObjectInnerCacheReference>(0, 5.0f);
            }
            XObjectInstance.setRM(pd, rm);
            this.setPD(pd);
        }
        catch (InvocationTargetException e) {
            Log.logWarning(e);
        }
        catch (ComponentExecutionException e) {
            Log.logWarning(e);
        }
    }

    private static void setRM(PresentableDelegate pd, XORuntimeManager rm) {
        pd.setRuntimeManager(rm);
    }

    private static XORuntimeManager getRM(PresentableDelegate pd) {
        XORuntimeManager xoRuntimeManager = pd.removeRuntimeManager();
        assert (xoRuntimeManager != null) : "xoRuntimeManager cannot be null";
        return xoRuntimeManager;
    }

    private AttributeTypeDescription getAttrType(String dataId, ObjectTypeDescription objectTypeDescription) {
        if (dataId == null) {
            throw new IllegalArgumentException("Invalid attribute ID [" + dataId + "]");
        }
        MethodTypeDescription typeDescription = this.getType(dataId, objectTypeDescription);
        if (typeDescription == null) {
            throw new IllegalArgumentException("TypeDescription not found for attribute '" + dataId + "'");
        }
        return typeDescription.asAttribute();
    }

    private ObjectTypeDescription getAttrObjectType(String dataId, ObjectTypeDescription objectTypeDescription) {
        return this.getType(dataId, objectTypeDescription).getResultType().asObject();
    }

    private String getGroupDataId(String attColumnName) {
        assert (this.getXObjectAttNameType(attColumnName) == 2);
        return attColumnName.substring(0, attColumnName.indexOf("[]."));
    }

    private String getGroupXOAttName(String attName) {
        assert (this.isGroupXOAttName(attName));
        return attName.substring(attName.indexOf("[].") + 3);
    }

    private MethodTypeDescription getType(String dataId, ObjectTypeDescription objectTypeDescription) {
        int attrType = this.getXObjectAttNameType(dataId);
        switch (attrType) {
            case 1: {
                String innerAttrName = this.getInnerDataId(dataId);
                AttributeTypeDescription innerMember = objectTypeDescription.findAttribute(innerAttrName);
                ObjectTypeDescription innerType = innerMember.getResultType().asObject();
                return this.getType(this.getInnerXOAttName(dataId), innerType);
            }
            case 2: {
                String groupAttrName = this.getGroupDataId(dataId);
                AttributeTypeDescription groupMember = objectTypeDescription.findAttribute(groupAttrName);
                TypeDescription array = groupMember.getResultType();
                ObjectTypeDescription groupType = array.getElementType().asObject();
                return this.getType(this.getGroupXOAttName(dataId), groupType);
            }
            case 3: {
                String groupItemDataId = this.getGroupItemDataId(dataId);
                AttributeTypeDescription groupItemMember = objectTypeDescription.findAttribute(groupItemDataId);
                TypeDescription arrayItem = groupItemMember.getResultType();
                ObjectTypeDescription groupItemType = arrayItem.getElementType().asObject();
                return this.getType(this.getGroupItemAttName(dataId), groupItemType);
            }
        }
        return objectTypeDescription.findMember(dataId);
    }

    private String getGroupItemDataId(String attName) {
        assert (this.isGroupItemAttName(attName));
        int endIndex = attName.indexOf(91);
        return attName.substring(0, endIndex);
    }

    private int getGroupItemIndex(String attName) {
        assert (this.isGroupItemAttName(attName));
        int start = attName.indexOf(91) + 1;
        int end = attName.indexOf(93);
        String s = attName.substring(start, end);
        return Integer.parseInt(s);
    }

    private XObjectInstance getXObjectInstanceFromMethodSignature(String targetDataId, Integer index) throws InvalidXOAttributeException {
        assert (targetDataId != null) : "Target dataId must not be null";
        XObjectInstance xo = this;
        String[] dataIds = targetDataId.split("\\.");
        block4: for (int i = 0; i < dataIds.length - 1; ++i) {
            String dataId = dataIds[i] + ".";
            int attrType = this.getXObjectAttNameType(dataId);
            switch (attrType) {
                case 1: {
                    xo = xo.getInnerXObjectInstance(dataId);
                    continue block4;
                }
                case 2: {
                    xo = xo.getGroupXObjectInstance(this.getGroupDataId(dataId), index);
                    continue block4;
                }
            }
        }
        return xo;
    }

    private void initilize(Object instance, ObjectTypeDescription objectType) {
        if (this.isInterpreted()) {
            this.invokeable = (Invokeable)instance;
            this.xobj = this.invokeable.getType() instanceof XObjectTypeDescription ? this.invokeable.asInterface(PRES_MODIF_INTERF) : this.invokeable.asInterface(PRES_INTERF);
        } else {
            this.invokeable = instance instanceof Invokeable ? (Invokeable)instance : new JavaObject<Object>(instance);
            this.xobj = instance;
        }
        this.innerXOMap = new HashMap<String, XObjectInnerCacheReference>(0, 5.0f);
        this.initObjectType(objectType);
    }

    private Object newGroupRowInstance(String groupDataId) throws InvalidXOAttributeException {
        int attrType = this.getXObjectAttNameType(groupDataId);
        switch (attrType) {
            case 1: {
                XObjectInstance innerXO = this.getInnerXObjectInstance(groupDataId);
                return innerXO.newGroupRowInstance(this.getInnerXOAttName(groupDataId));
            }
            case 2: {
                return this.newGroupRowInstance(this.getGroupDataId(groupDataId));
            }
        }
        try {
            GroupArray groupArray = this.getGroupArray(groupDataId);
            return groupArray.createNewElement();
        }
        catch (XObjectInternalException e) {
            throw new InvalidXOAttributeException(e);
        }
        catch (Exception e) {
            throw new InvalidXOAttributeException(e);
        }
    }

    private void setPD(PresentableDelegate pd) throws ComponentExecutionException, InvocationTargetException {
        String sig = "Mset__presentableDelegate_delegate(Lfuego.xobject.runtime.components.PresentableDelegate;)V";
        this.invokeMethod(sig, new Object[]{pd});
    }

    private PresentableDelegate getPD() throws InvocationTargetException, ComponentExecutionException {
        String sig = "Mget__presentableDelegate_delegate()Lfuego.xobject.runtime.components.PresentableDelegate;";
        return (PresentableDelegate)this.invokeMethod(sig, null);
    }

    private String getAttReadSignature(String dataId) {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return this.objectType.getSignature(attrType);
    }

    private String getAttWriteSignature(String dataId) {
        AttributeTypeDescription attrType = this.getAttrType(dataId, this.objectType);
        return this.objectType.getWriteSignature(attrType);
    }

    private String getGroupItemAttName(String attName) {
        assert (this.isGroupItemAttName(attName));
        return attName.substring(attName.indexOf(46) + 1);
    }

    private String getInnerDataId(String attName) {
        assert (this.isInnerXOAttName(attName));
        return attName.substring(0, attName.indexOf(46));
    }

    private String getInnerXOAttName(String attName) {
        assert (this.isInnerXOAttName(attName));
        return attName.substring(attName.indexOf(46) + 1);
    }

    private Object getXOInterpretedResource(String resName) {
        return this.invokeable.getResource(resName);
    }

    private Object getXOResource(String resName, int type) throws XObjectRuntimeInternalException {
        Object result = null;
        if (this.isInterpreted()) {
            switch (type) {
                case 0: {
                    Map presentations = (Map)this.getXOInterpretedResource("presentationsRes");
                    assert (presentations != null);
                    result = presentations.get(resName);
                    break;
                }
                case 1: {
                    result = this.getXOInterpretedResource("i18nRes");
                    break;
                }
            }
        } else {
            result = this.getXORuntimeResource(this.getName() + "." + resName);
        }
        return result;
    }

    private Object getXORuntimeResource(String resName) throws XObjectRuntimeInternalException {
        Object result = null;
        ClassLoader classLoader = null;
        if (Component.isRunningOnClientSide()) {
            try {
                classLoader = this.xobj.getClass().getClassLoader();
                FuegoObjectCatalog runtime = FuegoObjectCatalog.getFrom(classLoader);
                if (runtime != null) {
                    result = runtime.getResource(resName);
                } else {
                    result = FuegoObjectCatalog.instantiate(classLoader, resName);
                    if (result == null) {
                        throw new ClassNotFoundException(resName);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                Msg msg = XObjectRuntimeMsg.XOBJ_INT_0002(resName, classLoader.toString());
                throw new XObjectRuntimeInternalException(msg, (Throwable)e);
            }
            catch (IOException e) {
                if (Log.isDebugging()) {
                    Log.logDebug(e);
                }
                Msg msg = XObjectRuntimeMsg.XOBJ_INT_0003(classLoader.toString());
                throw new XObjectRuntimeInternalException(msg, (Throwable)e);
            }
        }
        return result;
    }

    private String parseAtrSignature(String attributeSignature) {
        if (attributeSignature != null && attributeSignature.indexOf(";)") != -1 && attributeSignature.indexOf(40) != -1) {
            return attributeSignature.substring(attributeSignature.indexOf(40) + 2, attributeSignature.indexOf(59));
        }
        return null;
    }

    private String[] parseMethodSignature(String methodSignature) {
        assert (methodSignature != null) : "The methodSignature must not be null";
        int sepatatorChar = 58;
        int indexOfSeparator = methodSignature.indexOf(sepatatorChar);
        String[] data = null;
        if (indexOfSeparator != -1) {
            data = new String[]{methodSignature.substring(0, indexOfSeparator + 1), methodSignature.substring(indexOfSeparator + 1, methodSignature.length())};
        }
        return data;
    }

    private void pollXObjectInnerCacheReference() {
        Reference<XObjectInstance> reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            XObjectInnerCacheReference xoResourceCacheReference = (XObjectInnerCacheReference)reference;
            this.innerXOMap.remove(xoResourceCacheReference.getKey());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.objectType == null ? null : this.objectType.getText());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String typeText = (String)in.readObject();
        if (typeText != null) {
            this.objectType = FuegoClass.forName(typeText, this.xobj.getClass().getClassLoader());
        }
        this.innerXOMap = new HashMap<String, XObjectInnerCacheReference>(0, 5.0f);
        this.referenceQueue = new ReferenceQueue();
    }

    private static class XObjectInnerCacheReference
    extends SoftReference<XObjectInstance> {
        private String key_d;

        public XObjectInnerCacheReference(String key, XObjectInstance referent, ReferenceQueue<XObjectInstance> q) {
            super(referent, q);
            this.key_d = key;
        }

        public String getKey() {
            return this.key_d;
        }
    }
}

