/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.component.Component;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ValidationException;
import oracle.bpm.log.Log;
import oracle.bpm.xobject.presentationmodel.XFormPresentationXMLObject;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;
import oracle.bpm.xobject.runtime.ConstraintReport;
import oracle.bpm.xobject.runtime.ErrorListener;
import oracle.bpm.xobject.runtime.ExecutionListener;
import oracle.bpm.xobject.runtime.FinishFOExecution;
import oracle.bpm.xobject.runtime.InvalidXOAttributeException;
import oracle.bpm.xobject.runtime.ShowFOExecution;
import oracle.bpm.xobject.runtime.XOExecutionController;
import oracle.bpm.xobject.runtime.XORuntimeManager;
import oracle.bpm.xobject.runtime.XObjectInstance;
import oracle.bpm.xobject.runtime.XObjectRunnerException;
import oracle.bpm.xobject.runtime.XScreen;
import oracle.bpm.xobject.runtime.components.Executor;
import oracle.bpm.xobject.runtime.presentationComponents.XOGroupComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOInputComponent;
import oracle.bpm.xobject.runtime.presentationComponents.XOPresentationComponent;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public abstract class AbstractXScreen
implements XScreen,
Serializable {
    private ErrorListener errorListener;
    private ExecutionListener executionListener;
    private final List<String> groupComponentIds;
    private final String identifier;
    private String initializationMethod;
    private boolean isCssEnabled = false;
    private final Map<String, XOPresentationComponent> presComponentsIds;
    private final Map<String, XOPresentationComponent> presComponentsReferences;
    private final List<String> requiredComponentsIds;
    private XORuntimeManager rManager;
    static final long serialVersionUID = -4079971725026568847L;
    private static final String CHECK_METHOD_SIGNATURE = "M_check()V";
    static final long serialCheck = -4228682502152685106L;

    protected AbstractXScreen() {
        this(null);
    }

    protected AbstractXScreen(XORuntimeManager rMgr) {
        this.rManager = rMgr;
        this.presComponentsIds = new HashMap<String, XOPresentationComponent>();
        this.presComponentsReferences = new HashMap<String, XOPresentationComponent>();
        this.requiredComponentsIds = new ArrayList<String>();
        this.groupComponentIds = new ArrayList<String>();
        this.identifier = this.buildId();
    }

    @Override
    public abstract void printPresentation();

    @Override
    public boolean isCssEnabled() {
        return this.isCssEnabled;
    }

    public String getDataIdtWithPressId(String pressId) {
        return this.getPresComponentWithId(pressId).getReference();
    }

    @Override
    public boolean isDisplay() {
        return this.getRuntimeManager().isDisplay();
    }

    @Override
    public boolean isEditor() {
        return this.getRuntimeManager().isEditor();
    }

    public final void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public final void setExecutionListener(ExecutionListener doneListener) {
        this.executionListener = doneListener;
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setInitializer(String method) {
        this.initializationMethod = method;
    }

    @Override
    public Locale getLocale() {
        return this.getRuntimeManager().getLocale();
    }

    @Override
    public XOPresentationComponent getPresComponentWithId(String pressId) {
        return this.presComponentsIds.get(pressId);
    }

    @Override
    public XOInputComponent getPresComponentWithRef(String dataId) {
        return (XOInputComponent)this.presComponentsReferences.get(dataId);
    }

    @Override
    public Map getPresComponentsId() {
        return this.presComponentsIds;
    }

    @Override
    public Map getPresComponentsReference() {
        return this.presComponentsReferences;
    }

    @Override
    public List getGroupComponentIds() {
        return this.groupComponentIds;
    }

    public String getPressIdtWithDataId(String dataId) {
        return this.getPresComponentWithRef(dataId).getId();
    }

    @Override
    public boolean isPreview() {
        return this.getRuntimeManager().isPreview();
    }

    @Override
    public final XORuntimeManager getRuntimeManager() {
        return this.rManager;
    }

    public XOExecutionController getExecutionController() {
        return this.getRuntimeManager().getExecutionController();
    }

    @Override
    public boolean isShow() {
        return this.getRuntimeManager().isShow();
    }

    @Override
    public XObjectInstance getXO() {
        return this.getRuntimeManager().getXObject();
    }

    @Override
    public void enableCss(boolean isCssEnabled) {
        this.isCssEnabled = isCssEnabled;
    }

    @Override
    public void initialize() throws ComponentExecutionException {
        String signature = this.initializationMethod;
        if (signature != null && !signature.equals("")) {
            try {
                this.invokeMethod(signature, null, null);
                this.refresh(false);
            }
            catch (ComponentExecutionException e) {
                ComponentExecutionException exception = new ComponentExecutionException(XObjectRuntimeMsg.XOBJ_INIT_PRES_0001(this.getRuntimeManager().getPresentationName()));
                exception.initCause(e);
                throw e;
            }
        }
    }

    @Override
    public final boolean processAction(String methodInvocation, Integer index) {
        return this.processAction(methodInvocation, index, null);
    }

    @Override
    public final boolean processAction(String methodInvocation, Integer index, Object[] args) {
        if (this.isPreview()) {
            return false;
        }
        try {
            this.invokeMethod(methodInvocation, index, args);
        }
        catch (FinishFOExecution e) {
            if (e.isMainExecution()) {
                this.executionListener.registerFinishMainExecutionEvent(e.getId());
            } else {
                this.executionListener.registerFinishChildExecutionEvent();
            }
            boolean bl = true;
            return bl;
        }
        catch (ShowFOExecution e) {
            try {
                this.executionListener.registerStartChildExecutionEvent();
                this.getExecutionController().startChildExecution(e.getInstance(), e.getPresentationName());
            }
            catch (ComponentExecutionException e1) {
                if (this.errorListener != null) {
                    this.errorListener.unrecoverableError(e1);
                    boolean bl = false;
                    return bl;
                }
                throw new RuntimeException(e1);
            }
        }
        catch (ComponentExecutionException e) {
            if (this.errorListener != null) {
                this.errorListener.unrecoverableError(e);
                boolean bl = false;
                return bl;
            }
            throw new RuntimeException(e);
        }
        finally {
            this.refresh(false);
        }
        return true;
    }

    @Override
    public final boolean processCancel() {
        if (this.isPreview()) {
            return false;
        }
        this.reset();
        XOExecutionController controller = this.getExecutionController();
        if (controller.isMainExecution()) {
            controller.cleanChildExecutions();
            throw FinishFOExecution.finishMainExecutionException(null);
        }
        controller.finishChildExecution();
        throw FinishFOExecution.finishShowExecutionException();
    }

    @Override
    public final boolean processPrint() {
        if (this.isPreview()) {
            return false;
        }
        this.printPresentation();
        return true;
    }

    @Override
    public final boolean processRefresh() {
        if (this.isPreview()) {
            return false;
        }
        this.refresh(true);
        return true;
    }

    @Override
    public final boolean processReset() {
        if (this.isPreview()) {
            return false;
        }
        this.reset();
        return true;
    }

    @Override
    public final boolean processSave(String id) {
        if (this.isPreview()) {
            return false;
        }
        throw new FinishFOExecution(id);
    }

    @Override
    public final boolean processSubmit(String id) {
        boolean areErrors;
        if (this.isPreview()) {
            return false;
        }
        ConstraintReport[] requiredErrors = this.checkRequiredFields();
        ConstraintReport[] checkErrors = this.checkErrors();
        boolean bl = areErrors = this.hasErrorsToShow() || requiredErrors != null || checkErrors != null;
        if (areErrors) {
            ArrayList<ConstraintReport> errorList = new ArrayList<ConstraintReport>();
            if (requiredErrors != null) {
                errorList.addAll(Arrays.asList(requiredErrors));
            }
            if (checkErrors != null) {
                errorList.addAll(Arrays.asList(checkErrors));
            }
            ConstraintReport[] errors = errorList.toArray(new ConstraintReport[errorList.size()]);
            this.showErrors(errors);
            return false;
        }
        XOExecutionController controller = this.getExecutionController();
        if (controller.isMainExecution()) {
            controller.cleanChildExecutions();
            throw FinishFOExecution.finishMainExecutionException(id);
        }
        controller.finishChildExecution();
        throw FinishFOExecution.finishShowExecutionException();
    }

    @Override
    public boolean isRequired(String dataId) {
        return this.requiredComponentsIds.contains(dataId);
    }

    @Override
    public void fireChangeEvent(String presId) {
    }

    @Override
    public void registerComponent(String pressId, String dataId, XOPresentationComponent comp) {
        XFormPresentationXMLObject formPresentationXMLObject;
        if (pressId == null) {
            // empty if block
        }
        this.presComponentsIds.put(pressId, comp);
        if (dataId != null) {
            this.presComponentsReferences.put(dataId, comp);
            if (comp instanceof XOGroupComponent) {
                this.groupComponentIds.add(pressId);
            }
        }
        if ((formPresentationXMLObject = comp.getPresentationXMLObject()) instanceof XFormUserInputPresentationXMLObject) {
            boolean required = ((XFormUserInputPresentationXMLObject)comp.getPresentationXMLObject()).isPresentationRequired();
            this.registerRequired(required, dataId);
        }
    }

    @Override
    public void registerRequired(boolean required, String dataId) {
        if (required) {
            this.requiredComponentsIds.add(dataId);
        } else {
            this.requiredComponentsIds.remove(dataId);
        }
    }

    @Override
    public final void showError(ConstraintReport error) {
        ConstraintReport[] errors = new ConstraintReport[]{error};
        this.showErrors(errors);
    }

    private String buildId() {
        return this.getRuntimeManager() != null ? String.valueOf(this.getRuntimeManager().getExecutionStackPosition()) : String.valueOf(System.currentTimeMillis());
    }

    private ConstraintReport[] checkErrors() {
        try {
            this.getXO().invokeMethod(CHECK_METHOD_SIGNATURE, null);
        }
        catch (Throwable e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof ValidationException) {
                ArrayList<ConstraintReport> valExceptionReportList = new ArrayList<ConstraintReport>();
                for (ValidationException valException = (ValidationException)cause; valException != null; valException = valException.getNext()) {
                    XOInputComponent component;
                    StringBuffer checkMessageBuffer = new StringBuffer();
                    String dataMessage = valException.getMessage();
                    if (dataMessage == null || dataMessage.trim().length() == 0) {
                        dataMessage = XObjectRuntimeMsg.CHECK_EXP_FAIL.getString();
                    }
                    if ((component = this.getPresComponentWithRef(valException.getSource())) != null) {
                        XFormPresentationXMLObject presentationXMLObject = component.getPresentationXMLObject();
                        if (presentationXMLObject instanceof XFormUserInputPresentationXMLObject) {
                            String presMsg = ((XFormUserInputPresentationXMLObject)presentationXMLObject).getValidationMessage();
                            if (presMsg != null && presMsg.trim().length() > 0) {
                                presMsg = component.getI18NText(presMsg);
                                checkMessageBuffer.append(presMsg);
                                checkMessageBuffer.append(" (");
                                checkMessageBuffer.append(dataMessage);
                                checkMessageBuffer.append(").");
                            } else {
                                checkMessageBuffer.append(dataMessage);
                            }
                        }
                    } else {
                        checkMessageBuffer.append(dataMessage);
                    }
                    valExceptionReportList.add(ConstraintReport.getCheckErrorReportInstance(valException.getSource(), checkMessageBuffer.toString()));
                }
                return valExceptionReportList.toArray(new ConstraintReport[valExceptionReportList.size()]);
            }
            XObjectRunnerException xobjectRunnerException = new XObjectRunnerException(XObjectRuntimeMsg.XOBJ_CHECK_ERROR(this.getXO().getName(), cause.getMessage()));
            xobjectRunnerException.setStackTrace(cause.getStackTrace());
            throw new RuntimeException(xobjectRunnerException);
        }
        return null;
    }

    private ConstraintReport[] checkRequiredFields() {
        ArrayList<ConstraintReport> componentsWithError = new ArrayList<ConstraintReport>();
        for (String dataId : this.requiredComponentsIds) {
            XOInputComponent comp = this.getPresComponentWithRef(dataId);
            XObjectInstance xo = this.getXO();
            try {
                boolean isStringAttr;
                boolean bl = isStringAttr = xo.getAttributeKind(dataId) == 5;
                if (comp.isGroupColumnComponent()) {
                    XOGroupComponent group = comp.getGroup();
                    String groupDataId = group.getReference();
                    String columnDataId = group.getDataIdtWithPressId(comp.getId());
                    int groupSize = this.getXO().getGroupSize(groupDataId);
                    for (int j = 0; j < groupSize; ++j) {
                        Object groupAttributeValue = xo.getGroupAttributeValue(groupDataId, columnDataId, j);
                        if (isStringAttr && groupAttributeValue != null) {
                            Object object = groupAttributeValue = ((String)groupAttributeValue).trim().length() > 0 ? groupAttributeValue : null;
                        }
                        if (groupAttributeValue != null) continue;
                        componentsWithError.add(ConstraintReport.getRequiredErrorReportInstance(groupDataId, columnDataId, XObjectRuntimeMsg.REQUIRED_VALUE.getString(), j));
                    }
                    continue;
                }
                Object attributeValue = xo.getAttributeValue(dataId);
                if (isStringAttr && attributeValue != null) {
                    Object object = attributeValue = ((String)attributeValue).trim().length() > 0 ? attributeValue : null;
                }
                if (attributeValue != null) continue;
                componentsWithError.add(ConstraintReport.getRequiredErrorReportInstance(dataId, XObjectRuntimeMsg.REQUIRED_VALUE.getString()));
            }
            catch (InvalidXOAttributeException e) {
                Log.logWarning(e);
            }
        }
        if (componentsWithError.isEmpty()) {
            return null;
        }
        return componentsWithError.toArray(new ConstraintReport[componentsWithError.size()]);
    }

    private void invokeMethod(String methodInvocation, Integer index, Object[] args) throws ComponentExecutionException {
        if (!Component.isRunningOnDebugger() && !Component.isRunningOnBrowser()) {
            Executor.setCurrent(this.getXO().getExecutor());
        }
        this.getRuntimeManager().invokeActionMethod(methodInvocation, index, args);
    }

    private void refresh(boolean force) {
        this.getRuntimeManager().refreshPresentation(force);
    }

    private void reset() {
        this.getXO().reset();
        this.refresh(true);
    }
}

