/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalFormat;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeFormatException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeWriter45;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.JarWrapper;
import oracle.bpm.xobject.XObjectFactory;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.MethodUsagesRemover;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;
import oracle.bpm.xobject.presentationmodel.XFormBackground;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModelHelper;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobject.runtime.components.Presentable;
import oracle.bpm.xobject.xml.XFormXMLObject;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

@Deprecated
public class XObjectTypeDescriptionHelper {
    public static final String DEFAULT_PRES_NAME = "defaultPres";
    public static final String VVAL_POST_MTD = "ValidValues";
    public static final String VVAL_DESC_MTD_SIGN_PROP = "validValuesDescriptionMethodSignature";
    public static final String VVAL_DESC_MTD_NAME_PROP = "validValuesDescriptionMethodName";
    public static final String VVAL_DESC_LIST = "validValuesDescriptionList";
    public static final int none_index = 0;
    public static final int list_index = 1;
    public static final int method_index = 2;

    public static int getAttributeCount(ObjectTypeDescription xo) {
        int result = 0;
        int memberCount = xo.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            MethodTypeDescription member = xo.getMemberType(i);
            if (!member.isAttribute()) continue;
            ++result;
        }
        return result;
    }

    public static boolean isAutoGenerated(MethodTypeDescription mtd) {
        return XObjectTypeDescriptionHelper.isValidValuesMethod(mtd);
    }

    public static void setCached(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x10000000000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFEFFFFFFFFFFL);
        }
    }

    public static void setDefaultPresentationName(XObjectTypeDescription parent, String name) {
        String current = parent.getDefaultPresentationName();
        if (current == null || !name.equals(current)) {
            parent.setDefaultPresentationName(name);
        }
    }

    public static boolean isEditableMethod(MethodTypeDescription mtd) {
        return !XObjectTypeDescriptionHelper.isValidValuesMethod(mtd);
    }

    public static boolean isFuegoObjectInternalMethodName(String methodName) {
        if (methodName == null) {
            return false;
        }
        if ("validate".equals(methodName)) {
            return false;
        }
        for (Method mtd : Presentable.class.getMethods()) {
            if (!methodName.equals(mtd.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFuegoObjectReservedName(String name) {
        return name != null && name.endsWith(VVAL_POST_MTD);
    }

    public static boolean isFuegoObjectUnrecommendedName(String name) {
        return name != null && (name.startsWith("get") || name.startsWith("set"));
    }

    public static boolean isGroup(AttributeTypeDescription attr) {
        TypeDescription parent = attr.getParent();
        return parent != null && parent.isBpmObject() && XObjectTypeDescription.isGroupAttribute(attr);
    }

    public static boolean isLegacyXO(ObjectTypeDescription xotd) {
        String legacy = xotd.getProperty("legacy");
        return legacy != null && "true".equals(legacy);
    }

    public static MethodTypeDescription getMemberFor(String name, ObjectTypeDescription xtd) {
        int dot = name.indexOf(46);
        int brace = name.indexOf(91);
        if (dot < 0) {
            return xtd.findAttribute(name);
        }
        String attName = name.substring(0, brace > 0 && brace < dot ? brace : dot);
        String restName = name.substring(dot + 1);
        AttributeTypeDescription td = xtd.findAttribute(attName);
        if (td != null) {
            TypeDescription resultType = td.getResultType();
            if (resultType.isArray() && resultType.getElementType().isInnerType()) {
                return XObjectTypeDescriptionHelper.getMemberFor(restName, (ObjectTypeDescription)resultType.getElementType());
            }
            if (resultType instanceof ObjectTypeDescription) {
                return XObjectTypeDescriptionHelper.getMemberFor(restName, (ObjectTypeDescription)resultType);
            }
        }
        return null;
    }

    public static void setPrivate(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFF7FFFL);
            mtd.setModifiers(mtd.getModifiers() | 0x2000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() | 0x8000L);
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFDFFFL);
        }
    }

    public static void setPublic(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x8000L);
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFDFFFL);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFF7FFFL);
            mtd.setModifiers(mtd.getModifiers() | 0x2000L);
        }
    }

    public static XFormPresentationModel[] getReferencedPresentations(ObjectTypeDescription memberParent, MethodTypeDescription member) {
        ObjectTypeDescription mainXotd = memberParent;
        String relativeMemberName = member.getName();
        String relativeSignature = member.getSignature();
        if (memberParent.isInnerType()) {
            mainXotd = (XObjectTypeDescription)memberParent.getParent();
            String groupName = memberParent.getName();
            relativeMemberName = XObjectTypeDescriptionHelper.getPresentationGroupAttributeName(groupName, relativeMemberName);
            relativeSignature = XObjectTypeDescriptionHelper.getRelativeSignature(groupName, relativeSignature);
        }
        if (mainXotd.hasModifiers(0x40000000L)) {
            XObjectTypeDescription xobject = (XObjectTypeDescription)mainXotd;
            XFormPresentationModel[] models = xobject.getPModels();
            ArrayList<XFormPresentationModel> modelsRef = new ArrayList<XFormPresentationModel>();
            boolean isMethod = member.isMethod();
            boolean isAttribute = member.isAttribute();
            if (models != null) {
                for (XFormPresentationModel model : models) {
                    if (isAttribute && model.hasReferenceTo(relativeMemberName)) {
                        modelsRef.add(model);
                    }
                    if (!isMethod || !model.invokes(relativeSignature)) continue;
                    modelsRef.add(model);
                }
                if (!modelsRef.isEmpty()) {
                    return modelsRef.toArray(new XFormPresentationModel[modelsRef.size()]);
                }
            }
        }
        return null;
    }

    public static boolean isRemovableMethod(MethodTypeDescription mtd) {
        return !mtd.isConstructor() && !XObjectTypeDescriptionHelper.isValidValuesMethod(mtd);
    }

    public static void setResultType(MethodTypeDescription mtd, TypeRef resultType) {
        mtd.setResultType(resultType);
    }

    public static void setServerSide(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x10000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFEFFFFL);
        }
        XObjectTypeDescriptionHelper.setClientAvailable(mtd);
    }

    public static void setStatic(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x40L);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFFFBFL);
        }
    }

    public static boolean isSuitableValidValuesProvider(MethodTypeDescription member) {
        boolean result;
        boolean isAttribute = member.isAttribute();
        if (isAttribute) {
            long modifiers = member.getModifiers();
            boolean hasGetter = Modifier.hasGetter(modifiers) && member.asAttribute().getCode() != null;
            result = !member.asAttribute().isVirtual() || hasGetter;
        } else {
            result = member.getArgumentCount() == 0;
        }
        return result;
    }

    public static boolean isValidAttName(ObjectTypeDescription parent, String name) {
        try {
            return XObjectTypeDescriptionHelper.validateAttributeName(parent, name);
        }
        catch (ConstructionException ce) {
            return false;
        }
    }

    public static boolean isValidGroupName(ObjectTypeDescription parent, String name) throws ConstructionException {
        boolean matchesParentName = name.equalsIgnoreCase(parent.getName());
        if (matchesParentName) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0005(name));
        }
        return XObjectTypeDescriptionHelper.validateAttributeName(parent, name) && !matchesParentName;
    }

    public static boolean isValidMethodName(ObjectTypeDescription parent, String name) {
        try {
            return XObjectTypeDescriptionHelper.validateMethodName(parent, name, false);
        }
        catch (ConstructionException ce) {
            return false;
        }
    }

    public static boolean isValidPresentationName(XObjectTypeDescription parent, String name) {
        try {
            return XObjectTypeDescriptionHelper.validatePresentationName(parent, name);
        }
        catch (ConstructionException ce) {
            return false;
        }
    }

    public static void setValidValuesDefinition(AttributeTypeDescription attr, int type, List<Tuple<String, String>> validValues, MethodTypeDescription validValuesMethod, boolean hasDescription) {
        if (type == 0) {
            XObjectTypeDescriptionHelper.removeValidValuesDefinition(attr);
            return;
        }
        ObjectTypeDescription parent = (ObjectTypeDescription)attr.getParent();
        StringBuffer methodCode = null;
        switch (type) {
            case 1: {
                Iterator<Tuple<String, String>> it = validValues.iterator();
                StringList validValuesList = StringList.create();
                StringList validValuesDescrList = StringList.create();
                StringBuilder descriptionStrBuffer = new StringBuilder();
                while (it.hasNext()) {
                    Tuple<String, String> each = it.next();
                    String value = each.getFirst();
                    String descr = each.getSecond();
                    if ("".equals(value.trim())) continue;
                    validValuesList.add(value);
                    validValuesDescrList.add(descr);
                    descriptionStrBuffer.append(descr);
                    if (!it.hasNext()) continue;
                    descriptionStrBuffer.append(",");
                }
                methodCode = new StringBuffer();
                attr.setProperty(VVAL_DESC_MTD_SIGN_PROP, null);
                attr.setProperty(VVAL_DESC_MTD_NAME_PROP, null);
                attr.setValidValuesMethod(null);
                attr.setValidValues(validValuesList);
                if (hasDescription) {
                    attr.setProperty(VVAL_DESC_LIST, descriptionStrBuffer.toString());
                    methodCode.append(XObjectTypeDescriptionHelper.buildFBLMapCode(validValuesList, validValuesDescrList, attr.getType(), false));
                } else {
                    attr.setProperty(VVAL_DESC_LIST, null);
                    methodCode.append(XObjectTypeDescriptionHelper.buildFBLListCode(validValuesList, attr.getType(), false));
                }
                methodCode.append("\n");
                break;
            }
            case 2: {
                if (validValuesMethod == null) break;
                String methodName = validValuesMethod.getName() + (validValuesMethod instanceof AttributeTypeDescription ? "" : "()");
                methodCode = new StringBuffer();
                methodCode.append("return ");
                methodCode.append(methodName);
                methodCode.append("\n");
                if (!hasDescription) {
                    attr.setProperty(VVAL_DESC_MTD_NAME_PROP, null);
                    attr.setProperty(VVAL_DESC_MTD_SIGN_PROP, null);
                } else {
                    attr.setProperty(VVAL_DESC_MTD_NAME_PROP, validValuesMethod.getName());
                    attr.setProperty(VVAL_DESC_MTD_SIGN_PROP, validValuesMethod.getSignature());
                }
                attr.setProperty(VVAL_DESC_LIST, null);
                attr.setValidValues(null);
                attr.setValidValuesMethod(validValuesMethod.getName());
            }
        }
        if (methodCode != null) {
            XObjectTypeDescriptionHelper.addValidValuesDefinition(parent, attr, methodCode, hasDescription);
        } else {
            XObjectTypeDescriptionHelper.removeValidValuesDefinition(attr);
        }
    }

    public static boolean isValidValuesMethod(MethodTypeDescription mtd) {
        ObjectTypeDescription parent = (ObjectTypeDescription)mtd.getParent();
        String methodName = mtd.getName();
        int index = methodName.lastIndexOf(VVAL_POST_MTD);
        boolean result = false;
        if (index > 0 && parent != null) {
            String attName = methodName.substring(0, index);
            result = parent.findAttribute(attName) != null;
        }
        return result;
    }

    public static void setXOPresentable(XObjectTypeDescription xo, boolean p) {
        TypeRef type;
        ComponentCatalog catalog = xo.getCatalog();
        assert (catalog != null) : "Null catalog for " + xo;
        xo.setPresentable(p);
        TypeRef presentableDelegateType = null;
        TypeRef presentableType = null;
        TypeRef nonPresentableType = null;
        try {
            type = catalog.find("Fuego.Internal.XODelegate");
            presentableDelegateType = catalog.find("Fuego.Internal.PresentableDelegate");
            presentableType = catalog.find("Fuego.Lang.Presentable");
            nonPresentableType = catalog.find("Fuego.Internal.FuegoObject");
        }
        catch (AmbiguousTypeNameException e) {
            type = e.getMalformedType();
        }
        assert (type != null);
        SuperType XO_DELEGATE = new SuperType(type, 0x2808000L);
        SuperType presentableDelegate = new SuperType(presentableDelegateType, 0x2808000L);
        SuperType presentable = new SuperType(presentableType, 32768L);
        SuperType nonPresentable = new SuperType(nonPresentableType, 0x2008000L);
        if (xo.isPresentable()) {
            xo.setSuperTypes(new SuperType[]{presentableDelegate, XO_DELEGATE, presentable, SuperType.getAny()});
        } else {
            xo.setSuperTypes(new SuperType[]{SuperType.getAny(), nonPresentable, XO_DELEGATE});
        }
    }

    public static boolean isXObjectTypeDescription(ObjectTypeDescription obj, ComponentCatalog catalog) {
        TypeRef type;
        try {
            type = catalog.find("Fuego.Internal.XODelegate");
        }
        catch (AmbiguousTypeNameException e) {
            type = e.getMalformedType();
        }
        assert (type != null);
        SuperType XO_DELEGATE = new SuperType(type, 0x2808000L);
        return XO_DELEGATE.getType().isAssignableFrom(obj);
    }

    public static AttributeTypeDescription addAttribute(ObjectTypeDescription parent, String name, TypeRef td, SourceCode calculateExpression) throws ConstructionException {
        XObjectTypeDescriptionHelper.validateAttributeName(parent, name);
        AttributeTypeDescription member = XObjectTypeDescriptionHelper.createAttribute(name, td.get().setReferenceType(true), calculateExpression);
        parent.addMember(member);
        return member;
    }

    public static XFormPresentationModel addDefaultPresentationModel(XObjectTypeDescription otd, String name) throws ConstructionException {
        if (!otd.isPresentable()) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0002);
        }
        XObjectTypeDescriptionHelper.validatePresentationName(otd, name);
        XFormPresentationModel presentationModel = XFormPresentationModelHelper.generateDefaultPresentation(otd, name);
        otd.setPModel(presentationModel, name);
        return presentationModel;
    }

    public static XFormPresentationModel addDefaultPresentationModel(XObjectTypeDescription otd) throws ConstructionException {
        return XObjectTypeDescriptionHelper.addDefaultPresentationModel(otd, DEFAULT_PRES_NAME);
    }

    public static AttributeTypeDescription addGroupAttribute(ObjectTypeDescription parent, String name, ObjectTypeDescription groupType) throws ConstructionException {
        if (!groupType.getParent().equals(parent)) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0003(groupType.getName()));
        }
        if (groupType.isBpmObject()) {
            XObjectTypeDescription.addConstructors(groupType);
        }
        ArrayTypeDescription arrayType = TypeFactory.getArray(groupType);
        arrayType.setJavaType("oracle.bpm.xobject.GroupArray");
        AttributeTypeDescription groupAttr = new AttributeTypeDescription(name, arrayType, 32776L);
        XObjectTypeDescriptionHelper.attributeDefaultModifiers(groupAttr);
        String typeSignature = groupAttr.getResultType().getJavaSignature();
        groupAttr.setReadSignature(JavaClass.createGetAttrSignature(name, typeSignature));
        groupAttr.setWriteSignature(JavaClass.createSetAttrSignature(name, typeSignature));
        parent.addMember(groupAttr);
        return groupAttr;
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, Argument[] inputArgs) throws ConstructionException {
        return XObjectTypeDescriptionHelper.addMethod(obj, name, returnType, inputArgs, null, null);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, Argument[] inputArgs, String code, String codeLanguage) throws ConstructionException {
        XObjectTypeDescriptionHelper.validateMethodName(obj, name, false);
        MethodTypeDescription methodTD = XObjectTypeDescriptionHelper.createMethod(name, returnType, inputArgs, code, codeLanguage);
        return XObjectTypeDescriptionHelper.doAddMethod(obj, methodTD);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, TypeDescription[] inputArgTypes) throws ConstructionException {
        return XObjectTypeDescriptionHelper.addMethod(obj, name, returnType, inputArgTypes, null, null);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, TypeDescription[] inputArgTypes, String code, String codeLanguage) throws ConstructionException {
        Argument[] inputArgs = new Argument[inputArgTypes == null ? 0 : inputArgTypes.length];
        for (int i = 0; i < inputArgs.length; ++i) {
            inputArgs[i] = new Argument("arg" + i, inputArgTypes == null ? null : inputArgTypes[i], 1L);
        }
        return XObjectTypeDescriptionHelper.addMethod(obj, name, returnType, inputArgs, code, codeLanguage);
    }

    public static XFormPresentationModel addPresentationModel(XObjectTypeDescription otd, String name, int row, int col, String color) throws ConstructionException {
        if (!otd.isPresentable()) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0002);
        }
        XObjectTypeDescriptionHelper.validatePresentationName(otd, name);
        XFormPresentationModel presentationModel = XObjectTypeDescriptionHelper.createPresentationModel(otd, name, row, col, color);
        otd.setPModel(presentationModel, name);
        XObjectTypeDescriptionHelper.ensureParents(presentationModel);
        return presentationModel;
    }

    public static XFormPresentationModel addPresentationModel(XObjectTypeDescription otd, String name, PresentationGenerationOptions options, String[] includedUngroupedAttributes, String[] includedGroups, Hashtable includedGroupedAttributes, Hashtable includedInnerXOSAttributes) throws ConstructionException {
        if (!otd.isPresentable()) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0002);
        }
        XFormPresentationModel presentationModel = XFormPresentationModelHelper.generateDefaultPresentation(otd, name, options, includedUngroupedAttributes, includedGroups, includedGroupedAttributes, includedInnerXOSAttributes);
        otd.setPModel(presentationModel, name);
        XObjectTypeDescriptionHelper.ensureParents(presentationModel);
        return presentationModel;
    }

    public static XFormPresentationModel addPresentationModel(XObjectTypeDescription otd, String name, PresentationGenerationOptions options, Map attributesmap) throws ConstructionException {
        if (!otd.isPresentable()) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0002);
        }
        XFormPresentationModel presentationModel = XFormPresentationModelHelper.generateDefaultPresentation(otd, name, options, attributesmap);
        otd.setPModel(presentationModel, name);
        XObjectTypeDescriptionHelper.ensureParents(presentationModel);
        return presentationModel;
    }

    public static void ensureParents(XFormXMLObject presentationModel) {
        for (int i = 0; i < presentationModel.getChildCount(); ++i) {
            XFormXMLObject child = presentationModel.getChildAt(i);
            if (child == null) continue;
            child.setParent(presentationModel);
            XObjectTypeDescriptionHelper.ensureParents(child);
        }
    }

    public static boolean areEditableMethodproperties(MethodTypeDescription mtd) {
        return XObjectTypeDescriptionHelper.isEditableMethod(mtd) && !mtd.isConstructor();
    }

    public static AttributeTypeDescription changeAttributeProfile(MethodTypeDescription member) throws ConstructionException {
        TypeDescription parent = member.getParent();
        assert (parent instanceof XObjectTypeDescription);
        AttributeTypeDescription attr = member.asAttribute();
        String name = attr.getName();
        TypeRef typeRef = attr.getTypeRef();
        boolean calculated = attr.isCalculated();
        XObjectTypeDescriptionHelper.removeMember((XObjectTypeDescription)parent, name);
        return XObjectTypeDescriptionHelper.addAttribute((XObjectTypeDescription)parent, name, typeRef, calculated ? null : SourceCode.create("", "Fuego"));
    }

    public static AttributeTypeDescription createAttribute(String name, TypeRef td, SourceCode calculateExpression) {
        AttributeTypeDescription member = new AttributeTypeDescription(name, td.get());
        member.setModifiers(member.getModifiers() | 0x8000L | 4L | 8L);
        XObjectTypeDescriptionHelper.attributeDefaultModifiers(member);
        member.setCode(calculateExpression);
        member.setCalculated(calculateExpression != null);
        return member;
    }

    public static MethodTypeDescription createMethod(String name, TypeDescription returnType, Argument[] inputArgs, String code, String codeLanguage) {
        MethodTypeDescription methodTD = new MethodTypeDescription(name);
        return XObjectTypeDescriptionHelper.setMethod(methodTD, returnType, inputArgs, code, codeLanguage);
    }

    public static XFormPresentationModel createPresentationModel(XObjectTypeDescription otd, String name, int row, int col, String color) {
        XFormPresentationModel presentationModel = new XFormPresentationModel(otd, name);
        presentationModel.presentation_d.table = new XFormTable();
        presentationModel.presentation_d.table.id = name + "table";
        presentationModel.presentation_d.table.expand(row, col);
        presentationModel.presentation_d.bgcolor = color;
        presentationModel.presentation_d.background = new XFormBackground();
        return presentationModel;
    }

    public static XObjectTypeDescription encapsulate(String name, ObjectTypeDescription otd) {
        ComponentCatalog catalog = otd.getCatalog();
        assert (catalog != null);
        XObjectTypeDescription result = XObjectFactory.createXObjectTypeDescription(name, false, catalog);
        result.addSuperType(new SuperType(otd, 0x808000L));
        return result;
    }

    public static boolean exportObject(ObjectTypeDescription obj, String fileName) throws IOException {
        StringWriter strWriter = new StringWriter();
        TypeWriter45.writeXML(obj, "component", strWriter);
        String xml = strWriter.toString();
        if (fileName.toLowerCase().endsWith(".xml") || fileName.toLowerCase().endsWith(".xcdl")) {
            FileWriter fw = new FileWriter(new File(fileName));
            fw.write(xml);
            fw.flush();
            return true;
        }
        if (fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".jar")) {
            JarWrapper jf = JarWrapper.createJar(fileName);
            ArrayList<TypeDescription> modules = new ArrayList<TypeDescription>();
            TypeDescription lastModule = obj.getParent();
            do {
                modules.add(lastModule);
            } while ((lastModule = lastModule.getParent()) != null && !"".equals(lastModule.getName().trim()));
            String prefix = "";
            for (int i = modules.size() - 1; i >= 0; --i) {
                lastModule = (TypeDescription)modules.get(i);
                prefix = prefix + lastModule.getName() + '/';
            }
            byte[] data = xml.getBytes("UTF8");
            jf.addFile(prefix + obj.getName() + ".xcdl", data);
            int innerTypeCount = obj.getInnerTypeCount();
            if (innerTypeCount > 0) {
                prefix = prefix + obj.getName() + '/';
                for (int j = 0; j < innerTypeCount; ++j) {
                    ObjectTypeDescription group = obj.getInnerType(j);
                    strWriter = new StringWriter();
                    TypeWriter45.writeXML(group, "component", strWriter);
                    String xmlGroup = strWriter.toString();
                    byte[] dataGroup = xmlGroup.getBytes("UTF8");
                    jf.addFile(prefix + group.getName() + ".xcdl", dataGroup);
                }
            }
            jf.close();
            return true;
        }
        return false;
    }

    public static boolean hasPrimaryKey(ObjectTypeDescription objectType) {
        for (MethodTypeDescription member : objectType.getAttributes()) {
            if (member.asAttribute().getPosition() <= 0) continue;
            return true;
        }
        return false;
    }

    public static void legacyXOMigration(XObjectTypeDescription xotd) throws ConstructionException {
        if (!XObjectTypeDescriptionHelper.isLegacyXO(xotd)) {
            return;
        }
        if (xotd.getInnerTypeCount() != 0) {
            for (MethodTypeDescription attribute : xotd.getAttributes()) {
                AttributeTypeDescription att = attribute.asAttribute();
                TypeDescription type = att.getResultType();
                if (!type.getJavaType().equals("oracle.bpm.util.LegacyGroupArray")) continue;
                ObjectTypeDescription group = type.getElementType().asObject();
                String arrayName = att.getName();
                xotd.removeMember(att);
                for (MethodTypeDescription groupMember : group.getAttributes()) {
                    String name = groupMember.getName();
                    if ("currentRow".equals(name)) continue;
                    MethodTypeDescription calcAttr = xotd.findMember(name);
                    xotd.removeMember(calcAttr);
                }
                XObjectTypeDescriptionHelper.addGroupAttribute(xotd, arrayName, group);
            }
        }
        xotd.setProperty("legacy", null);
        xotd.setVersionID("");
        assert (!XObjectTypeDescriptionHelper.isLegacyXO(xotd));
    }

    public static List<String> removeMember(ObjectTypeDescription parent, String name) throws ConstructionException {
        return XObjectTypeDescriptionHelper.removeMember(parent, name, false);
    }

    public static List<String> removeMember(ObjectTypeDescription parent, String name, boolean removePresentationReferences) throws ConstructionException {
        AttributeTypeDescription attr;
        String vvMtdText;
        ArrayList<String> removedMemberList = new ArrayList<String>();
        MethodTypeDescription member = parent.findMember(name);
        if (member == null) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0001(name));
        }
        if (removePresentationReferences) {
            XObjectTypeDescriptionHelper.removePresentationReferences(parent, member);
        }
        if (member.isMethod()) {
            MethodUsagesRemover mur = new MethodUsagesRemover(parent, member.getSignature());
            mur.startToGoOver();
            removedMemberList.addAll(mur.getReferencedAttributeNames());
        }
        if (member.isAttribute() && (vvMtdText = XObjectTypeDescriptionHelper.removeValidValuesDefinition(attr = (AttributeTypeDescription)member)) != null) {
            removedMemberList.add(vvMtdText);
        }
        if (member.isAttribute() && XObjectTypeDescription.isGroupAttribute(member.asAttribute())) {
            TypeRef group = parent.findInnerType(Identifier.classname(name));
            parent.removeInnerType(group);
        }
        parent.removeMember(member);
        return removedMemberList.isEmpty() ? null : removedMemberList;
    }

    public static void removeModel(XObjectTypeDescription parent, String name) {
        if (name.equals(parent.getDefaultPresentationName())) {
            parent.setDefaultPresentationName(null);
        }
        parent.removePModel(name);
        XFormPresentationModel[] models = parent.getPModels();
        if (models == null || models.length == 0) {
            parent.setDefaultPresentationName(null);
            XObjectFactory.setXOPresentable(parent, false);
        } else if (parent.getDefaultPresentationName() == null) {
            parent.setDefaultPresentationName(models[0].getModelName());
        }
    }

    public static String removeValidValuesDefinition(AttributeTypeDescription attr) {
        String vvMtdText = null;
        ObjectTypeDescription parent = (ObjectTypeDescription)attr.getParent();
        MethodTypeDescription vvMtd = parent.findMethod(attr.getName() + VVAL_POST_MTD);
        if (vvMtd != null) {
            vvMtdText = vvMtd.getName();
            parent.removeMember(vvMtd);
        }
        attr.setValidValuesMethod(null);
        attr.setProperty(VVAL_DESC_MTD_NAME_PROP, null);
        attr.setProperty(VVAL_DESC_MTD_SIGN_PROP, null);
        attr.setValidValues(null);
        attr.setProperty(VVAL_DESC_LIST, null);
        return vvMtdText;
    }

    public static String toString(XObjectTypeDescription xotd) {
        StringBuilder buffer = new StringBuilder(xotd.toString());
        buffer.append("\n");
        buffer.append("--- MEMBERS ---\n");
        for (int i = 0; i < xotd.getMemberCount(); ++i) {
            MethodTypeDescription member = xotd.getMemberType(i);
            buffer.append(member.toString());
            buffer.append("\n");
        }
        buffer.append("--- INNERS ---\n");
        for (int j = 0; j < xotd.getInnerTypeCount(); ++j) {
            ObjectTypeDescription inner = xotd.getInnerType(j);
            buffer.append(inner.toString());
            buffer.append("\n");
            buffer.append("--- INNER MEMBERS ---\n");
            for (int k = 0; k < inner.getMemberCount(); ++k) {
                MethodTypeDescription member = inner.getMemberType(k);
                buffer.append(member.toString());
                buffer.append("\n");
            }
            buffer.append("\n");
        }
        if (xotd.getPresentations() != null) {
            buffer.append("--- PRESENTATIONS ---\n");
            for (XFormPresentationModel xFormPresentationModel : xotd.getPresentations().values()) {
                buffer.append(xFormPresentationModel.getPresentationName());
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static Msg validateFuegoObjectInternalMethodName(String methodName) {
        Method[] mtds;
        if (methodName == null) {
            return null;
        }
        if ("validate".equals(methodName)) {
            return null;
        }
        for (Method mtd : mtds = Presentable.class.getMethods()) {
            if (!methodName.equals(mtd.getName())) continue;
            return XObjectRuntimeMsg.NAME_IS_RESERVED;
        }
        return null;
    }

    public static Msg validateFuegoObjectReservedName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(VVAL_POST_MTD)) {
            return XObjectRuntimeMsg.NAME_ENDS_WITH(VVAL_POST_MTD);
        }
        return null;
    }

    public static Msg validateMethodName(String name) {
        Msg msg;
        if (!Identifier.isValid(name)) {
            msg = XObjectRuntimeMsg.NOT_AN_IDENTIFIER(name);
        } else if (Character.isUpperCase(name.charAt(0))) {
            msg = XObjectRuntimeMsg.UPPERCASE_METHOD_NAME;
        } else {
            msg = XObjectTypeDescriptionHelper.validateFuegoObjectReservedName(name);
            if (msg == null) {
                msg = XObjectTypeDescriptionHelper.validateFuegoObjectInternalMethodName(name);
            }
        }
        return msg;
    }

    public static String getArrayPrefix(String arrayName) {
        return arrayName + "[].:";
    }

    static void removePresentationReferences(ObjectTypeDescription memberParent, MethodTypeDescription member) {
        XFormPresentationModel[] models;
        String relativeMemberName = member.getName();
        String relativeSignature = member.getSignature();
        if (memberParent.isInnerType()) {
            String groupName = memberParent.getName();
            relativeMemberName = XObjectTypeDescriptionHelper.getPresentationGroupAttributeName(groupName, relativeMemberName);
            relativeSignature = XObjectTypeDescriptionHelper.getRelativeSignature(groupName, relativeSignature);
        }
        if ((models = XObjectTypeDescriptionHelper.getReferencedPresentations(memberParent, member)) != null) {
            for (XFormPresentationModel model : models) {
                if ((member.isAttribute() || member.isArray()) && model.hasReferenceTo(relativeMemberName)) {
                    model.removeReferenceTo(relativeMemberName);
                }
                if (!member.isMethod()) continue;
                model.removeInvocationTo(relativeSignature);
            }
        }
    }

    private static String getRelativeSignature(String groupName, String relativeSignature) {
        char[] characters = groupName.toCharArray();
        if (characters.length > 0) {
            characters[0] = Character.toLowerCase(characters[0]);
        }
        return XObjectTypeDescriptionHelper.getArrayPrefix(new String(characters)) + relativeSignature;
    }

    private static String getPresentationGroupAttributeName(String groupName, String attributeName) {
        return Identifier.attribute(groupName) + "[]." + attributeName;
    }

    private static void setClientAvailable(MethodTypeDescription mtd) {
        if (Modifier.isServer(mtd.getModifiers())) {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFFEFFL);
            mtd.setModifiers(mtd.getModifiers() | 0x4000000000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() | 0x100L);
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFBFFFFFFFFFL);
        }
    }

    private static String getValueAsFBL(int kind, String value, boolean asString) {
        StringBuilder result = new StringBuilder();
        switch (kind) {
            case 7: {
                Interval interval;
                try {
                    interval = Interval.valueOf(value.trim());
                }
                catch (IntervalFormatException ife) {
                    try {
                        interval = IntervalFormat.getInstance().parse(value);
                    }
                    catch (ParseException e) {
                        interval = null;
                    }
                }
                if (interval == null) break;
                if (asString) {
                    result.append("\"");
                    result.append(interval.toString());
                    result.append("\"");
                    break;
                }
                result.append("'");
                result.append(interval.toString());
                result.append("'");
                break;
            }
            case 6: {
                Time t;
                try {
                    t = (Time)ConversionUtilities.fromString(value.trim(), 6);
                }
                catch (TimeFormatException tfe) {
                    tfe.printStackTrace();
                    t = null;
                }
                if (t == null) break;
                if (asString) {
                    result.append("\"");
                    result.append(ConversionUtilities.convertToString(t));
                    result.append("\"");
                    break;
                }
                result.append("'");
                result.append(ConversionUtilities.convertToString(t));
                result.append("'");
                break;
            }
            case 5: {
                result.append("\"");
                result.append(Str.escape(value));
                result.append("\"");
                break;
            }
            default: {
                if (asString) {
                    result.append("\"");
                    result.append(value);
                    result.append("\"");
                    break;
                }
                result.append(value != null ? value : value);
            }
        }
        return result.toString();
    }

    private static String buildFBLListCode(List validValuesList, TypeDescription type, boolean asString) {
        StringBuilder codeBuffer = new StringBuilder("return [");
        Iterator it = validValuesList.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            String fblValue = XObjectTypeDescriptionHelper.getValueAsFBL(type.getKind(), value, asString);
            codeBuffer.append(fblValue);
            if (!it.hasNext()) continue;
            codeBuffer.append(", ");
        }
        codeBuffer.append("]");
        return codeBuffer.toString();
    }

    private static String buildFBLMapCode(List validValuesList, List validValuesDescription, TypeDescription type, boolean asString) {
        StringBuilder codeBuffer = new StringBuilder("return [");
        Iterator valueIterator = validValuesList.iterator();
        Iterator descrIterator = validValuesDescription.iterator();
        while (valueIterator.hasNext()) {
            String value = (String)valueIterator.next();
            String descr = (String)descrIterator.next();
            String fblValue = XObjectTypeDescriptionHelper.getValueAsFBL(type.getKind(), value, asString);
            String fblDescr = XObjectTypeDescriptionHelper.getValueAsFBL(5, descr, asString);
            codeBuffer.append(fblValue);
            codeBuffer.append(" : ");
            codeBuffer.append(fblDescr);
            if (!valueIterator.hasNext()) continue;
            codeBuffer.append(",");
        }
        codeBuffer.append("]");
        return codeBuffer.toString();
    }

    private static MethodTypeDescription setMethod(MethodTypeDescription methodTD, TypeDescription returnType, Argument[] inputArgs, String code, String codeLanguage) {
        XObjectTypeDescriptionHelper.methodDefaultModifiers(methodTD);
        methodTD.setResultType(returnType);
        methodTD.setArguments(inputArgs);
        methodTD.setSignature(methodTD.getJavaSignature());
        if (code != null) {
            methodTD.setCode(code, codeLanguage);
        }
        return methodTD;
    }

    private static void addValidValuesDefinition(ObjectTypeDescription parent, AttributeTypeDescription attr, StringBuffer methodCode, boolean hasDescription) {
        TypeDescription returnType = hasDescription ? TypeFactory.getMap(TypeFactory.getString(), attr.getResultArgument().getTypeRef()) : TypeFactory.getArray(attr.getResultArgument().getTypeRef());
        String methodName = attr.getName() + VVAL_POST_MTD;
        MethodTypeDescription vvMtd = parent.findMethod(attr.getName() + VVAL_POST_MTD);
        if (vvMtd != null) {
            XObjectTypeDescriptionHelper.setMethod(vvMtd, returnType, new Argument[0], methodCode.toString(), "Fuego");
        } else {
            try {
                XObjectTypeDescriptionHelper.addValidValuesMethod(parent, methodName, returnType, new Argument[0], methodCode.toString(), "Fuego");
            }
            catch (ConstructionException ce) {
                throw new RuntimeException(ce);
            }
        }
    }

    private static MethodTypeDescription addValidValuesMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, Argument[] inputArgs, String code, String codeLanguage) throws ConstructionException {
        XObjectTypeDescriptionHelper.validateMethodName(obj, name, true);
        MethodTypeDescription methodTD = XObjectTypeDescriptionHelper.createMethod(name, returnType, inputArgs, code, codeLanguage);
        return XObjectTypeDescriptionHelper.doAddMethod(obj, methodTD);
    }

    private static void attributeDefaultModifiers(AttributeTypeDescription atd) {
        XObjectTypeDescriptionHelper.setPublic(atd, true);
        XObjectTypeDescriptionHelper.setStatic(atd, false);
    }

    private static MethodTypeDescription doAddMethod(ObjectTypeDescription obj, MethodTypeDescription mtd) {
        obj.addMember(mtd);
        return mtd;
    }

    private static void methodDefaultModifiers(MethodTypeDescription mtd) {
        XObjectTypeDescriptionHelper.setPublic(mtd, true);
        XObjectTypeDescriptionHelper.setStatic(mtd, false);
        XObjectTypeDescriptionHelper.setServerSide(mtd, false);
    }

    private static boolean validateAttributeName(ObjectTypeDescription parent, String name) throws ConstructionException {
        if (name == null || "".equals(name.trim())) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0009);
        }
        int c = name.codePointAt(0);
        if (!Character.isLetter(c) || !Identifier.isValid(name)) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0007(name));
        }
        if (XObjectTypeDescriptionHelper.isFuegoObjectReservedName(name)) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0008(name));
        }
        if (parent.findMember(name, TypeFinder.Scope.CURRENT) != null) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0005(name));
        }
        return true;
    }

    private static boolean validateMethodName(ObjectTypeDescription parent, String name, boolean isReservedName) throws ConstructionException {
        if (name == null || "".equals(name.trim())) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0009);
        }
        char c = name.charAt(0);
        if (Character.isUpperCase(c) || !Identifier.isValid(name)) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0007(name));
        }
        if (!isReservedName && (XObjectTypeDescriptionHelper.isFuegoObjectReservedName(name) || XObjectTypeDescriptionHelper.isFuegoObjectInternalMethodName(name))) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0008(name));
        }
        if (parent.findMember(name, TypeFinder.Scope.CURRENT) != null) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0005(name));
        }
        return true;
    }

    private static boolean validatePresentationName(XObjectTypeDescription parent, String name) throws ConstructionException {
        if (name == null || "".equals(name.trim())) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0009);
        }
        if (parent.getPresentationModel(name) != null) {
            throw new ConstructionException(XObjectRuntimeMsg.XOBJLIB_CONST_0005(name));
        }
        return true;
    }
}

