/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Pattern;
import oracle.bpm.lang.Kind;
import oracle.bpm.util.Pair;
import oracle.bpm.xobject.runtime.ConversionUtilities;
import oracle.bpm.xobjectruntime.msg.XObjectRuntimeMsg;

public class MaskUtilities {
    public static final char NUM_FORMAT_CHAR = '#';
    public static final char UPPER_ALPHA_FORMAT_CHAR = 'U';
    public static final char LOWER_ALPHA_FORMAT_CHAR = 'L';
    public static final char ALPHA_FORMAT_CHAR = '?';
    public static final char ALPHA_NUM_FORMAT_CHAR = 'A';
    public static final char ANY_FORMAT_CHAR = '*';
    public static final char ESCAPE_FORMAT_CHAR = '\'';
    private static final String NUM_REG_EXP = "^([0-9]*)$";
    private static final String ALPHA_REG_EXP = "^([a-zA-Z]*)$";
    private static final String ALPHA_NUM_REG_EXP = "^([a-zA-Z0-9]*)$";

    public static String applyGenericOutputMask(Locale locale, String theMask, String valueStr, int kind) {
        if (valueStr != null && valueStr.trim().length() > 0) {
            StringBuffer withMaskValue = new StringBuffer();
            int indexOfValue = valueStr.length();
            block8: for (int i = theMask.length() - 1; i >= 0; --i) {
                char theMaskChar = theMask.charAt(i);
                switch (theMaskChar) {
                    case '#': 
                    case '*': 
                    case '?': 
                    case 'A': 
                    case 'L': 
                    case 'U': {
                        --indexOfValue;
                        if (i - 1 >= 0 && theMask.charAt(i - 1) == '\'') {
                            --i;
                            withMaskValue.insert(0, theMaskChar);
                            if (indexOfValue < 0 || theMaskChar != valueStr.charAt(indexOfValue)) continue block8;
                            --indexOfValue;
                            continue block8;
                        }
                        if (indexOfValue < 0) {
                            switch (theMaskChar) {
                                case '#': {
                                    withMaskValue.insert(0, 0);
                                    break;
                                }
                                case '*': 
                                case '?': 
                                case 'A': 
                                case 'L': 
                                case 'U': {
                                    withMaskValue.insert(0, ' ');
                                }
                            }
                            continue block8;
                        }
                        char character = valueStr.charAt(indexOfValue);
                        if (MaskUtilities.testCharacter(theMaskChar, character)) {
                            withMaskValue.insert(0, MaskUtilities.tranformCharacter(theMaskChar, character));
                            continue block8;
                        }
                        throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(valueStr, theMask).getString());
                    }
                    case '\'': {
                        continue block8;
                    }
                    default: {
                        boolean appendChar = true;
                        if (indexOfValue - 1 < 0) {
                            if (theMask.length() == 0) {
                                appendChar = false;
                            }
                        } else if (theMaskChar == valueStr.charAt(indexOfValue - 1)) {
                            --indexOfValue;
                        }
                        if (!appendChar) continue block8;
                        withMaskValue.insert(0, theMaskChar);
                    }
                }
            }
            if (indexOfValue >= 0) {
                withMaskValue.insert(0, valueStr.substring(0, indexOfValue));
            }
            return withMaskValue.toString();
        }
        return valueStr;
    }

    public static String applyMask(String theMask, String value) {
        String withMaskValue = "";
        int indexOfValue = -1;
        boolean hasMaskTheValue = false;
        Pair maskLengths = MaskUtilities.getMaskLength(theMask);
        int withoutEscapeLength = (Integer)maskLengths.first;
        int inputMaskLength = (Integer)maskLengths.second;
        if (value.length() == withoutEscapeLength) {
            hasMaskTheValue = true;
        } else if (value.length() > inputMaskLength) {
            throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(value, theMask).getString());
        }
        block4: for (int i = 0; i < theMask.length(); ++i) {
            char theMaskChar = theMask.charAt(i);
            switch (theMaskChar) {
                case '#': 
                case '*': 
                case '?': 
                case 'A': 
                case 'L': 
                case 'U': {
                    if (++indexOfValue >= value.length()) {
                        throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(value, theMask).getString());
                    }
                    char character = value.charAt(indexOfValue);
                    if (MaskUtilities.testCharacter(theMaskChar, character)) {
                        withMaskValue = withMaskValue.concat(String.valueOf(MaskUtilities.tranformCharacter(theMaskChar, character)));
                        continue block4;
                    }
                    throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(value, theMask).getString());
                }
                case '\'': {
                    if (i + 1 < theMask.length()) {
                        withMaskValue = withMaskValue.concat(String.valueOf(theMask.charAt(++i)));
                        if (!hasMaskTheValue || value.charAt(indexOfValue + 1) != theMask.charAt(i)) continue block4;
                        ++indexOfValue;
                        continue block4;
                    }
                    throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(value, theMask).getString());
                }
                default: {
                    withMaskValue = withMaskValue.concat(String.valueOf(theMaskChar));
                    if (!hasMaskTheValue || theMaskChar != value.charAt(indexOfValue + 1)) continue block4;
                    ++indexOfValue;
                }
            }
        }
        return withMaskValue;
    }

    public static String applyNumericOutputMask(Locale locale, String theMask, String valueStr, int kind) {
        String valueWithMask = valueStr;
        if (valueStr != null && (Kind.isNumber(kind) || kind == 5)) {
            Number theNumber;
            if (Kind.isNumber(kind)) {
                theNumber = (Number)ConversionUtilities.fromString(valueStr, kind, locale);
            } else {
                DecimalFormat decimalFormat = new DecimalFormat();
                DecimalFormat decimalFormatWithPattern = new DecimalFormat(theMask);
                try {
                    theNumber = decimalFormat.parse(valueStr);
                }
                catch (ParseException e) {
                    try {
                        theNumber = decimalFormatWithPattern.parse(valueStr);
                    }
                    catch (ParseException e1) {
                        throw new RuntimeException(XObjectRuntimeMsg.OUTPUT_MASK_NOT_MATCH(valueStr, theMask).getString());
                    }
                }
            }
            if (theNumber != null) {
                valueWithMask = new DecimalFormat(theMask, new DecimalFormatSymbols(locale)).format(theNumber);
            }
        }
        return valueWithMask;
    }

    public static String cleanMask(String theMask, String value) {
        if (value == null) {
            return null;
        }
        String withoutMaskValue = "";
        if (((Integer)MaskUtilities.getMaskLength((String)theMask).first).intValue() != value.length()) {
            return null;
        }
        int indexOfValueWithMask = -1;
        block4: for (int i = 0; i < theMask.length(); ++i) {
            char theMaskChar = theMask.charAt(i);
            switch (theMaskChar) {
                case '#': 
                case '*': 
                case '?': 
                case 'A': 
                case 'L': 
                case 'U': {
                    char character = value.charAt(++indexOfValueWithMask);
                    if (!MaskUtilities.testCharacter(theMaskChar, character)) {
                        return null;
                    }
                    withoutMaskValue = withoutMaskValue.concat(String.valueOf(character));
                    continue block4;
                }
                case '\'': {
                    ++i;
                    ++indexOfValueWithMask;
                    continue block4;
                }
                default: {
                    ++indexOfValueWithMask;
                }
            }
        }
        return withoutMaskValue;
    }

    private static Pair getMaskLength(String mask) {
        char[] characters = mask.toCharArray();
        int qtyEscape = 0;
        int inputLength = 0;
        block4: for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            switch (character) {
                case '\'': {
                    ++qtyEscape;
                    if (i + 1 >= characters.length || characters[i + 1] != '\'') continue block4;
                    ++i;
                    continue block4;
                }
                case '#': 
                case '*': 
                case '?': 
                case 'A': 
                case 'L': 
                case 'U': {
                    if (i - 1 >= 0) {
                        if (characters[i - 1] == '\'') continue block4;
                        ++inputLength;
                        continue block4;
                    }
                    ++inputLength;
                    continue block4;
                }
            }
        }
        return new Pair(mask.length() - qtyEscape, inputLength);
    }

    private static boolean testCharacter(char maskCharacter, char character) {
        switch (maskCharacter) {
            case '#': {
                return Pattern.matches(NUM_REG_EXP, String.valueOf(character));
            }
            case '?': 
            case 'L': 
            case 'U': {
                return Pattern.matches(ALPHA_REG_EXP, String.valueOf(character));
            }
            case 'A': {
                return Pattern.matches(ALPHA_NUM_REG_EXP, String.valueOf(character));
            }
            case '*': {
                return true;
            }
        }
        return false;
    }

    private static char tranformCharacter(char maskCharacter, char character) {
        switch (maskCharacter) {
            case 'U': {
                return String.valueOf(character).toUpperCase().toCharArray()[0];
            }
            case 'L': {
                return String.valueOf(character).toLowerCase().toCharArray()[0];
            }
        }
        return character;
    }
}

