/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.subcontroller;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ResizeSubcontroller<T>
extends SubcontrollerImpl<T> {
    protected ResizeSubcontroller(Controller<T> controller, Drawable<T> drawable) {
        super(controller, drawable);
        this.install(new FocusCapability(this));
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.SE_RESIZE_CURSOR;
    }

    protected static class DrawableHandlerResize<T>
    extends DrawableImpl<T> {
        private final Controller<T> container;
        private final Image handler;

        public DrawableHandlerResize(@NotNull Controller<T> container, @NotNull Image handler) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
            this.handler = handler;
        }

        @NotNull
        public Rectangle getBounds() {
            Rectangle result = this.container.getSelection().isPrimary() ? Rectangle.valueOf(this.getContainer().getWidth() - this.handler.getWidth() + 2, this.getContainer().getHeight() - this.handler.getHeight() + 2, this.handler.getWidth(), this.handler.getHeight()) : Rectangle.ZERO;
            return result;
        }

        public void draw() {
            if (this.container.getSelection().isPrimary()) {
                Rectangle bounds = this.getBounds();
                DiagramContext context = this.getContext();
                Graphics graphics = context.getGraphics();
                graphics.drawImage(this.handler, bounds.scaled(context.getScale()));
            }
        }
    }
}

