/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.subcontroller;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableConnection;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.diagram.editor.ConnectionController;
import oracle.bpm.diagram.editor.capability.edit.ParentContainerEditCapability;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.capability.selection.ParentContainerSelectionCapability;
import oracle.bpm.diagram.editor.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Cursor;
import org.jetbrains.annotations.NotNull;

public class AnchorSubcontroller<T>
extends SubcontrollerImpl<T> {
    private final DrawableUtils.TransitionAnchor anchor;

    protected AnchorSubcontroller(@NotNull ConnectionController<T> controller, @NotNull DrawableUtils.TransitionAnchor anchor) {
        super(controller, new DrawableAnchor(controller, anchor));
        this.anchor = anchor;
        this.install(new FocusCapability(this));
        this.install(new ParentContainerEditCapability(this));
        this.install(new ParentContainerSelectionCapability(this));
    }

    public static <T> AnchorSubcontroller<T> appendTo(@NotNull ConnectionController<T> controller, @NotNull DrawableUtils.TransitionAnchor anchor) {
        AnchorSubcontroller<T> subcontroller = new AnchorSubcontroller<T>(controller, anchor);
        subcontroller.add();
        return subcontroller;
    }

    @Override
    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    public DrawableUtils.TransitionAnchor getAnchor() {
        return this.anchor;
    }

    @Override
    @NotNull
    public ConnectionController getContainer() {
        return (ConnectionController)super.getContainer();
    }

    private static class DrawableAnchor<T>
    extends DrawableImpl<T>
    implements Renderer {
        private final DrawableUtils.TransitionAnchor anchor;
        private final ConnectionController<T> container;
        private static final int ANCHOR_HIT_TOLERANCE = 10;

        private DrawableAnchor(@NotNull ConnectionController<T> container, @NotNull DrawableUtils.TransitionAnchor anchor) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
            this.anchor = anchor;
            this.attachRenderer(this);
        }

        public boolean contains(int x, int y) {
            boolean result = this.anchor == DrawableUtils.TransitionAnchor.MIDDLE || this.getBounds().expand(10).contains(x, y);
            return result;
        }

        @NotNull
        public Rectangle getBounds() {
            Point location = this.getLocationInPath();
            return Rectangle.createAround(location, 5);
        }

        public void render() {
            if (this.getContainer().isShowSelection() && this.anchor != DrawableUtils.TransitionAnchor.MIDDLE) {
                DiagramContext context = this.getContext();
                Graphics graphics = context.getGraphics();
                Rectangle bounds = this.getBounds();
                graphics.fill(new Ellipse(context.scale(bounds)));
            }
        }

        private Point getLocationInPath() {
            Point result;
            DrawableConnection<T> flow = this.container.getDrawableObject();
            switch (this.anchor) {
                case FROM: {
                    result = new Point(flow.getPath().eval(0.0));
                    break;
                }
                case MIDDLE: {
                    result = new Point(flow.getPath().eval(0.5));
                    break;
                }
                case TO: {
                    result = new Point(flow.getPath().eval(1.0));
                    break;
                }
                default: {
                    result = Point.ORIGIN;
                }
            }
            return result.translate(flow.getBounds().getOrigin().flip());
        }
    }
}

