/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.state;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.command.Command;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.LabelController;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityHelper;
import oracle.bpm.diagram.editor.capability.CapabilityModifiers;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.SpecifiedResult;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointerState
extends AbstractDesignerState {
    private List<SpecifiedResult> draggings = new LinkedList<SpecifiedResult>();
    private static final Predicate<Controller> AVOID_LABELS = new Predicate<Controller>(){

        @Override
        public boolean check(@Nullable Controller value) {
            return !(value instanceof LabelController);
        }
    };

    @Override
    public void mousePressed(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller;
        SpecifiedResult result;
        if (MouseEventUtilities.isPopupTrigger(mouse) && (result = CapabilityHelper.specify(controller = this.findAnyController(unscaled), CapabilityType.POP_UP, CapabilityModifiers.create(mouse.getModifiers()))) != null) {
            CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
            this.processCommand(result, event);
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        if (this.draggings.isEmpty()) {
            this.mouseMoved(mouse, unscaled);
            this.startDrag(mouse, unscaled);
        }
        if (!this.draggings.isEmpty()) {
            this.drag(mouse, unscaled);
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        this.handleSelection(mouse, unscaled, PredicateUtils.<Controller>truePredicate());
    }

    @Override
    public void mouseMoved(MouseEvent mouse, Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        SpecifiedResult result = CapabilityHelper.specify(controller, CapabilityType.FOCUS, CapabilityModifiers.create(mouse.getModifiers()));
        if (result != null) {
            CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
            this.processCommand(result, event);
        }
    }

    @Override
    public void mouseDoubleClicked(MouseEvent event, Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled);
        this.edit(controller, CapabilityType.EDIT);
    }

    @Override
    public void enteredPressed() {
        Selection selection = this.getDomain().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            this.edit(selection.as(Controller.class), CapabilityType.EDIT);
        }
    }

    @Override
    public void deletePressed() {
        this.getDomainStateManager().deletePressed();
    }

    @Override
    public void cancel() {
        for (SpecifiedResult result : this.draggings) {
            CapabilityEvent event = CapabilityEvent.create(result, Point.ORIGIN);
            result.getCapability().cancelAnyVisuals(event);
        }
        this.draggings.clear();
        super.cancel();
    }

    protected List<Controller> filterSelection(List<Controller> controllers) {
        return controllers;
    }

    private void startDrag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        this.handleDragSelection(mouse, unscaled);
        CapabilityModifiers modifiers = CapabilityModifiers.create(mouse.getModifiers());
        SpecifiedResult specified = CapabilityHelper.specify(this.findAnyController(unscaled, AVOID_LABELS), CapabilityType.DRAG, modifiers);
        List<Controller> selection = this.filterSelection(this.getDomain().getSelectionProvider().getSelection().asList(Controller.class));
        if (!selection.isEmpty() && specified != null) {
            this.draggings.clear();
            for (Controller selected : selection) {
                SpecifiedResult result = CapabilityHelper.specify(selected, specified.getSpecified(), modifiers);
                if (result == null) continue;
                this.draggings.add(result);
                CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
                result.getCapability().showSourceVisuals(event);
            }
        }
    }

    private void drag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> target = this.findAnyController(unscaled);
        for (SpecifiedResult result : this.draggings) {
            CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
            event.setTarget(target);
            result.getCapability().showSourceVisuals(event);
        }
    }

    private void stopDrag(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        for (SpecifiedResult dragging : this.draggings) {
            CapabilityEvent event = CapabilityEvent.create(dragging, unscaled, mouse);
            dragging.getCapability().eraseSourceVisuals(event);
            this.processCommand(dragging, event);
        }
        this.draggings.clear();
        this.getDomain().getCanvas().repaint();
    }

    private void handleDragSelection(@NotNull MouseEvent mouse, @NotNull Point unscaled) {
        Controller<?> controller = this.findAnyController(unscaled, AVOID_LABELS);
        if (controller.getSelection().isSelected()) {
            if (!controller.getSelection().isPrimary()) {
                this.getDomain().getSelectionProvider().append(controller);
            }
        } else {
            this.handleSelection(mouse, unscaled, AVOID_LABELS);
        }
    }

    private void handleSelection(@NotNull MouseEvent mouse, @NotNull Point unscaled, @NotNull Predicate<Controller> check) {
        if (this.draggings.isEmpty()) {
            Controller<?> controller = this.findAnyController(unscaled, check);
            SpecifiedResult result = CapabilityHelper.specify(controller, CapabilityType.SELECTION, CapabilityModifiers.create(mouse.getModifiers()));
            if (result != null) {
                CapabilityEvent event = CapabilityEvent.create(result, unscaled, mouse);
                this.processCommand(result, event);
            }
        } else {
            this.stopDrag(mouse, unscaled);
        }
    }

    private void edit(@NotNull Controller controller, @NotNull CapabilityType type) {
        SpecifiedResult result = CapabilityHelper.specify(controller, type, CapabilityModifiers.DEFAULT);
        if (result != null) {
            CapabilityEvent event = CapabilityEvent.create(result, Point.ORIGIN);
            this.processCommand(result, event);
        }
    }

    private void processCommand(@NotNull SpecifiedResult result, @NotNull CapabilityEvent event) {
        Command command = result.getCapability().process(event);
        if (command != null) {
            this.getDomainStateManager().runCommand(command);
            result.getCapability().consolidate(event);
        }
    }
}

