/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.state;

import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.Domain;
import oracle.bpm.diagram.editor.DomainSelectionProvider;
import oracle.bpm.diagram.editor.DomainStateManager;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDesignerState {
    protected DomainStateManager manager;
    private Domain domain;

    public DomainStateManager getDomainStateManager() {
        return this.manager;
    }

    public void mousePressed(MouseEvent event, Point unscaled) {
    }

    public void mouseReleased(MouseEvent event, Point unscaled) {
    }

    public void mouseMoved(MouseEvent event, Point unscaled) {
    }

    public void mouseEntered() {
    }

    public void mouseExited() {
    }

    public void mouseDragged(MouseEvent event, Point unscaled) {
    }

    public void mouseClicked() {
    }

    public void mouseDoubleClicked(MouseEvent event, Point unscaled) {
    }

    public void cancel() {
        this.finished();
    }

    public void finished() {
        this.stateFinished();
    }

    public void deletePressed() {
    }

    public void controlPressed() {
    }

    public void shiftPressed() {
    }

    public void shiftReleased() {
    }

    public void controlReleased() {
    }

    public void enteredPressed() {
    }

    public void escapePressed() {
        this.cancel();
    }

    public void setStateManager(@NotNull DomainStateManager manager) {
        this.manager = manager;
    }

    public final Domain getDomain() {
        if (this.domain == null && this.manager != null) {
            this.domain = this.manager.getDomain();
        }
        return this.domain;
    }

    public final boolean isShiftPressed() {
        return this.getDomainStateManager().isShiftPressed();
    }

    public final boolean isControlPressed() {
        return this.getDomainStateManager().isControlPressed();
    }

    public void init() {
    }

    public void copyPressed() {
    }

    protected void stateFinished() {
        this.getDomain().getSelectionProvider().clear();
        this.getDomain().getStateManager().setDefaultState();
    }

    @NotNull
    protected Controller<?> findAnyController(@NotNull Point unscaled) {
        return this.findAnyController(unscaled, PredicateUtils.<Controller>truePredicate());
    }

    @NotNull
    protected Controller<?> findAnyController(@NotNull Point unscaled, @NotNull Predicate<Controller> check) {
        Controller<?> result = this.getDomain().findController(PredicateUtils.<Controller>truePredicate(), unscaled.getX(), unscaled.getY(), check);
        if (result == null) {
            throw new IllegalStateException("Controller not found at any level!");
        }
        return result;
    }

    protected DomainSelectionProvider getSelectionProvider() {
        return this.getDomain().getSelectionProvider();
    }
}

