/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.editor.capability.selection;

import oracle.bpm.command.Command;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.DomainSelectionProvider;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapabilityEvent;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.ui.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class ElementSelectionCapability
extends Capability {
    public ElementSelectionCapability(@NotNull CapableController controller) {
        this(CapabilityType.SELECTION, controller);
    }

    protected ElementSelectionCapability(@NotNull CapabilityType type, @NotNull CapableController controller) {
        super(type, controller);
    }

    @Override
    public Command process(@NotNull CapabilityEvent event) {
        boolean isPopup;
        DomainSelectionProvider provider = this.getDomain().getSelectionProvider();
        MouseEvent mouse = event.getEvent();
        boolean shift = mouse != null && mouse.isShiftDown();
        boolean control = mouse != null && mouse.isControlDown();
        boolean selected = this.getSelectableController().getSelection().isSelected();
        boolean bl = isPopup = event.getType() == CapabilityType.POP_UP;
        if (shift || control && !selected) {
            Controller capableController = this.getSelectableController();
            provider.append(capableController);
        } else if (control && selected) {
            provider.remove(this.getSelectableController());
        } else if (!isPopup || !selected) {
            provider.setSelection(this.getSelectableController());
        }
        return null;
    }

    protected Controller getSelectableController() {
        return this.getController();
    }
}

